/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.timer;

import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.Timer;
import com.spacekiller.util.TimerQueue;
import com.spacekiller.util.timer.DefaultTimer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultTimerQueue
implements TimerQueue {
    private static final Logger logger = Logger.getLogger(DefaultTimerQueue.class.getName());
    private static final long ORIGIN = System.currentTimeMillis();
    private final Worker worker = new Worker();
    private ThreadManager threadManager;
    private String threadName;
    private int threadPriority;
    private Thread thread;
    private boolean running;
    private volatile boolean cancel;
    private volatile long nextTime = Long.MAX_VALUE;
    private DefaultTimer first;
    private DefaultTimer last;
    private int count;

    public DefaultTimerQueue(ThreadManager threadManager, String threadName, int threadPriority) {
        this.threadManager = threadManager;
        this.threadName = threadName;
        this.threadPriority = threadPriority;
    }

    public Timer createTimer(Runnable target, int delay, boolean repeats) {
        if (target == null) {
            throw new NullPointerException("target");
        }
        return new DefaultTimer(this, target, delay, repeats);
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void start() {
        this.cancel = false;
        if (this.running) {
            return;
        }
        this.thread = new Thread((Runnable)this.worker, this.threadName);
        this.thread.setDaemon(true);
        this.thread.setPriority(this.threadPriority);
        this.thread.start();
    }

    public synchronized void stop() {
        this.cancel = true;
        this.notifyAll();
    }

    public void join() throws InterruptedException {
        Thread t = this.thread;
        if (t != null) {
            t.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loop() {
        while (true) {
            DefaultTimer timer;
            DefaultTimerQueue defaultTimerQueue = this;
            synchronized (defaultTimerQueue) {
                if (this.cancel) {
                    this.running = false;
                    break;
                }
                long tt = System.currentTimeMillis() - ORIGIN;
                long wm = this.nextTime - tt;
                if (wm > 0L) {
                    try {
                        this.wait(wm);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
                timer = this.first;
                if (timer == null) {
                    try {
                        this.wait(0L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
                if (timer.repeats) {
                    timer.time = tt += (long)timer.delay;
                    DefaultTimer t = timer.next;
                    while (t != null && t.time <= tt) {
                        t = t.next;
                    }
                    if (t != timer.next) {
                        this.first = timer.next;
                        if (this.first == null) {
                            this.last = null;
                        } else {
                            this.first.prev = null;
                        }
                        timer.next = t;
                        if (t == null) {
                            timer.prev = this.last;
                            this.last.next = timer;
                            this.last = timer;
                        } else {
                            timer.prev = t.prev;
                            t.prev.next = timer;
                            t.prev = timer;
                        }
                    }
                    this.nextTime = this.first.time;
                } else {
                    timer.active = false;
                    --this.count;
                    this.first = timer.next;
                    timer.next = null;
                    if (this.first == null) {
                        this.last = null;
                        this.nextTime = Long.MAX_VALUE;
                    } else {
                        this.first.prev = null;
                        this.nextTime = this.first.time;
                    }
                }
            }
            try {
                timer.target.run();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isActive(DefaultTimer timer) {
        DefaultTimerQueue defaultTimerQueue = this;
        synchronized (defaultTimerQueue) {
            return timer.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(DefaultTimer timer) {
        if (timer.queue != this) {
            throw new IllegalArgumentException("Invalid timer: " + timer);
        }
        DefaultTimerQueue defaultTimerQueue = this;
        synchronized (defaultTimerQueue) {
            long tt;
            if (timer.active) {
                return;
            }
            timer.time = tt = System.currentTimeMillis() - ORIGIN + (long)timer.delay;
            timer.active = true;
            ++this.count;
            DefaultTimer t = this.first;
            while (t != null && t.time <= tt) {
                t = t.next;
            }
            if (t == null) {
                timer.prev = this.last;
                timer.next = null;
                if (this.last == null) {
                    this.last = timer;
                    this.first = timer;
                    this.nextTime = tt;
                    this.notifyAll();
                    return;
                }
                this.last.next = timer;
                this.last = timer;
                return;
            }
            timer.next = t;
            if (t == this.first) {
                timer.prev = null;
                t.prev = timer;
                this.first = timer;
                this.nextTime = tt;
                this.notifyAll();
                return;
            }
            timer.prev = t.prev;
            t.prev.next = timer;
            t.prev = timer;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop(DefaultTimer timer) {
        if (timer.queue != this) {
            throw new IllegalArgumentException("Invalid timer: " + timer);
        }
        DefaultTimerQueue defaultTimerQueue = this;
        synchronized (defaultTimerQueue) {
            if (!timer.active) {
                return;
            }
            timer.active = false;
            --this.count;
            if (timer == this.first) {
                this.first = timer.next;
                timer.next = null;
                if (this.first == null) {
                    this.last = null;
                    this.nextTime = Long.MAX_VALUE;
                    return;
                }
                this.first.prev = null;
                this.nextTime = this.first.time;
                this.notifyAll();
                return;
            }
            if (timer == this.last) {
                this.last = timer.prev;
                this.last.next = null;
                timer.prev = null;
                return;
            }
            timer.prev.next = timer.next;
            timer.next.prev = timer.prev;
            timer.prev = null;
            timer.next = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjust(DefaultTimer timer) {
        if (timer.queue != this) {
            throw new IllegalArgumentException("Invalid timer: " + timer);
        }
        DefaultTimerQueue defaultTimerQueue = this;
        synchronized (defaultTimerQueue) {
            if (!timer.active) {
                return;
            }
            long tt = System.currentTimeMillis() - ORIGIN + (long)timer.delay;
            if (timer.time < tt) {
                tt = timer.time;
            } else {
                timer.time = tt;
            }
            DefaultTimer t = timer.prev;
            if (t != null && t.time > tt) {
                t = t.prev;
                while (t != null && t.time > tt) {
                    t = t.prev;
                }
                timer.prev.next = timer.next;
                if (timer == this.last) {
                    this.last = timer.prev;
                } else {
                    timer.next.prev = timer.prev;
                }
                timer.prev = t;
                if (t == null) {
                    timer.next = this.first;
                    if (this.first != null) {
                        this.first.prev = timer;
                    }
                    this.first = timer;
                    if (tt < this.nextTime) {
                        this.nextTime = tt;
                        this.notifyAll();
                    }
                    return;
                }
                timer.next = t.next;
                if (t.next != null) {
                    t.next.prev = timer;
                }
                t.next = timer;
                return;
            }
            t = timer.next;
            if (t != null && t.time < tt) {
                t = t.next;
                while (t != null && t.time < tt) {
                    t = t.next;
                }
                timer.next.prev = timer.prev;
                if (timer == this.first) {
                    this.first = timer.next;
                    this.nextTime = this.first == null ? Long.MAX_VALUE : this.first.time;
                } else {
                    timer.prev.next = timer.next;
                }
                timer.next = t;
                if (t == null) {
                    timer.prev = this.last;
                    if (this.last != null) {
                        this.last.next = timer;
                    }
                    this.last = timer;
                } else {
                    timer.prev = t.prev;
                    if (t.prev != null) {
                        t.prev.next = timer;
                    }
                    t.prev = timer;
                }
                return;
            }
            return;
        }
    }

    public synchronized int getActiveCount() {
        return this.count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkConsistency() throws IllegalStateException {
        int num = 0;
        DefaultTimer pre = null;
        DefaultTimerQueue defaultTimerQueue = this;
        synchronized (defaultTimerQueue) {
            DefaultTimer t = this.first;
            while (t != null) {
                ++num;
                if (t.prev != pre) {
                    throw new IllegalStateException("Invalid prev timer: " + t.prev + " != " + pre);
                }
                if (pre != null && pre.time > t.time) {
                    throw new IllegalStateException("Invalid prev time: " + pre.time + " > " + t.time);
                }
                pre = t;
                t = t.next;
            }
            if (pre != this.last) {
                throw new IllegalStateException("Invalid last timer: " + pre + " != " + this.last);
            }
            if (num != this.count) {
                // empty if block
            }
        }
        return num;
    }

    protected class Worker
    implements Runnable {
        protected Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Timer queue started: " + DefaultTimerQueue.this);
            }
            try {
                if (DefaultTimerQueue.this.threadManager != null) {
                    DefaultTimerQueue.this.threadManager.registerThread(Thread.currentThread());
                }
                DefaultTimerQueue.this.loop();
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Timer queue stopped: " + DefaultTimerQueue.this);
                }
                if (DefaultTimerQueue.this.threadManager != null) {
                    DefaultTimerQueue.this.threadManager.unregisterThread(Thread.currentThread());
                }
            }
        }
    }
}

