/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.FaderPoint;
import com.waxmonster.editor.FaderPointRenderer;
import com.waxmonster.editor.WaxEditorItem;

public abstract class AbstractFaderPoint
implements FaderPoint {
    protected final WaxEditorItem item;
    protected final FaderMove move;
    private double startOffset;
    private double startTime;
    private double timeLength;
    private double pointTime;
    private double pointValue;
    private double pointSize;
    private FaderPointRenderer renderer;

    public AbstractFaderPoint(WaxEditorItem item, FaderMove move) {
        this.item = item;
        this.move = move;
    }

    public final FaderMove getFaderMove() {
        return this.move;
    }

    public WaxEditorItem getWaxEditorItem() {
        return this.item;
    }

    public double getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(double startOffset) {
        this.startOffset = startOffset;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }

    public double getTimeLength() {
        return this.timeLength;
    }

    public void setTimeLength(double timeLength) {
        this.timeLength = timeLength;
    }

    public double getPointTime() {
        return this.pointTime;
    }

    public void setPointTime(double pointTime) {
        this.pointTime = pointTime;
    }

    public double getPointValue() {
        return this.pointValue;
    }

    public void setPointValue(double pointValue) {
        this.pointValue = pointValue;
    }

    public FaderPointRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(FaderPointRenderer renderer) {
        this.renderer = renderer;
    }

    public double getPointSize() {
        return this.pointSize;
    }

    public void setPointSize(double pointSize) {
        this.pointSize = pointSize;
    }

    public int hashCode() {
        long h = Double.doubleToLongBits(this.startOffset);
        h += Double.doubleToLongBits(this.startTime);
        h += Double.doubleToLongBits(this.timeLength);
        if (this.move != null) {
            h += (long)this.move.hashCode();
        }
        if (this.item != null) {
            h += (long)this.item.hashCode();
        }
        return (int)h;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractFaderPoint p = (AbstractFaderPoint)obj;
        if (this.startOffset != p.startOffset) {
            return false;
        }
        if (this.startTime != p.startTime) {
            return false;
        }
        if (this.timeLength != p.timeLength) {
            return false;
        }
        if (this.move != p.move) {
            return false;
        }
        return this.item == p.item;
    }
}

