/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.Interpolator;
import java.util.Arrays;

public final class CubicSplineInterpolator
implements Interpolator {
    private double[] x;
    private double[] y;
    private double[] d;
    private double[] u;
    private int size;
    private double human;

    public CubicSplineInterpolator() {
        this(1.0);
    }

    public CubicSplineInterpolator(double human) {
        this.setHuman(human);
    }

    public void update(double[] x, double[] y, int n) {
        this.x = x;
        this.y = y;
        this.size = n;
        if (this.d == null || n > this.d.length) {
            this.d = new double[n];
        }
        if (this.u == null || n > this.u.length) {
            this.u = new double[n];
        }
        if (n < 3) {
            Arrays.fill(this.d, 0, n, 0.0);
        } else {
            int k;
            double p = 0.0;
            double qn = 0.0;
            double s = 0.0;
            double un = 0.0;
            this.u[0] = 0.0;
            this.d[0] = 0.0;
            for (int i = 1; i <= n - 2; ++i) {
                s = (x[i] - x[i - 1]) / (x[i + 1] - x[i - 1]);
                p = s * this.d[i - 1] + 2.0;
                this.d[i] = (s - 1.0) / p;
                this.u[i] = (y[i + 1] - y[i]) / (x[i + 1] - x[i]) - (y[i] - y[i - 1]) / (x[i] - x[i - 1]);
                this.u[i] = (6.0 * this.u[i] / (x[i + 1] - x[i - 1]) - s * this.u[i - 1]) / p;
            }
            un = 0.0;
            qn = 0.0;
            this.d[n - 1] = (un - qn * this.u[n - 2]) / (qn * this.d[n - 2] + 1.0);
            for (k = n - 2; k >= 0; --k) {
                this.d[k] = this.d[k] * this.d[k + 1] + this.u[k];
            }
            if (this.human != 1.0) {
                k = 0;
                while (k < n) {
                    int n2 = k++;
                    this.d[n2] = this.d[n2] * this.human;
                }
            }
        }
    }

    public void interpolate(double mp, double mu, double[] dst, int off, int len) {
        double p;
        int lo = 0;
        int hi = this.size - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            p = this.x[i];
            if (mp < p) {
                hi = i - 1;
                continue;
            }
            if (mp > p) {
                lo = i + 1;
                continue;
            }
            lo = i;
            break;
        }
        if (this.x[lo] > mp) {
            if (--lo < 0) {
                lo = 0;
                hi = 0;
            } else {
                hi = lo + 1;
            }
        } else {
            hi = lo + 1;
        }
        int end = off + len;
        if (hi < this.size) {
            double h = this.x[hi] - this.x[lo];
            while (off < end) {
                double a = (this.x[hi] - mp) / h;
                double b = (mp - this.x[lo]) / h;
                dst[off++] = this.y[lo] * a + this.y[hi] * b + (this.d[lo] * (a * a * a - a) + this.d[hi] * (b * b * b - b)) * (h * h) / 6.0;
                if (!(this.x[hi] <= (mp += mu))) continue;
                if (++hi >= this.size) break;
                while (hi < this.size && this.x[hi] <= mp) {
                    ++hi;
                }
                if (hi >= this.size) break;
                lo = hi - 1;
                h = this.x[hi] - this.x[lo];
            }
        }
        if (off < end) {
            double d = p = this.size < 1 ? 0.0 : this.y[this.size - 1];
            while (off < end) {
                dst[off++] = p;
            }
        }
    }

    public double getHuman() {
        return this.human;
    }

    public void setHuman(double human) {
        this.human = human;
    }
}

