/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.FaderClick;
import com.waxmonster.editor.FaderMove;

public class DefaultFaderClick
implements FaderClick {
    private double timeLength;
    private double attackDuration;
    private double releaseDuration;
    private float peakValue = 0.0f;
    private float targetValue = 1.0f;

    public DefaultFaderClick() {
    }

    public DefaultFaderClick(double timeLength, double attackDuration, double releaseDuration, float peakValue, float targetValue) {
        this.timeLength = timeLength;
        this.attackDuration = attackDuration;
        this.releaseDuration = releaseDuration;
        this.peakValue = peakValue;
        this.targetValue = targetValue;
    }

    public FaderMove createCopy() {
        return new DefaultFaderClick(this.timeLength, this.attackDuration, this.releaseDuration, this.peakValue, this.targetValue);
    }

    public FaderMove createCopy(double timeScale) {
        return new DefaultFaderClick(this.timeLength * timeScale, this.attackDuration * timeScale, this.releaseDuration * timeScale, this.peakValue, this.targetValue);
    }

    public double getTimeLength() {
        return this.timeLength;
    }

    public void setTimeLength(double length) {
        this.timeLength = length;
    }

    public double getAttackDuration() {
        return this.attackDuration;
    }

    public void setAttackDuration(double attackDuration) {
        this.attackDuration = attackDuration;
    }

    public double getReleaseDuration() {
        return this.releaseDuration;
    }

    public void setReleaseDuration(double releaseDuration) {
        this.releaseDuration = releaseDuration;
    }

    public float getPeakValue() {
        return this.peakValue;
    }

    public void setPeakValue(float peakValue) {
        this.peakValue = peakValue;
    }

    public float getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(float value) {
        this.targetValue = value;
    }

    public void interpolate(float sv, double mp, double mu, double[] dst, int off, int len) {
        double x;
        int z;
        int n;
        double u;
        double v;
        int end = off + len;
        if (mp < this.attackDuration) {
            v = (double)this.peakValue + (double)(sv - this.peakValue) * (this.attackDuration - mp) / this.attackDuration;
            u = (double)(sv - this.peakValue) * mu / this.attackDuration;
            n = Math.min(end - off, 1 + (int)((this.attackDuration - mp) / mu));
            z = off + n;
            while (off < z) {
                dst[off++] = v;
                v -= u;
            }
            mp += (double)n * mu;
        }
        if (mp < (x = this.timeLength - this.releaseDuration)) {
            n = Math.min(end - off, 1 + (int)((x - mp) / mu));
            z = off + n;
            while (off < z) {
                dst[off++] = this.peakValue;
            }
            mp += (double)n * mu;
        }
        if (mp < this.timeLength) {
            v = (double)this.peakValue + (double)(this.targetValue - this.peakValue) * (mp + this.releaseDuration - this.timeLength) / this.releaseDuration;
            u = (double)(this.targetValue - this.peakValue) * mu / this.releaseDuration;
            n = Math.min(end - off, 1 + (int)((this.timeLength - mp) / mu));
            z = off + n;
            while (off < z) {
                dst[off++] = v;
                v += u;
            }
        }
        while (off < end) {
            dst[off++] = this.targetValue;
        }
    }

    public void interpolate(float sv, double mp, double mu, float[] dst, int off, int len) {
        double x;
        int z;
        int n;
        double u;
        double v;
        int end = off + len;
        if (mp < this.attackDuration) {
            v = (double)this.peakValue + (double)(sv - this.peakValue) * (this.attackDuration - mp) / this.attackDuration;
            u = (double)(sv - this.peakValue) * mu / this.attackDuration;
            n = Math.min(end - off, 1 + (int)((this.attackDuration - mp) / mu));
            z = off + n;
            while (off < z) {
                dst[off++] = (float)v;
                v -= u;
            }
            mp += (double)n * mu;
        }
        if (mp < (x = this.timeLength - this.releaseDuration)) {
            n = Math.min(end - off, 1 + (int)((x - mp) / mu));
            z = off + n;
            while (off < z) {
                dst[off++] = this.peakValue;
            }
            mp += (double)n * mu;
        }
        if (mp < this.timeLength) {
            v = (double)this.peakValue + (double)(this.targetValue - this.peakValue) * (mp + this.releaseDuration - this.timeLength) / this.releaseDuration;
            u = (double)(this.targetValue - this.peakValue) * mu / this.releaseDuration;
            n = Math.min(end - off, 1 + (int)((this.timeLength - mp) / mu));
            z = off + n;
            while (off < z) {
                dst[off++] = (float)v;
                v += u;
            }
        }
        while (off < end) {
            dst[off++] = this.targetValue;
        }
    }
}

