/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.FaderMove;

public class DefaultFaderMove
implements FaderMove {
    private double timeLength;
    private float targetValue;

    public DefaultFaderMove() {
    }

    public DefaultFaderMove(double timeLength, float targetValue) {
        this.targetValue = targetValue;
        this.timeLength = timeLength;
    }

    public FaderMove createCopy() {
        return new DefaultFaderMove(this.timeLength, this.targetValue);
    }

    public FaderMove createCopy(double timeScale) {
        return new DefaultFaderMove(this.timeLength * timeScale, this.targetValue);
    }

    public double getTimeLength() {
        return this.timeLength;
    }

    public void setTimeLength(double length) {
        this.timeLength = length;
    }

    public float getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(float value) {
        this.targetValue = value;
    }

    public void interpolate(float sv, double mp, double mu, double[] dst, int off, int len) {
        double x = (double)(this.targetValue - sv) / this.timeLength;
        double v = (double)sv + mp * x;
        double u = x * mu;
        int end = off + len;
        while (off < end) {
            dst[off++] = v;
            v += u;
        }
    }

    public void interpolate(float sv, double mp, double mu, float[] dst, int off, int len) {
        double x = (double)(this.targetValue - sv) / this.timeLength;
        double v = (double)sv + mp * x;
        double u = x * mu;
        int end = off + len;
        while (off < end) {
            dst[off++] = (float)v;
            v += u;
        }
    }
}

