/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.InterpolatorProvider;
import com.waxmonster.editor.InterpolatorRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DefaultInterpolatorRegistry
implements InterpolatorRegistry {
    private Map providers = new HashMap();
    private InterpolatorProvider defaultProvider;

    public void registerInterpolatorProvider(InterpolatorProvider provider) {
        if (provider == null) {
            return;
        }
        String name = provider.getName();
        this.providers.put(name, provider);
        if (this.defaultProvider == null) {
            this.setDefaultInterpolatorProvider(provider);
        }
    }

    public void unregisterInterpolatorProvider(InterpolatorProvider provider) {
        Iterator i = this.providers.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry me = i.next();
            if (me.getValue() != provider) continue;
            i.remove();
        }
    }

    public InterpolatorProvider[] getInterpolatorProviders() {
        Collection coll = this.providers.values();
        return coll.toArray(new InterpolatorProvider[coll.size()]);
    }

    public InterpolatorProvider getInterpolatorProvider(String name) {
        return (InterpolatorProvider)this.providers.get(name);
    }

    public InterpolatorProvider getDefaultInterpolatorProvider() {
        return this.defaultProvider;
    }

    public void setDefaultInterpolatorProvider(InterpolatorProvider defaultProvider) {
        this.defaultProvider = defaultProvider;
    }
}

