/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.spacekiller.util.Sys;
import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.ScratchEditorModel;

public class DefaultScratchEditorModel
implements ScratchEditorModel {
    public static final int DEFAULT_INIT_CAPACITY = 64;
    protected static final double MIN_TIME_OFFSET = 1.0E-6;
    protected int tn;
    protected double[] tx;
    protected double[] tv;
    protected int fn;
    protected double[] fx;
    protected FaderMove[] fv;

    public DefaultScratchEditorModel() {
        this(64, 64);
    }

    public DefaultScratchEditorModel(int initTimecodeCapacity, int initFaderCapacity) {
        if (initTimecodeCapacity < 1) {
            initTimecodeCapacity = 1;
        }
        if (initFaderCapacity < 1) {
            initFaderCapacity = 1;
        }
        this.tx = new double[initTimecodeCapacity];
        this.tv = new double[initTimecodeCapacity];
        this.tn = 0;
        this.fx = new double[initFaderCapacity];
        this.fv = new FaderMove[initFaderCapacity];
        this.fn = 0;
    }

    protected DefaultScratchEditorModel(double[] x, int xo, double[] y, int yo, int size) {
        this.tx = new double[size];
        Sys.doubleCopy((double[])x, (int)xo, (double[])this.tx, (int)0, (int)size);
        this.tv = new double[size];
        Sys.doubleCopy((double[])y, (int)yo, (double[])this.tv, (int)0, (int)size);
        this.tn = size;
        this.fx = new double[64];
        this.fv = new FaderMove[64];
        this.fn = 0;
    }

    public int getTimecodePointCount() {
        return this.tn;
    }

    public double getTimecodePointOffsetAt(int i) {
        return this.tx[i];
    }

    public double getTimecodePointValueAt(int i) {
        return this.tv[i];
    }

    public void getTimecodePointOffsets(int index, double[] dst, int off, int len) {
        Sys.doubleCopy((double[])this.tx, (int)index, (double[])dst, (int)off, (int)len);
    }

    public void getTimecodePointValues(int index, double[] dst, int off, int len) {
        Sys.doubleCopy((double[])this.tv, (int)index, (double[])dst, (int)off, (int)len);
    }

    public void moveTimecodePoints(int index, int end, double ro, double rv) {
        int i = index;
        while (i < end) {
            int n = i;
            this.tx[n] = this.tx[n] + ro;
            int n2 = i++;
            this.tv[n2] = this.tv[n2] + rv;
        }
    }

    public int getTimecodePointIndexFor(double o) {
        int lo = 0;
        int hi = this.tn - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            double p = this.tx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            return i;
        }
        return lo;
    }

    public boolean containsTimecodePoint(double o) {
        int lo = 0;
        int hi = this.tn - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            double p = this.tx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public double getTimecodePoint(double o) {
        int lo = 0;
        int hi = this.tn - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            double p = this.tx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            return this.tv[i];
        }
        return Double.NaN;
    }

    public int putTimecodePoint(double o, double v) {
        int i;
        if (o <= 0.0) {
            throw new IllegalArgumentException("Invalid time offset: " + o);
        }
        int lo = 0;
        int hi = this.tn - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            double p = this.tx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            this.tv[i] = v;
            return i;
        }
        i = this.tn - lo;
        if (++this.tn > this.tx.length) {
            double[] newX = new double[this.tx.length * 2];
            Sys.doubleCopy((double[])this.tx, (int)0, (double[])newX, (int)0, (int)lo);
            Sys.doubleCopy((double[])this.tx, (int)lo, (double[])newX, (int)(lo + 1), (int)i);
            double[] newY = new double[newX.length];
            Sys.doubleCopy((double[])this.tv, (int)0, (double[])newY, (int)0, (int)lo);
            Sys.doubleCopy((double[])this.tv, (int)lo, (double[])newY, (int)(lo + 1), (int)i);
            this.tx = newX;
            this.tv = newY;
        } else if (i > 0) {
            Sys.doubleCopy((double[])this.tx, (int)lo, (double[])this.tx, (int)(lo + 1), (int)i);
            Sys.doubleCopy((double[])this.tv, (int)lo, (double[])this.tv, (int)(lo + 1), (int)i);
        }
        this.tx[lo] = o;
        this.tv[lo] = v;
        return lo;
    }

    public double removeTimecodePoint(double o) {
        int lo = 0;
        int hi = this.tn - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            double p = this.tx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            return this.removeTimecodePointAt(i);
        }
        return Double.NaN;
    }

    public double removeTimecodePointAt(int i) {
        if (i < 0 || i >= this.tn) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        double v = this.tv[i];
        if (i < --this.tn) {
            Sys.doubleCopy((double[])this.tx, (int)(i + 1), (double[])this.tx, (int)i, (int)(this.tn - i));
            Sys.doubleCopy((double[])this.tv, (int)(i + 1), (double[])this.tv, (int)i, (int)(this.tn - i));
        }
        return v;
    }

    public void removeAllTimecodePoints() {
        this.tn = 0;
    }

    public double getTimeLength() {
        if (this.tn > 0) {
            return this.tx[this.tn - 1];
        }
        return 0.0;
    }

    public double getMinTimecodeValue() {
        double min = 0.0;
        for (int i = 0; i < this.tn; ++i) {
            if (!(this.tv[i] < min)) continue;
            min = this.tv[i];
        }
        return min;
    }

    public double getMaxTimecodeValue() {
        double max = 0.0;
        for (int i = 0; i < this.tn; ++i) {
            if (!(this.tv[i] > max)) continue;
            max = this.tv[i];
        }
        return max;
    }

    public void checkConsistency() throws IllegalStateException {
        double po = Double.MIN_VALUE;
        int ps = this.tn;
        for (int k = 0; k < ps; ++k) {
            double o = this.tx[k];
            if (o <= po) {
                throw new IllegalStateException("Invalid offset: index=" + k + ", o=" + o + " <= " + po);
            }
            po = o;
        }
    }

    public int getFaderMoveCount() {
        return this.fn;
    }

    public double getFaderMoveOffsetAt(int i) {
        return this.fx[i];
    }

    public FaderMove getFaderMoveAt(int i) {
        return this.fv[i];
    }

    public boolean containsFaderMove(double o) {
        int lo = 0;
        int hi = this.fn - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            double p = this.fx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public FaderMove getFaderMove(double o) {
        int lo = 0;
        int hi = this.fn - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            double p = this.fx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            return this.fv[i];
        }
        return null;
    }

    public int getFaderMoveIndexFor(double o) {
        int lo = 0;
        int hi = this.fn - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            double p = this.fx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            return i;
        }
        return lo;
    }

    public int putFaderMove(double o, FaderMove v) {
        int i;
        if (o <= 0.0) {
            throw new IllegalArgumentException("Invalid time offset: " + o);
        }
        int lo = 0;
        int hi = this.fn - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            double p = this.fx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            this.fv[i] = v;
            return i;
        }
        i = this.fn - lo;
        if (++this.fn > this.fx.length) {
            double[] newX = new double[this.fx.length * 2];
            Sys.doubleCopy((double[])this.fx, (int)0, (double[])newX, (int)0, (int)lo);
            newX[lo] = o;
            Sys.doubleCopy((double[])this.fx, (int)lo, (double[])newX, (int)(lo + 1), (int)i);
            this.fx = newX;
            FaderMove[] newY = new FaderMove[newX.length];
            System.arraycopy(this.fv, 0, newY, 0, lo);
            newY[lo] = v;
            System.arraycopy(this.fv, lo, newY, lo + 1, i);
            this.fv = newY;
        } else {
            Sys.doubleCopy((double[])this.fx, (int)lo, (double[])this.fx, (int)(lo + 1), (int)i);
            System.arraycopy(this.fv, lo, this.fv, lo + 1, i);
            this.fx[lo] = o;
            this.fv[lo] = v;
        }
        return lo;
    }

    public FaderMove removeFaderMove(double o) {
        int lo = 0;
        int hi = this.fn - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            double p = this.fx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            return this.removeFaderMoveAt(i);
        }
        return null;
    }

    public FaderMove removeFaderMoveAt(int i) {
        if (i < 0 || i >= this.fn) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        FaderMove v = this.fv[i];
        if (i < --this.fn) {
            Sys.doubleCopy((double[])this.fx, (int)(i + 1), (double[])this.fx, (int)i, (int)(this.fn - i));
            System.arraycopy(this.fv, i + 1, this.fv, i, this.fn - i);
        }
        this.fv[this.fn] = null;
        return v;
    }

    public void moveFaderMoves(int index, int end, double ro) {
        int i = index;
        while (i < end) {
            int n = i++;
            this.fx[n] = this.fx[n] + ro;
        }
    }

    public ScratchEditorModel createCopy() {
        return this.createCopy(1.0, 1.0);
    }

    public ScratchEditorModel createCopy(double timeScale, double needleScale) {
        int initTimecodeCapacity = this.tx.length;
        int initFaderCapacity = this.fx.length;
        DefaultScratchEditorModel copy = new DefaultScratchEditorModel(initTimecodeCapacity, initFaderCapacity);
        int tn = this.tn;
        for (int i = 0; i < tn; ++i) {
            double time = this.tx[i] * timeScale;
            if (time <= 0.0) {
                time = 1.0E-6;
            }
            copy.tx[i] = time;
            copy.tv[i] = this.tv[i] * needleScale;
        }
        copy.tn = tn;
        int fn = this.fn;
        for (int i = 0; i < fn; ++i) {
            double time = this.fx[i] * timeScale;
            if (time <= 0.0) {
                time = 1.0E-6;
            }
            copy.fx[i] = time;
            copy.fv[i] = this.fv[i].createCopy(timeScale);
        }
        copy.fn = fn;
        return copy;
    }
}

