/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.spacekiller.util.Data;
import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.WaxEditorFile;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.editor.impl.DefaultFaderClick;
import com.waxmonster.editor.impl.DefaultFaderMove;
import com.waxmonster.editor.impl.DefaultScratchEditorModel;
import com.waxmonster.editor.impl.DefaultWaxEditorItem;
import com.waxmonster.editor.impl.DefaultWaxEditorModel;
import com.waxmonster.editor.impl.ScaledScratchEditorModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamCorruptedException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultWaxEditorFile
implements WaxEditorFile {
    public static final String WAXEDITOR_FILE_EXTENSION = ".wlx";
    private static final byte[] HEADER_MAGIC = "WlWx".getBytes();
    private static final byte[] HEADER_MAGIC_OLD = "WAXM".getBytes();
    private static final int HEADER_LENGTH = 12;
    private static final int TAG_WAX_EDITOR_MODEL = 174;
    private static final int TAG_SCRATCH_EDITOR_MODEL = 206;
    private static final int TAG_SCALED_EDITOR_MODEL = 222;
    private static final int TAG_FOOTER = 239;
    private static final int FM_UNKNOWN_V1 = 0;
    private static final int FM_MOVE_V1 = 241;
    private static final int FM_CLICK_V1 = 193;
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final int VERSION_3 = 3;
    private static final int VERSION_4 = 4;
    private static final int VERSION = 4;
    private static final Logger logger = Logger.getLogger(DefaultWaxEditorFile.class.getName());
    private final File file;

    public DefaultWaxEditorFile(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WaxEditorModel[] readWaxEditorFile() throws IOException {
        FileInputStream fis = new FileInputStream(this.file);
        try {
            BufferedInputStream bis = new BufferedInputStream(fis);
            DataInputStream dis = new DataInputStream(bis);
            WaxEditorModel[] waxEditorModelArray = this.readWaxEditorModels(dis);
            return waxEditorModelArray;
        }
        finally {
            fis.close();
        }
    }

    protected WaxEditorModel[] readWaxEditorModels(DataInput in) throws IOException {
        byte[] magic = new byte[HEADER_MAGIC.length];
        in.readFully(magic);
        if (!Arrays.equals(magic, HEADER_MAGIC) && !Arrays.equals(magic, HEADER_MAGIC_OLD)) {
            throw new StreamCorruptedException("Invalid wax file: " + this.file);
        }
        int ver = in.readInt();
        if (ver > 4) {
            throw new StreamCorruptedException("Unsupported wax file version: " + ver + " > " + 4);
        }
        if (ver < 1) {
            throw new StreamCorruptedException("Unsupported wax file version: " + ver + " < " + 1);
        }
        int dataOfs = in.readInt();
        if (dataOfs != 12) {
            throw new StreamCorruptedException("Invalid wax data offset: " + dataOfs);
        }
        LinkedList<WaxEditorModel> waxEditorModels = new LinkedList<WaxEditorModel>();
        HashMap<Integer, ScratchEditorModel> scratchEditorModelIdMap = new HashMap<Integer, ScratchEditorModel>();
        HashMap<Integer, DefaultWaxEditorItem> waxEditorItemIdMapV1 = new HashMap<Integer, DefaultWaxEditorItem>();
        block6: while (true) {
            int tag = in.readUnsignedByte();
            int len = in.readInt();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("load: tag=" + tag + ", len=" + len);
            }
            switch (tag) {
                case 206: {
                    String inter;
                    int id = in.readInt();
                    if (ver < 2) {
                        ScratchEditorModel sem;
                        int origId = in.readInt();
                        double startTime = in.readDouble();
                        double startValue = in.readDouble();
                        boolean autoConnect = in.readBoolean();
                        inter = in.readUTF();
                        if (inter.length() < 1) {
                            inter = null;
                        }
                        if (origId == 0) {
                            sem = this.createScratchEditorModel();
                            this.readScratchEditorModel(in, sem);
                        } else {
                            WaxEditorItem orig = (WaxEditorItem)waxEditorItemIdMapV1.get(Data.toInteger((int)origId));
                            if (orig == null) {
                                throw new StreamCorruptedException("Original ScratchEditorModel not found: clone=" + id + ", orig=" + origId);
                            }
                            sem = orig.getModel();
                        }
                        DefaultWaxEditorItem item = new DefaultWaxEditorItem(sem);
                        item.setStartTime(startTime);
                        item.setStartValue(startValue);
                        item.setAutoConnect(autoConnect);
                        item.setInterpolation(inter);
                        waxEditorItemIdMapV1.put(Data.toInteger((int)id), item);
                        continue block6;
                    }
                    ScratchEditorModel sem = this.createScratchEditorModel();
                    this.readScratchEditorModel(in, sem);
                    scratchEditorModelIdMap.put(Data.toInteger((int)id), sem);
                    continue block6;
                }
                case 222: {
                    if (ver < 4) {
                        throw new StreamCorruptedException("Invalid element tag: " + tag);
                    }
                    int id = in.readInt();
                    int modelId = in.readInt();
                    double timeScale = in.readDouble();
                    double needleScale = in.readDouble();
                    ScratchEditorModel sem = (ScratchEditorModel)scratchEditorModelIdMap.get(Data.toInteger((int)modelId));
                    if (sem == null) {
                        throw new StreamCorruptedException("ScratchEditorModel not found: modelId=" + modelId);
                    }
                    ScaledScratchEditorModel scaled = new ScaledScratchEditorModel(sem, timeScale, needleScale);
                    scratchEditorModelIdMap.put(Data.toInteger((int)id), scaled);
                    continue block6;
                }
                case 174: {
                    int i;
                    double startTime = in.readDouble();
                    float frameRate = in.readFloat();
                    boolean editable = in.readBoolean();
                    String name = in.readUTF();
                    String title = in.readUTF();
                    String descr = in.readUTF();
                    String inter = in.readUTF();
                    if (inter.length() < 1) {
                        inter = null;
                    }
                    WaxEditorModel wem = this.createWaxEditorModel(startTime, name, title, descr, inter, editable);
                    if (ver < 2) {
                        int num = in.readInt();
                        for (i = 0; i < num; ++i) {
                            int id = in.readInt();
                            WaxEditorItem item = (WaxEditorItem)waxEditorItemIdMapV1.get(Data.toInteger((int)id));
                            if (item == null) {
                                throw new StreamCorruptedException("WaxEditorItem not found for id: " + id);
                            }
                            wem.addItem(item);
                        }
                        wem.setDirty(false);
                        waxEditorModels.add(wem);
                        continue block6;
                    }
                    if (ver >= 3) {
                        double bpm = in.readDouble();
                        wem.setDefaultBPM(bpm);
                    }
                    int num = in.readInt();
                    for (i = 0; i < num; ++i) {
                        ScratchEditorModel sem;
                        int semId = in.readInt();
                        startTime = in.readDouble();
                        double startValue = in.readDouble();
                        editable = in.readBoolean();
                        boolean autoConnect = in.readBoolean();
                        inter = in.readUTF();
                        if (inter.length() < 1) {
                            inter = null;
                        }
                        if ((sem = (ScratchEditorModel)scratchEditorModelIdMap.get(Data.toInteger((int)semId))) == null) {
                            throw new StreamCorruptedException("ScratchEditorModel not found: id=" + semId);
                        }
                        DefaultWaxEditorItem item = new DefaultWaxEditorItem(sem);
                        item.setStartTime(startTime);
                        item.setStartValue(startValue);
                        item.setEditable(editable);
                        item.setAutoConnect(autoConnect);
                        item.setInterpolation(inter);
                        wem.addItem((WaxEditorItem)item);
                    }
                    wem.setDirty(false);
                    waxEditorModels.add(wem);
                    continue block6;
                }
                case 239: {
                    break block6;
                }
                default: {
                    throw new StreamCorruptedException("Invalid element tag: " + tag);
                }
            }
            break;
        }
        WaxEditorModel[] wems = waxEditorModels.toArray(new WaxEditorModel[waxEditorModels.size()]);
        return wems;
    }

    protected void readScratchEditorModel(DataInput in, ScratchEditorModel sem) throws IOException {
        double o;
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            o = in.readDouble();
            double v = in.readDouble();
            sem.putTimecodePoint(o, v);
        }
        size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object fm;
            o = in.readDouble();
            int type = in.readByte() & 0xFF;
            switch (type) {
                case 241: {
                    double timeLen = in.readDouble();
                    float targetValue = in.readFloat();
                    fm = new DefaultFaderMove(timeLen, targetValue);
                    break;
                }
                case 193: {
                    double timeLen = in.readDouble();
                    double attackTime = in.readDouble();
                    double releaseTime = in.readDouble();
                    float peakValue = in.readFloat();
                    float targetValue = in.readFloat();
                    fm = new DefaultFaderClick(timeLen, attackTime, releaseTime, peakValue, targetValue);
                    break;
                }
                case 0: {
                    double timeLen = in.readDouble();
                    float targetValue = in.readFloat();
                    fm = new DefaultFaderMove(timeLen, targetValue);
                    break;
                }
                default: {
                    throw new StreamCorruptedException("Unsupported fader move type: " + type);
                }
            }
            if (fm == null) continue;
            sem.putFaderMove(o, (FaderMove)fm);
        }
    }

    protected ScratchEditorModel createScratchEditorModel() {
        return new DefaultScratchEditorModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeWaxEditorFile(WaxEditorModel[] models) throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                this.writeWaxEditorModels(models, dos);
            }
            finally {
                dos.flush();
            }
        }
        finally {
            fos.close();
        }
    }

    protected void writeWaxEditorModels(WaxEditorModel[] models, DataOutput out) throws IOException {
        WaxEditorModel model;
        int j;
        int numModels = models.length;
        out.write(HEADER_MAGIC);
        int ofs = HEADER_MAGIC.length;
        out.writeInt(4);
        ofs += 4;
        out.writeInt(12);
        if ((ofs += 4) != 12) {
            throw new StreamCorruptedException("Invalid header length: " + ofs + " != " + 12);
        }
        int nextScratchEditorModelId = 1;
        HashMap<ScratchEditorModel, Integer> scratchEditorModelIdMap = new HashMap<ScratchEditorModel, Integer>();
        for (j = 0; j < numModels; ++j) {
            model = models[j];
            int itemCount = model.getItemCount();
            for (int k = 0; k < itemCount; ++k) {
                WaxEditorItem item = model.getItemAt(k);
                ScratchEditorModel sem = item.getModel();
                if (sem == null || scratchEditorModelIdMap.containsKey(sem)) continue;
                if (sem instanceof ScaledScratchEditorModel) {
                    ScaledScratchEditorModel scaled = (ScaledScratchEditorModel)sem;
                    if ((sem = scaled.getModel()) != null) {
                        int id;
                        Integer semId = (Integer)scratchEditorModelIdMap.get(sem);
                        if (semId == null) {
                            id = nextScratchEditorModelId++;
                            semId = Data.toInteger((int)id);
                            scratchEditorModelIdMap.put(sem, semId);
                            this.writeScratchEditorModel(sem, id, out);
                        }
                        id = nextScratchEditorModelId++;
                        scratchEditorModelIdMap.put(scaled, Data.toInteger((int)id));
                        this.writeScaledScratchEditorModel(scaled, id, semId, out);
                        continue;
                    }
                    sem = scaled;
                }
                int id = nextScratchEditorModelId++;
                scratchEditorModelIdMap.put(sem, Data.toInteger((int)id));
                this.writeScratchEditorModel(sem, id, out);
            }
        }
        for (j = 0; j < numModels; ++j) {
            model = models[j];
            this.writeWaxEditorModel(model, scratchEditorModelIdMap, out);
        }
        out.write(239);
        out.writeInt(0);
    }

    protected void writeScratchEditorModel(ScratchEditorModel model, int id, DataOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(id);
        int size = model.getTimecodePointCount();
        dos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            dos.writeDouble(model.getTimecodePointOffsetAt(i));
            dos.writeDouble(model.getTimecodePointValueAt(i));
        }
        size = model.getFaderMoveCount();
        dos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            dos.writeDouble(model.getFaderMoveOffsetAt(i));
            FaderMove fm = model.getFaderMoveAt(i);
            if (fm instanceof DefaultFaderClick) {
                DefaultFaderClick fc = (DefaultFaderClick)fm;
                dos.write(193);
                dos.writeDouble(fc.getTimeLength());
                dos.writeDouble(fc.getAttackDuration());
                dos.writeDouble(fc.getReleaseDuration());
                dos.writeFloat(fc.getPeakValue());
                dos.writeFloat(fc.getTargetValue());
                continue;
            }
            if (fm instanceof DefaultFaderMove) {
                DefaultFaderMove def = (DefaultFaderMove)fm;
                dos.write(241);
                dos.writeDouble(def.getTimeLength());
                dos.writeFloat(def.getTargetValue());
                continue;
            }
            dos.write(0);
            dos.writeDouble(fm.getTimeLength());
            dos.writeFloat(fm.getTargetValue());
            logger.warning("Unsupported fader move: " + fm.getClass());
        }
        dos.flush();
        baos.flush();
        byte[] data = baos.toByteArray();
        out.write(206);
        out.writeInt(data.length);
        out.write(data);
    }

    protected void writeScaledScratchEditorModel(ScaledScratchEditorModel model, int id, int modelId, DataOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeInt(id);
        dos.writeInt(modelId);
        dos.writeDouble(model.getTimeScale());
        dos.writeDouble(model.getNeedleScale());
        dos.flush();
        baos.flush();
        byte[] data = baos.toByteArray();
        out.write(222);
        out.writeInt(data.length);
        out.write(data);
    }

    protected void writeWaxEditorModel(WaxEditorModel model, Map scratchEditorModelIdMap, DataOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeDouble(model.getStartTime());
        dos.writeFloat(0.0f);
        dos.writeBoolean(model.isEditable());
        String name = model.getName();
        if (name == null) {
            name = "";
        }
        dos.writeUTF(name);
        String title = model.getTitle();
        if (title == null) {
            title = "";
        }
        dos.writeUTF(title);
        String descr = model.getDescription();
        if (descr == null) {
            descr = "";
        }
        dos.writeUTF(descr);
        String inter = model.getDefaultInterpolation();
        if (inter == null) {
            inter = "";
        }
        dos.writeUTF(inter);
        double bpm = model.getDefaultBPM();
        dos.writeDouble(bpm);
        int num = model.getItemCount();
        dos.writeInt(num);
        for (int i = 0; i < num; ++i) {
            Integer value;
            WaxEditorItem item = model.getItemAt(i);
            ScratchEditorModel sem = item.getModel();
            int semId = 0;
            if (sem != null && (value = (Integer)scratchEditorModelIdMap.get(sem)) != null) {
                semId = value;
            }
            dos.writeInt(semId);
            dos.writeDouble(item.getStartTime());
            dos.writeDouble(item.getStartValue());
            dos.writeBoolean(item.isEditable());
            dos.writeBoolean(item.isAutoConnect());
            inter = item.getInterpolation();
            if (inter == null) {
                inter = "";
            }
            dos.writeUTF(inter);
        }
        dos.flush();
        baos.flush();
        byte[] data = baos.toByteArray();
        out.write(174);
        out.writeInt(data.length);
        out.write(data);
    }

    protected WaxEditorModel createWaxEditorModel(double startTime, String name, String title, String descr, String defaultInterpolation, boolean editable) {
        DefaultWaxEditorModel wem = new DefaultWaxEditorModel();
        wem.setStartTime(startTime);
        wem.setName(name);
        wem.setTitle(title);
        wem.setDescription(descr);
        wem.setDefaultInterpolation(defaultInterpolation);
        wem.setEditable(editable);
        return wem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWaxEditorFile(File file) throws IOException {
        if (file == null) {
            return false;
        }
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        try {
            raf.seek(0L);
            byte[] magic = new byte[HEADER_MAGIC.length];
            raf.readFully(magic);
            boolean bl = Arrays.equals(magic, HEADER_MAGIC) || Arrays.equals(magic, HEADER_MAGIC_OLD);
            return bl;
        }
        finally {
            raf.close();
        }
    }
}

