/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.spacekiller.util.ListenerList;
import com.waxmonster.editor.FaderClick;
import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.FaderPoint;
import com.waxmonster.editor.FaderPointRenderer;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.WaxEditorLineView;
import com.waxmonster.editor.WaxEditorListener;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.editor.impl.AbstractFaderPoint;
import com.waxmonster.editor.impl.FaderClickFaderPoint;
import com.waxmonster.editor.impl.FaderClickFaderPointRenderer;
import com.waxmonster.editor.impl.FaderMoveFaderPoint;
import com.waxmonster.editor.impl.FaderMoveFaderPointRenderer;
import com.waxmonster.editor.impl.InterpolatedTimecodeModel;
import com.waxmonster.editor.impl.WaxEditorUtil;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.model.LineChunk;
import com.waxmonster.model.TimecodeChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.DefaultTimecodeChunk;
import com.waxmonster.model.impl.old.MergedTimecodeModelOLD;
import com.waxmonster.model.view.AbstractLineView;
import com.waxmonster.model.view.LineView;
import com.waxmonster.model.view.old.DefaultTimecodeLineView;
import com.waxmonster.model.view.old.PolyTimecodeModelRenderer;
import com.waxmonster.model.view.old.TimecodeLineView;
import com.waxmonster.model.view.old.TimecodeModelRenderer;
import com.waxmonster.view.AbstractView;
import com.waxmonster.view.TileView;
import com.waxmonster.view.View;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultWaxEditorLineView
extends AbstractLineView
implements WaxEditorLineView {
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Logger logger = Logger.getLogger(DefaultWaxEditorLineView.class.getName());
    private WaxEditorModel[] models;
    private TimecodeChunk mergedTimecodeChunk;
    private MergedTimecodeModelOLD mergedTimecodeModel;
    private float mergeFrameRate;
    private boolean inverted = false;
    private FaderCurve faderCurve;
    private Color timecodeLineColor = Color.BLUE;
    private Color timecodePointColor = Color.RED;
    private Color selectedTimecodePointColor = Color.GREEN;
    private Color selectedFaderPointColor = Color.GREEN;
    private Paint selectedModelBackground = Color.MAGENTA;
    private boolean hideTimecodePoints;
    private boolean hideFaderPoints;
    private TileView tileView;
    private LineView[] lineViews = new LineView[0];
    private Map selectedTimecodePoints;
    private Set selectedWaxEditorItems;
    private ListenerList<ChangeListener> selectionChangeListeners;
    private List faderPoints;
    private Set selectedFaderPoints;
    private FaderClickFaderPointRenderer faderClickRenderer;
    private FaderMoveFaderPointRenderer faderMoveRenderer;
    private ForegroundView foregroundView = new ForegroundView();
    private WaxEditorHandler waxEditorHandler = new WaxEditorHandler();
    private InterpolatorRegistry interpolatorRegistry;

    public DefaultWaxEditorLineView(float mergeFrameRate, TileView tileView) {
        this.tileView = tileView;
        this.selectionChangeListeners = new ListenerList(ChangeListener.class);
        this.selectedTimecodePoints = new HashMap();
        this.selectedWaxEditorItems = new HashSet();
        this.models = new WaxEditorModel[0];
        this.mergeFrameRate = mergeFrameRate;
        this.mergedTimecodeModel = new MergedTimecodeModelOLD(mergeFrameRate);
        this.faderPoints = new ArrayList();
        this.selectedFaderPoints = new HashSet();
    }

    public int getWaxEditorModelCount() {
        return this.models.length;
    }

    public synchronized WaxEditorModel getWaxEditorModelAt(int index) {
        return this.models[index];
    }

    public synchronized void addWaxEditorModel(WaxEditorModel model) {
        if (model == null) {
            return;
        }
        int n = this.models.length;
        WaxEditorModel[] arr = new WaxEditorModel[n + 1];
        System.arraycopy(this.models, 0, arr, 0, n);
        arr[n] = model;
        this.models = arr;
        model.addWaxEditorListener((WaxEditorListener)this.waxEditorHandler);
        this.refresh();
    }

    public synchronized void addWaxEditorModels(WaxEditorModel[] arr) {
        int n = this.models.length;
        WaxEditorModel[] newModels = new WaxEditorModel[n + arr.length];
        System.arraycopy(this.models, 0, newModels, 0, n);
        System.arraycopy(arr, 0, newModels, n, arr.length);
        this.models = newModels;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].addWaxEditorListener((WaxEditorListener)this.waxEditorHandler);
        }
        this.refresh();
    }

    public synchronized void removeWaxEditorModel(WaxEditorModel model) {
        int n = this.models.length;
        for (int i = 0; i < n; ++i) {
            if (this.models[i] != model) continue;
            WaxEditorModel[] arr = new WaxEditorModel[n - 1];
            System.arraycopy(this.models, 0, arr, 0, i);
            System.arraycopy(this.models, i + 1, arr, i, n - i - 1);
            this.models = arr;
            model.removeWaxEditorListener((WaxEditorListener)this.waxEditorHandler);
            this.refresh();
            return;
        }
    }

    public synchronized void removeAllWaxEditorModels() {
        int n = this.models.length;
        if (n < 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.models[i].removeWaxEditorListener((WaxEditorListener)this.waxEditorHandler);
        }
        this.models = new WaxEditorModel[0];
        this.refresh();
    }

    public synchronized void replaceAllWaxEditorModels(WaxEditorModel[] arr) {
        int n = this.models.length;
        for (int i = 0; i < n; ++i) {
            this.models[i].removeWaxEditorListener((WaxEditorListener)this.waxEditorHandler);
        }
        WaxEditorModel[] newModels = new WaxEditorModel[arr.length];
        System.arraycopy(arr, 0, newModels, 0, arr.length);
        this.models = newModels;
        for (int i = 0; i < arr.length; ++i) {
            arr[i].addWaxEditorListener((WaxEditorListener)this.waxEditorHandler);
        }
        this.refresh();
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public LineChunk getLineChunk() {
        return this.mergedTimecodeChunk;
    }

    public TimecodeModel getMergedTimecodeModel() {
        return this.mergedTimecodeModel;
    }

    public float getMergeFrameRate() {
        return this.mergeFrameRate;
    }

    public TimecodeModel getInterpolatedTimecodeModel(WaxEditorItem tem) {
        int n = this.mergedTimecodeModel.getTimecodeModelCount();
        for (int i = 0; i < n; ++i) {
            InterpolatedTimecodeModel itm;
            TimecodeModel tm = this.mergedTimecodeModel.getTimecodeModelAt(i);
            if (!(tm instanceof InterpolatedTimecodeModel) || (itm = (InterpolatedTimecodeModel)tm).getWaxEditorItemIndex(tem) < 0) continue;
            return itm;
        }
        return null;
    }

    public void setZoomRate(double zoomRate) {
        if (this.zoomRate == zoomRate) {
            return;
        }
        super.setZoomRate(zoomRate);
        int n = this.lineViews.length;
        for (int i = 0; i < n; ++i) {
            this.lineViews[i].setZoomRate(zoomRate);
        }
    }

    public Color getTimecodePointColor() {
        return this.timecodePointColor;
    }

    public void setTimecodePointColor(Color timecodePointColor) {
        this.timecodePointColor = timecodePointColor;
    }

    public Color getSelectedTimecodePointColor() {
        return this.selectedTimecodePointColor;
    }

    public void setSelectedTimecodePointColor(Color selectedTimecodePointColor) {
        this.selectedTimecodePointColor = selectedTimecodePointColor;
    }

    public Paint getSelectedModelBackground() {
        return this.selectedModelBackground;
    }

    public void setSelectedModelBackground(Paint selectedModelBackground) {
        this.selectedModelBackground = selectedModelBackground;
    }

    public void paint(Graphics2D g) {
        this.tileView.paint(g);
    }

    public boolean isHideTimecodePoints() {
        return this.hideTimecodePoints;
    }

    public void setHideTimecodePoints(boolean hideTimecodePoints) {
        this.hideTimecodePoints = hideTimecodePoints;
    }

    public boolean isHideFaderPoints() {
        return this.hideFaderPoints;
    }

    public void setHideFaderPoints(boolean hideFaderPoints) {
        this.hideFaderPoints = hideFaderPoints;
    }

    public WaxEditorItem[] getWaxEditorItemsForSelectedPoints() {
        Set coll = this.selectedTimecodePoints.keySet();
        return coll.toArray(new WaxEditorItem[coll.size()]);
    }

    public int[] getSelectedTimecodePoints(WaxEditorItem item) {
        int[] sel = (int[])this.selectedTimecodePoints.get(item);
        if (sel == null) {
            return EMPTY_INT_ARRAY;
        }
        int n = sel.length;
        int[] rc = new int[n];
        System.arraycopy(sel, 0, rc, 0, n);
        return rc;
    }

    public boolean isTimecodePointSelected(WaxEditorItem item, int index) {
        int[] sel = (int[])this.selectedTimecodePoints.get(item);
        if (sel == null) {
            return false;
        }
        int lo = 0;
        int hi = sel.length - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            int x = sel[i];
            if (index < x) {
                hi = i - 1;
                continue;
            }
            if (index > x) {
                lo = i + 1;
                continue;
            }
            return true;
        }
        return false;
    }

    public void selectTimecodePoint(WaxEditorItem item, int index) {
        int[] sel = (int[])this.selectedTimecodePoints.get(item);
        if (sel == null) {
            sel = new int[]{index};
            this.selectedTimecodePoints.put(item, sel);
            this.fireSelectionStateChanged(new ChangeEvent((Object)this));
            return;
        }
        int lo = 0;
        int hi = sel.length - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            int x = sel[i];
            if (index < x) {
                hi = i - 1;
                continue;
            }
            if (index > x) {
                lo = i + 1;
                continue;
            }
            return;
        }
        int n = sel.length;
        int[] arr = new int[n + 1];
        System.arraycopy(sel, 0, arr, 0, lo);
        System.arraycopy(sel, lo, arr, lo + 1, n - lo);
        arr[lo] = index;
        this.selectedTimecodePoints.put(item, arr);
        this.fireSelectionStateChanged(new ChangeEvent((Object)this));
    }

    public void deselectTimecodePoint(WaxEditorItem item, int index) {
        int[] sel = (int[])this.selectedTimecodePoints.get(item);
        if (sel == null) {
            return;
        }
        int lo = 0;
        int hi = sel.length - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            int x = sel[i];
            if (index < x) {
                hi = i - 1;
                continue;
            }
            if (index > x) {
                lo = i + 1;
                continue;
            }
            int n = sel.length;
            if (n <= 1) {
                this.selectedTimecodePoints.remove(item);
            } else {
                int[] arr = new int[n - 1];
                System.arraycopy(sel, 0, arr, 0, i);
                System.arraycopy(sel, i + 1, arr, i, n - i - 1);
                this.selectedTimecodePoints.put(item, arr);
            }
            this.fireSelectionStateChanged(new ChangeEvent((Object)this));
            return;
        }
    }

    public void deselectAllTimecodePoints() {
        if (this.selectedTimecodePoints.isEmpty()) {
            return;
        }
        this.selectedTimecodePoints.clear();
        this.fireSelectionStateChanged(new ChangeEvent((Object)this));
    }

    public void addSelectionChangeListener(ChangeListener l) {
        if (l == null) {
            return;
        }
        this.selectionChangeListeners.add((Object)l);
    }

    public void removeSelectionChangeListener(ChangeListener l) {
        if (l == null) {
            return;
        }
        this.selectionChangeListeners.remove((Object)l);
    }

    protected void fireSelectionStateChanged(ChangeEvent ev) {
        for (ChangeListener l : (ChangeListener[])this.selectionChangeListeners.array()) {
            l.stateChanged(ev);
        }
    }

    public boolean isWaxEditorItemSelected(WaxEditorItem item) {
        return this.selectedWaxEditorItems.contains(item);
    }

    public int getSelectedWaxEditorItemCount() {
        return this.selectedWaxEditorItems.size();
    }

    public WaxEditorItem[] getSelectedWaxEditorItems() {
        return this.selectedWaxEditorItems.toArray(new WaxEditorItem[this.selectedWaxEditorItems.size()]);
    }

    public void selectWaxEditorItem(WaxEditorItem item) {
        if (item == null) {
            return;
        }
        if (this.selectedWaxEditorItems.add(item)) {
            this.fireSelectionStateChanged(new ChangeEvent((Object)this));
        }
    }

    public void selectAllWaxEditorItems() {
        boolean selectionChanged = false;
        for (WaxEditorModel wem : this.models) {
            int num = wem.getItemCount();
            for (int k = 0; k < num; ++k) {
                WaxEditorItem item = wem.getItemAt(k);
                if (!this.selectedWaxEditorItems.add(item)) continue;
                selectionChanged = true;
            }
        }
        if (selectionChanged) {
            this.fireSelectionStateChanged(new ChangeEvent((Object)this));
        }
    }

    public void deselectWaxEditorItem(WaxEditorItem item) {
        if (this.selectedWaxEditorItems.remove(item)) {
            this.fireSelectionStateChanged(new ChangeEvent((Object)this));
        }
    }

    public void deselectAllWaxEditorItems() {
        if (this.selectedWaxEditorItems.isEmpty()) {
            return;
        }
        this.selectedWaxEditorItems.clear();
        this.fireSelectionStateChanged(new ChangeEvent((Object)this));
    }

    protected TimecodeLineView createTimecodeLineView(Color lineColor) {
        int initCapacity = 512;
        PolyTimecodeModelRenderer renderer = new PolyTimecodeModelRenderer(initCapacity);
        renderer.setColor(lineColor);
        DefaultTimecodeLineView view = new DefaultTimecodeLineView();
        view.setTimecodeRenderer((TimecodeModelRenderer)renderer);
        return view;
    }

    public synchronized void refresh() {
        int count = this.lineViews.length;
        for (int i = 0; i < count; ++i) {
            this.tileView.removeView((View)this.lineViews[i]);
        }
        this.tileView.removeView((View)this.foregroundView);
        LinkedList<TimecodeLineView> lineViewList = new LinkedList<TimecodeLineView>();
        LinkedList<TimecodeLineView> tcLineViewList = new LinkedList<TimecodeLineView>();
        WaxEditorModel[] ems = this.models;
        float frameRate = 1000.0f;
        TimecodeModel[] interTimecodeModels = WaxEditorUtil.createInterpolatedTimecodeModels(frameRate, ems, ems.length, this.interpolatorRegistry);
        count = interTimecodeModels.length;
        for (int i = 0; i < count; ++i) {
            InterpolatedTimecodeModel interModel = interTimecodeModels[i];
            long chunkOfs = 0L;
            long chunkEnd = Long.MAX_VALUE;
            long modelOfs = 0L;
            long modelEnd = Long.MAX_VALUE;
            DefaultTimecodeChunk chunk = new DefaultTimecodeChunk(chunkOfs, chunkEnd, modelOfs, modelEnd, (TimecodeModel)interModel);
            TimecodeLineView view = this.createTimecodeLineView(this.timecodeLineColor);
            view.setLineManager(this.lineManager);
            view.setOrientation(this.orientation);
            view.setInverted(this.inverted);
            view.setBounds(new Rectangle(0, 0, 0x3FFFFFFF, 0x3FFFFFFF));
            view.setZoomRate(this.zoomRate);
            view.setTimecodeChunk((TimecodeChunk)chunk);
            this.tileView.addView((View)view);
            lineViewList.add(view);
            tcLineViewList.add(view);
        }
        this.mergedTimecodeModel.removeAllTimecodeModels();
        this.mergedTimecodeModel.addTimecodeModels(interTimecodeModels);
        double[] dst = new double[1];
        float rate = this.mergeFrameRate;
        this.faderPoints.clear();
        for (WaxEditorModel wem : ems) {
            double emStart = wem.getStartTime();
            int itemCount = wem.getItemCount();
            for (int j = 0; j < itemCount; ++j) {
                WaxEditorItem item = wem.getItemAt(j);
                ScratchEditorModel sem = item.getModel();
                double startTime = emStart + item.getStartTime();
                int size = sem.getFaderMoveCount();
                for (int k = 0; k < size; ++k) {
                    double pointValue;
                    double pointTime;
                    double pointSize;
                    AbstractFaderPoint fp;
                    double o = sem.getFaderMoveOffsetAt(k);
                    FaderMove fm = sem.getFaderMoveAt(k);
                    double tl = fm.getTimeLength();
                    if (fm instanceof FaderClick) {
                        FaderClick fc = (FaderClick)fm;
                        fp = new FaderClickFaderPoint(item, fc);
                        fp.setRenderer(this.faderClickRenderer);
                        pointSize = tl - fc.getAttackDuration() - fc.getReleaseDuration();
                        pointTime = startTime + o + fc.getAttackDuration() + pointSize / 2.0;
                        pointValue = tl / 2.0;
                        if (pointValue > pointSize) {
                            pointSize = pointValue;
                        }
                    } else {
                        fp = new FaderMoveFaderPoint(item, fm);
                        fp.setRenderer(this.faderMoveRenderer);
                        pointSize = tl / 2.0;
                        pointTime = startTime + o + tl;
                    }
                    if (pointTime < 0.0) {
                        pointValue = 0.0;
                    } else {
                        try {
                            this.mergedTimecodeModel.getValues(pointTime * (double)rate / 1000.0, 1.0, dst, 0, 1);
                            pointValue = dst[0];
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                            pointValue = 0.0;
                        }
                    }
                    fp.setStartOffset(o);
                    fp.setStartTime(startTime + o);
                    fp.setTimeLength(tl);
                    fp.setPointTime(pointTime);
                    fp.setPointValue(pointValue);
                    fp.setPointSize(pointSize);
                    this.faderPoints.add(fp);
                }
            }
        }
        this.lineViews = lineViewList.toArray(new LineView[lineViewList.size()]);
        this.tileView.addView((View)this.foregroundView);
        this.tileView.invalidate();
    }

    public FaderClickFaderPointRenderer getFaderClickRenderer() {
        return this.faderClickRenderer;
    }

    public void setFaderClickRenderer(FaderClickFaderPointRenderer faderClickRenderer) {
        this.faderClickRenderer = faderClickRenderer;
    }

    public Color getTimecodeLineColor() {
        return this.timecodeLineColor;
    }

    public void setTimecodeLineColor(Color timecodeLineColor) {
        this.timecodeLineColor = timecodeLineColor;
    }

    public int getFaderPointCount() {
        return this.faderPoints.size();
    }

    public FaderPoint getFaderPointAt(int index) {
        return (FaderPoint)this.faderPoints.get(index);
    }

    public FaderPoint getFaderPoint(double startTime) {
        int n = this.faderPoints.size();
        for (int i = 0; i < n; ++i) {
            FaderPoint fp = (FaderPoint)this.faderPoints.get(i);
            if (fp.getStartTime() != startTime) continue;
            return fp;
        }
        return null;
    }

    public boolean isFaderPointSelected(FaderPoint point) {
        return this.selectedFaderPoints.contains(point);
    }

    public void selectFaderPoint(FaderPoint point) {
        if (point == null) {
            return;
        }
        if (this.selectedFaderPoints.add(point)) {
            this.fireSelectionStateChanged(new ChangeEvent((Object)this));
        }
    }

    public void deselectFaderPoint(FaderPoint point) {
        if (this.selectedFaderPoints.remove(point)) {
            this.fireSelectionStateChanged(new ChangeEvent((Object)this));
        }
    }

    public void deselectAllFaderPoints() {
        if (this.selectedFaderPoints.isEmpty()) {
            return;
        }
        this.selectedFaderPoints.clear();
        this.fireSelectionStateChanged(new ChangeEvent((Object)this));
    }

    public FaderPoint[] getSelectedFaderPoints() {
        return this.selectedFaderPoints.toArray(new FaderPoint[this.selectedFaderPoints.size()]);
    }

    public int getSelectedFaderPointCount() {
        return this.selectedFaderPoints.size();
    }

    public Color getSelectedFaderPointColor() {
        return this.selectedFaderPointColor;
    }

    public void setSelectedFaderPointColor(Color selectedFaderPointColor) {
        this.selectedFaderPointColor = selectedFaderPointColor;
    }

    public InterpolatorRegistry getInterpolatorRegistry() {
        return this.interpolatorRegistry;
    }

    public void setInterpolatorRegistry(InterpolatorRegistry interpolatorRegistry) {
        this.interpolatorRegistry = interpolatorRegistry;
    }

    public FaderMoveFaderPointRenderer getFaderMoveRenderer() {
        return this.faderMoveRenderer;
    }

    public void setFaderMoveRenderer(FaderMoveFaderPointRenderer faderMoveRenderer) {
        this.faderMoveRenderer = faderMoveRenderer;
    }

    public FaderCurve getFaderCurve() {
        return this.faderCurve;
    }

    public void setFaderCurve(FaderCurve faderCurve) {
        this.faderCurve = faderCurve;
    }

    public TileView getTileView() {
        return this.tileView;
    }

    public void setTileView(TileView tileView) {
        this.tileView = tileView;
    }

    protected class ForegroundView
    extends AbstractView {
        protected ForegroundView() {
        }

        public void flush() {
        }

        public void paint(Graphics2D g) {
            int ty;
            int tx;
            double mpu;
            boolean horiz = DefaultWaxEditorLineView.this.orientation == 0 || DefaultWaxEditorLineView.this.orientation == 1;
            boolean inv = DefaultWaxEditorLineView.this.inverted;
            double tpu = mpu = 1000.0 / DefaultWaxEditorLineView.this.zoomRate;
            if (horiz) {
                tx = 0;
                ty = 0xA00000;
            } else {
                tx = 0xA00000;
                ty = 0;
            }
            g.translate(tx, ty);
            if (!DefaultWaxEditorLineView.this.hideFaderPoints) {
                FaderPointRenderer fpr;
                for (FaderPoint fp : DefaultWaxEditorLineView.this.faderPoints) {
                    fpr = fp.getRenderer();
                    if (fpr == null) continue;
                    fpr.paintBackground((Graphics)g, fp, DefaultWaxEditorLineView.this.faderCurve, mpu, tpu, DefaultWaxEditorLineView.this.orientation, inv);
                }
                for (FaderPoint fp : DefaultWaxEditorLineView.this.faderPoints) {
                    fpr = fp.getRenderer();
                    if (fpr == null) continue;
                    fpr.paintPoint((Graphics)g, fp, DefaultWaxEditorLineView.this.faderCurve, mpu, tpu, DefaultWaxEditorLineView.this.orientation, inv);
                }
            }
            if (!DefaultWaxEditorLineView.this.selectedWaxEditorItems.isEmpty()) {
                g.setPaint(DefaultWaxEditorLineView.this.selectedModelBackground);
                int ins = 5;
                for (WaxEditorItem ref : DefaultWaxEditorLineView.this.selectedWaxEditorItems) {
                    ScratchEditorModel sem = ref.getModel();
                    WaxEditorModel wem = ref.getParent();
                    double minVal = sem.getMinTimecodeValue();
                    double maxVal = sem.getMaxTimecodeValue();
                    double timeLen = sem.getTimeLength();
                    double startTime = wem.getStartTime() + ref.getStartTime();
                    double startValue = ref.getStartValue();
                    double oa = startTime / mpu;
                    double oz = (startTime + timeLen) / mpu;
                    double va = (startValue + minVal) / tpu;
                    double vz = (startValue + maxVal) / tpu;
                    if (!inv) {
                        double swap = vz;
                        vz = -va;
                        va = -swap;
                    }
                    if (horiz) {
                        g.fillRect((int)oa - ins, (int)va - ins, (int)(oz - oa) + ins * 2, (int)(vz - va) + ins * 2);
                        continue;
                    }
                    g.fillRect((int)va - ins, (int)oa - ins, (int)(vz - va) + ins * 2, (int)(oz - oa) + ins * 2);
                }
            }
            if (!DefaultWaxEditorLineView.this.hideTimecodePoints) {
                WaxEditorModel[] ems = DefaultWaxEditorLineView.this.models;
                int num = ems.length;
                int pw = 3;
                int ph = 3;
                int hpw = pw / 2;
                int hph = ph / 2;
                int spw = 9;
                int sph = 9;
                int shpw = spw / 2;
                int shph = sph / 2;
                for (int m = 0; m < num; ++m) {
                    WaxEditorModel wem = ems[m];
                    double emStart = wem.getStartTime();
                    int itemCount = wem.getItemCount();
                    for (int k = 0; k < itemCount; ++k) {
                        WaxEditorItem item = wem.getItemAt(k);
                        ScratchEditorModel sem = item.getModel();
                        if (!item.isEditable()) continue;
                        double startTime = emStart + item.getStartTime();
                        double startValue = item.getStartValue();
                        double base = inv ? startValue / tpu : -startValue / tpu;
                        g.setColor(DefaultWaxEditorLineView.this.timecodePointColor);
                        double o = startTime / mpu;
                        double v = base;
                        if (horiz) {
                            g.fillRect((int)Math.round(o) - hpw, (int)Math.round(v) - hph, pw, ph);
                        } else {
                            g.fillRect((int)Math.round(v) - hpw, (int)Math.round(o) - hph, pw, ph);
                        }
                        int size = sem.getTimecodePointCount();
                        for (int i = 0; i < size; ++i) {
                            o = (startTime + sem.getTimecodePointOffsetAt(i)) / mpu;
                            v = sem.getTimecodePointValueAt(i) / tpu;
                            v = inv ? base + v : base - v;
                            if (horiz) {
                                g.fillRect((int)Math.round(o) - hpw, (int)Math.round(v) - hph, pw, ph);
                                continue;
                            }
                            g.fillRect((int)Math.round(v) - hpw, (int)Math.round(o) - hph, pw, ph);
                        }
                        int[] sel = DefaultWaxEditorLineView.this.getSelectedTimecodePoints(item);
                        if (sel.length <= 0) continue;
                        g.setColor(DefaultWaxEditorLineView.this.selectedTimecodePointColor);
                        for (int i = 0; i < sel.length; ++i) {
                            int idx = sel[i];
                            if (idx >= size) continue;
                            if (idx >= 0) {
                                o = (startTime + sem.getTimecodePointOffsetAt(idx)) / mpu;
                                v = sem.getTimecodePointValueAt(idx) / tpu;
                            } else {
                                o = startTime / mpu;
                                v = 0.0;
                            }
                            v = inv ? base + v : base - v;
                            if (horiz) {
                                g.drawRect((int)Math.round(o) - shpw, (int)Math.round(v) - shph, spw, sph);
                                continue;
                            }
                            g.drawRect((int)Math.round(v) - shpw, (int)Math.round(o) - shph, spw, sph);
                        }
                    }
                }
            }
            if (!DefaultWaxEditorLineView.this.hideFaderPoints && !DefaultWaxEditorLineView.this.selectedFaderPoints.isEmpty()) {
                g.setColor(DefaultWaxEditorLineView.this.selectedFaderPointColor);
                for (FaderPoint fp : DefaultWaxEditorLineView.this.selectedFaderPoints) {
                    double pointTime = fp.getPointTime() / mpu;
                    double pointValue = inv ? fp.getPointValue() / tpu : -fp.getPointValue() / tpu;
                    double pointSize = fp.getPointSize() / mpu;
                    double halfPointSize = pointSize / 2.0;
                    if (horiz) {
                        g.drawRect((int)(pointTime - halfPointSize), (int)(pointValue - halfPointSize), (int)pointSize, (int)pointSize);
                        continue;
                    }
                    g.drawRect((int)(pointValue - halfPointSize), (int)(pointTime - halfPointSize), (int)pointSize, (int)pointSize);
                }
            }
            g.translate(-tx, -ty);
        }
    }

    protected class WaxEditorHandler
    implements WaxEditorListener {
        protected WaxEditorHandler() {
        }

        public void itemAdded(WaxEditorItem item) {
            DefaultWaxEditorLineView.this.refresh();
        }

        public void itemRemoved(WaxEditorItem item) {
            DefaultWaxEditorLineView.this.refresh();
        }

        public void itemChanged(WaxEditorItem item) {
            DefaultWaxEditorLineView.this.refresh();
        }
    }
}

