/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.spacekiller.util.ListenerList;
import com.spacekiller.util.Resource;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.WaxEditorListener;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.editor.impl.DefaultWaxEditorItem;
import com.waxmonster.model.LineModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.AbstractLineChunk;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class DefaultWaxEditorModel
extends AbstractLineChunk
implements WaxEditorModel {
    private static final Logger logger = Logger.getLogger(DefaultWaxEditorModel.class.getName());
    protected String name;
    protected Resource resource;
    protected String[] trackIds;
    private long lineOfs;
    private String title;
    private String description;
    private String defaultInterpolation;
    private double defaultBPM;
    private boolean editable = true;
    private Color lineColor;
    private List items;
    private transient boolean dirty;
    private transient ListenerList<WaxEditorListener> listeners = new ListenerList(WaxEditorListener.class);

    public DefaultWaxEditorModel() {
        this(0L, Long.MAX_VALUE, 0L, Long.MAX_VALUE);
    }

    public DefaultWaxEditorModel(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        super(chunkOfs, chunkEnd, modelOfs, modelEnd);
        this.items = new ArrayList();
    }

    public final LineModel getLineModel() {
        return this;
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        throw new UnsupportedOperationException("createLineChunk not supported");
    }

    public final int getChunkCount() {
        return 0;
    }

    public final long getModelOfs() {
        return 0L;
    }

    public final long getModelEnd() {
        return this.getNanoLength();
    }

    public long getLineOfs() {
        return this.lineOfs;
    }

    public void setLineOfs(long lineOfs) {
        this.lineOfs = lineOfs;
    }

    public double getStartTime() {
        return (double)this.lineOfs / 1000000.0;
    }

    public void setStartTime(double startTime) {
        this.lineOfs = (long)(startTime * 1000000.0);
    }

    public void addWaxEditorListener(WaxEditorListener l) {
        if (l == null) {
            return;
        }
        this.listeners.add((Object)l);
    }

    public void removeWaxEditorListener(WaxEditorListener l) {
        if (l == null) {
            return;
        }
        this.listeners.remove((Object)l);
    }

    protected final void fireItemAdded(WaxEditorItem item) {
        for (WaxEditorListener l : (WaxEditorListener[])this.listeners.array()) {
            l.itemAdded(item);
        }
    }

    protected final void fireItemRemoved(WaxEditorItem item) {
        for (WaxEditorListener l : (WaxEditorListener[])this.listeners.array()) {
            l.itemRemoved(item);
        }
    }

    protected final void fireItemChanged(WaxEditorItem item) {
        for (WaxEditorListener l : (WaxEditorListener[])this.listeners.array()) {
            l.itemChanged(item);
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        if (this.editable == editable) {
            return;
        }
        this.editable = editable;
        this.setDirty(true);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        if (this.title == title) {
            return;
        }
        this.title = title;
        this.setDirty(true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (this.description == description) {
            return;
        }
        this.description = description;
        this.setDirty(true);
    }

    public String getDefaultInterpolation() {
        return this.defaultInterpolation;
    }

    public void setDefaultInterpolation(String defaultInterpolation) {
        if (this.defaultInterpolation == defaultInterpolation) {
            return;
        }
        this.defaultInterpolation = defaultInterpolation;
        this.setDirty(true);
    }

    public synchronized int getItemCount() {
        return this.items.size();
    }

    public synchronized WaxEditorItem getItemAt(int index) {
        return (WaxEditorItem)this.items.get(index);
    }

    public synchronized void addItem(WaxEditorItem item) {
        this.insertItemAt(item, this.items.size());
    }

    public synchronized void insertItemAt(WaxEditorItem item, int index) {
        if (item == null) {
            return;
        }
        DefaultWaxEditorItem def = (DefaultWaxEditorItem)item;
        WaxEditorModel parent = def.getParent();
        if (parent != null) {
            throw new IllegalStateException("Item is already in model: " + parent);
        }
        def.setParent(this);
        this.items.add(index, def);
        this.setDirty(true);
        this.fireItemAdded(def);
    }

    public synchronized void removeItem(WaxEditorItem item) {
        if (this.items.remove(item)) {
            this.setDirty(true);
            DefaultWaxEditorItem def = (DefaultWaxEditorItem)item;
            if (def.getParent() == this) {
                def.setParent(null);
            }
            this.fireItemRemoved(def);
        }
    }

    public synchronized void removeItemAt(int index) {
        DefaultWaxEditorItem item = (DefaultWaxEditorItem)this.items.remove(index);
        if (item != null) {
            this.setDirty(true);
            if (item.getParent() == this) {
                item.setParent(null);
            }
            this.fireItemRemoved(item);
        }
    }

    public synchronized void itemChanged(WaxEditorItem item) {
        if (item != null && item.getParent() == this) {
            this.fireItemChanged(item);
        }
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        if (this.lineColor == lineColor) {
            return;
        }
        this.lineColor = lineColor;
        this.setDirty(true);
    }

    public double getDefaultBPM() {
        return this.defaultBPM;
    }

    public void setDefaultBPM(double defaultBPM) {
        if (this.defaultBPM == defaultBPM) {
            return;
        }
        this.defaultBPM = defaultBPM;
        this.setDirty(true);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public void close() {
    }

    public synchronized boolean isModelEmpty() {
        return this.items.isEmpty();
    }

    private synchronized double getTimeLength() {
        int size = this.items.size();
        if (size > 0) {
            WaxEditorItem item = (WaxEditorItem)this.items.get(size - 1);
            double itemTime = item.getStartTime();
            ScratchEditorModel model = item.getModel();
            double timeLen = model.getTimeLength();
            return itemTime + timeLen;
        }
        return 0.0;
    }

    public long getNanoLength() {
        return (long)Math.ceil(this.getTimeLength() * 1000000.0);
    }

    public long getUnitLength() {
        return (long)Math.ceil(this.getTimeLength());
    }

    public float getUnitRate() {
        return 1000.0f;
    }

    public long computeLineEnd() {
        return super.computeLineEnd(this.getUnitLength(), (double)this.getUnitRate());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public String[] getTrackIds() {
        return this.trackIds;
    }

    public void setTrackIds(String[] trackIds) {
        this.trackIds = trackIds;
    }

    public void flush() throws IOException {
        if (!this.isDirty()) {
            return;
        }
        logger.warning("TODO flush: " + (Object)((Object)this));
    }
}

