/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.FaderClick;
import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.FaderPoint;
import com.waxmonster.editor.impl.AbstractFaderPointRenderer;
import com.waxmonster.fader.FaderCurve;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;

public class FaderClickFaderPointRenderer
extends AbstractFaderPointRenderer {
    private Paint offClickBackPaint = Color.WHITE;
    private Color offClickFillColor = Color.RED;
    private Color offClickLineColor = Color.RED;
    private Color onClickFillColor = Color.GREEN;
    private Color onClickLineColor = Color.GREEN;

    public FaderClickFaderPointRenderer() {
        this.setMinPointSize(5);
        this.setMaxPointSize(50);
    }

    public void paintPoint(Graphics g, FaderPoint fp, FaderCurve fc, double mpu, double tpu, int orientation, boolean inverted) {
        float target;
        FaderClick click;
        float peak;
        int py;
        int px;
        int ph;
        int pw;
        double v = inverted ? fp.getPointValue() / tpu : -fp.getPointValue() / tpu;
        double t = fp.getPointTime() / mpu;
        double s = fp.getPointSize() / mpu;
        int ps = (int)Math.round(s);
        if (ps < this.minPointSize) {
            ps = this.minPointSize;
        } else if (ps > this.maxPointSize) {
            ps = this.maxPointSize;
        }
        switch (orientation) {
            case 0: {
                pw = ps;
                ph = ps;
                px = (int)Math.round(t - (double)pw / 2.0);
                py = (int)Math.round(v - (double)ph / 2.0);
                break;
            }
            case 2: {
                pw = ps;
                ph = ps;
                px = (int)Math.round(v - (double)pw / 2.0);
                py = (int)Math.round(t - (double)ph / 2.0);
                break;
            }
            default: {
                return;
            }
        }
        Color fill = this.offClickFillColor;
        Color line = this.offClickLineColor;
        FaderMove move = fp.getFaderMove();
        if (move != null && move instanceof FaderClick && (peak = (click = (FaderClick)move).getPeakValue()) > (target = click.getTargetValue())) {
            fill = this.onClickFillColor;
            line = this.onClickLineColor;
        }
        if (fill != null) {
            g.setColor(fill);
            g.fillOval(px, py, pw, ph);
        }
        if (line != null) {
            g.setColor(line);
            g.drawOval(px, py, pw, ph);
        }
    }

    public void paintBackground(Graphics g, FaderPoint fp, FaderCurve fc, double mpu, double tpu, int orientation, boolean inverted) {
        int mh;
        int mw;
        int my;
        int mx;
        float target;
        FaderClick click;
        float peak;
        FaderMove move = fp.getFaderMove();
        if (move != null && move instanceof FaderClick && (peak = (click = (FaderClick)move).getPeakValue()) > (target = click.getTargetValue())) {
            return;
        }
        Paint paint = this.offClickBackPaint;
        if (paint == null) {
            return;
        }
        Rectangle r = g.getClipBounds();
        if (r == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        double t = fp.getStartTime() / mpu;
        double l = fp.getTimeLength() / mpu;
        switch (orientation) {
            case 0: {
                mx = (int)Math.round(t);
                my = r.y;
                mw = Math.max(1, (int)Math.round(l));
                mh = r.height;
                break;
            }
            case 2: {
                mx = r.x;
                my = (int)Math.round(t);
                mw = r.width;
                mh = Math.max(1, (int)Math.round(l));
                break;
            }
            default: {
                return;
            }
        }
        g2d.setPaint(paint);
        g2d.fillRect(mx, my, mw, mh);
    }

    public Color getOffClickFillColor() {
        return this.offClickFillColor;
    }

    public void setOffClickFillColor(Color offClickFillColor) {
        this.offClickFillColor = offClickFillColor;
    }

    public Color getOffClickLineColor() {
        return this.offClickLineColor;
    }

    public void setOffClickLineColor(Color offClickLineColor) {
        this.offClickLineColor = offClickLineColor;
    }

    public Color getOnClickFillColor() {
        return this.onClickFillColor;
    }

    public void setOnClickFillColor(Color onClickFillColor) {
        this.onClickFillColor = onClickFillColor;
    }

    public Color getOnClickLineColor() {
        return this.onClickLineColor;
    }

    public void setOnClickLineColor(Color onClickLineColor) {
        this.onClickLineColor = onClickLineColor;
    }

    public Paint getOffClickBackPaint() {
        return this.offClickBackPaint;
    }

    public void setOffClickBackPaint(Paint offClickBackPaint) {
        this.offClickBackPaint = offClickBackPaint;
    }
}

