/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.impl.DefaultFaderClick;
import com.waxmonster.editor.impl.PropertiesPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FaderClickPropertiesPanel
extends JPanel
implements PropertiesPanel {
    private static final long serialVersionUID = -7465386634888248694L;
    private String title;
    private DefaultFaderClick faderClick;
    private boolean refreshing = false;
    private float peakValue;
    private float targetValue;
    private double attackDuration;
    private double peakDuration;
    private double releaseDuration;
    private double totalTime;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JTextField jTextFieldTotalDuration = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel31 = null;
    private JLabel jLabel32 = null;
    private JTextField jTextFieldAttackDuration = null;
    private JTextField jTextFieldReleaseDuration = null;
    private JLabel jLabel11 = null;
    private JTextField jTextFieldPeakDuration = null;
    private JLabel jLabel311 = null;
    private JPanel jPanelDuration = null;
    private JLabel lblPeakValue;
    private JLabel lblTargetValue;
    private JLabel lblPrevious;
    private JTextField textFieldInitValue;
    private JTextField textFieldPeakValue;
    private JTextField textFieldTargetValue;

    public FaderClickPropertiesPanel() {
        this.initialize();
        this.initFaderClickPropertiesPanel();
    }

    private void initialize() {
        GridBagConstraints gbc_jPanelDuration = new GridBagConstraints();
        gbc_jPanelDuration.gridx = 0;
        gbc_jPanelDuration.weightx = 1.0;
        gbc_jPanelDuration.fill = 2;
        gbc_jPanelDuration.gridy = 0;
        this.jLabel311 = new JLabel();
        this.jLabel311.setToolTipText("Milliseconds");
        this.jLabel311.setText("ms.");
        this.jLabel11 = new JLabel();
        this.jLabel11.setText("Peak duration:");
        this.jLabel32 = new JLabel();
        this.jLabel32.setToolTipText("Milliseconds");
        this.jLabel32.setText("ms.");
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("Release duration:");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowHeights = new int[]{0};
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowWeights = new double[]{0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(400, 208));
        this.add((Component)this.getJPanelDuration(), gbc_jPanelDuration);
    }

    public DefaultFaderClick getFaderClick() {
        return this.faderClick;
    }

    public void setFaderClick(DefaultFaderClick faderClick) {
        this.faderClick = faderClick;
        this.refresh();
    }

    private JTextField getJTextFieldTotalDuration() {
        if (this.jTextFieldTotalDuration == null) {
            this.jTextFieldTotalDuration = new JTextField();
            this.jTextFieldTotalDuration.setOpaque(false);
            this.jTextFieldTotalDuration.setColumns(6);
        }
        return this.jTextFieldTotalDuration;
    }

    private JTextField getJTextFieldAttackDuration() {
        if (this.jTextFieldAttackDuration == null) {
            this.jTextFieldAttackDuration = new JTextField();
            this.jTextFieldAttackDuration.setOpaque(false);
            this.jTextFieldAttackDuration.setColumns(6);
        }
        return this.jTextFieldAttackDuration;
    }

    private JTextField getJTextFieldReleaseDuration() {
        if (this.jTextFieldReleaseDuration == null) {
            this.jTextFieldReleaseDuration = new JTextField();
            this.jTextFieldReleaseDuration.setOpaque(false);
            this.jTextFieldReleaseDuration.setColumns(6);
        }
        return this.jTextFieldReleaseDuration;
    }

    private JTextField getJTextFieldPeakDuration() {
        if (this.jTextFieldPeakDuration == null) {
            this.jTextFieldPeakDuration = new JTextField();
            this.jTextFieldPeakDuration.setOpaque(false);
            this.jTextFieldPeakDuration.setColumns(6);
        }
        return this.jTextFieldPeakDuration;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        this.peakValue = this.faderClick.getPeakValue();
        this.targetValue = this.faderClick.getTargetValue();
        this.attackDuration = this.faderClick.getAttackDuration();
        this.releaseDuration = this.faderClick.getReleaseDuration();
        this.totalTime = this.faderClick.getTimeLength();
        this.peakDuration = this.totalTime - this.attackDuration - this.releaseDuration;
        try {
            this.refreshing = true;
            this.getTextFieldInitValue().setText("TODO !");
            this.getTextFieldPeakValue().setText(this.valueString(this.peakValue));
            this.getTextFieldTargetValue().setText(this.valueString(this.targetValue));
            this.getJTextFieldAttackDuration().setText(this.timeString(this.attackDuration));
            this.getJTextFieldPeakDuration().setText(this.timeString(this.peakDuration));
            this.getJTextFieldReleaseDuration().setText(this.timeString(this.releaseDuration));
            this.getJTextFieldTotalDuration().setText(this.timeString(this.totalTime));
        }
        finally {
            this.refreshing = false;
        }
    }

    protected String valueString(float value) {
        int x = (int)value;
        if ((float)x == value) {
            return String.valueOf(x);
        }
        return String.valueOf((double)Math.round((double)value * 1000.0) / 1000.0);
    }

    protected String timeString(double millis) {
        long ms = (long)millis;
        if ((double)ms == millis) {
            return String.valueOf(ms);
        }
        return String.valueOf((double)Math.round(millis * 1000.0) / 1000.0);
    }

    protected double timeValue(String s) throws NumberFormatException {
        return Double.parseDouble(s.trim());
    }

    @Override
    public void apply() {
        double attackDuration = this.timeValue(this.getJTextFieldAttackDuration().getText());
        this.faderClick.setAttackDuration(attackDuration);
        double releaseDuration = this.timeValue(this.getJTextFieldReleaseDuration().getText());
        this.faderClick.setReleaseDuration(releaseDuration);
        double totalTime = this.timeValue(this.getJTextFieldTotalDuration().getText());
        this.faderClick.setTimeLength(totalTime);
    }

    private JPanel getJPanelDuration() {
        if (this.jPanelDuration == null) {
            GridBagConstraints gbc_jTextFieldReleaseDuration = new GridBagConstraints();
            gbc_jTextFieldReleaseDuration.fill = 2;
            gbc_jTextFieldReleaseDuration.gridx = 3;
            gbc_jTextFieldReleaseDuration.gridy = 2;
            gbc_jTextFieldReleaseDuration.weightx = 1.0;
            gbc_jTextFieldReleaseDuration.insets = new Insets(4, 4, 5, 5);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.anchor = 17;
            gridBagConstraints1.gridx = 2;
            gridBagConstraints1.gridy = 2;
            gridBagConstraints1.insets = new Insets(4, 8, 5, 5);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.gridx = 4;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.gridx = 4;
            GridBagConstraints gbc_jTextFieldPeakDuration = new GridBagConstraints();
            gbc_jTextFieldPeakDuration.fill = 2;
            gbc_jTextFieldPeakDuration.gridx = 3;
            gbc_jTextFieldPeakDuration.gridy = 1;
            gbc_jTextFieldPeakDuration.weightx = 1.0;
            gbc_jTextFieldPeakDuration.insets = new Insets(4, 4, 5, 5);
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridx = 2;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.insets = new Insets(4, 8, 5, 5);
            this.jPanelDuration = new JPanel();
            this.jPanelDuration.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Fader Click", 4, 2, null, null));
            GridBagLayout gbl_jPanelDuration = new GridBagLayout();
            gbl_jPanelDuration.columnWidths = new int[]{0, 0, 0, 0, 0};
            gbl_jPanelDuration.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
            this.jPanelDuration.setLayout(gbl_jPanelDuration);
            this.jPanelDuration.setOpaque(false);
            GridBagConstraints gbc_lblPrevious = new GridBagConstraints();
            gbc_lblPrevious.anchor = 17;
            gbc_lblPrevious.insets = new Insets(4, 4, 5, 5);
            gbc_lblPrevious.gridx = 0;
            gbc_lblPrevious.gridy = 0;
            this.jPanelDuration.add((Component)this.getLblPrevious(), gbc_lblPrevious);
            GridBagConstraints gbc_textFieldInitValue = new GridBagConstraints();
            gbc_textFieldInitValue.weightx = 1.0;
            gbc_textFieldInitValue.insets = new Insets(4, 4, 5, 5);
            gbc_textFieldInitValue.fill = 2;
            gbc_textFieldInitValue.gridx = 1;
            gbc_textFieldInitValue.gridy = 0;
            this.jPanelDuration.add((Component)this.getTextFieldInitValue(), gbc_textFieldInitValue);
            this.jLabel = new JLabel();
            this.jLabel.setText("Attack duration:");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(4, 8, 5, 5);
            this.jPanelDuration.add((Component)this.jLabel, gridBagConstraints);
            GridBagConstraints gbc_jTextFieldAttackDuration = new GridBagConstraints();
            gbc_jTextFieldAttackDuration.fill = 2;
            gbc_jTextFieldAttackDuration.gridx = 3;
            gbc_jTextFieldAttackDuration.gridy = 0;
            gbc_jTextFieldAttackDuration.weightx = 1.0;
            gbc_jTextFieldAttackDuration.insets = new Insets(4, 4, 5, 5);
            this.jPanelDuration.add((Component)this.getJTextFieldAttackDuration(), gbc_jTextFieldAttackDuration);
            this.jLabel31 = new JLabel();
            this.jLabel31.setToolTipText("Milliseconds");
            this.jLabel31.setText("ms.");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.gridx = 4;
            this.jPanelDuration.add((Component)this.jLabel31, gridBagConstraints5);
            GridBagConstraints gbc_lblPeakValue = new GridBagConstraints();
            gbc_lblPeakValue.anchor = 17;
            gbc_lblPeakValue.insets = new Insets(4, 4, 5, 5);
            gbc_lblPeakValue.gridx = 0;
            gbc_lblPeakValue.gridy = 1;
            this.jPanelDuration.add((Component)this.getLblPeakValue(), gbc_lblPeakValue);
            GridBagConstraints gbc_textFieldPeakValue = new GridBagConstraints();
            gbc_textFieldPeakValue.weightx = 1.0;
            gbc_textFieldPeakValue.insets = new Insets(4, 4, 5, 5);
            gbc_textFieldPeakValue.fill = 2;
            gbc_textFieldPeakValue.gridx = 1;
            gbc_textFieldPeakValue.gridy = 1;
            this.jPanelDuration.add((Component)this.getTextFieldPeakValue(), gbc_textFieldPeakValue);
            this.jPanelDuration.add((Component)this.jLabel11, gridBagConstraints9);
            this.jPanelDuration.add((Component)this.getJTextFieldPeakDuration(), gbc_jTextFieldPeakDuration);
            this.jPanelDuration.add((Component)this.jLabel311, gridBagConstraints11);
            GridBagConstraints gbc_lblTargetValue = new GridBagConstraints();
            gbc_lblTargetValue.anchor = 17;
            gbc_lblTargetValue.insets = new Insets(4, 4, 5, 5);
            gbc_lblTargetValue.gridx = 0;
            gbc_lblTargetValue.gridy = 2;
            this.jPanelDuration.add((Component)this.getLblTargetValue(), gbc_lblTargetValue);
            GridBagConstraints gbc_textFieldTargetValue = new GridBagConstraints();
            gbc_textFieldTargetValue.weightx = 1.0;
            gbc_textFieldTargetValue.insets = new Insets(4, 4, 5, 5);
            gbc_textFieldTargetValue.fill = 2;
            gbc_textFieldTargetValue.gridx = 1;
            gbc_textFieldTargetValue.gridy = 2;
            this.jPanelDuration.add((Component)this.getTextFieldTargetValue(), gbc_textFieldTargetValue);
            this.jPanelDuration.add((Component)this.jLabel32, gridBagConstraints6);
            this.jPanelDuration.add((Component)this.jLabel1, gridBagConstraints1);
            this.jPanelDuration.add((Component)this.getJTextFieldReleaseDuration(), gbc_jTextFieldReleaseDuration);
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("Total time:");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.insets = new Insets(4, 8, 5, 5);
            this.jPanelDuration.add((Component)this.jLabel2, gridBagConstraints2);
            GridBagConstraints gbc_jTextFieldTotalDuration = new GridBagConstraints();
            gbc_jTextFieldTotalDuration.fill = 2;
            gbc_jTextFieldTotalDuration.gridx = 3;
            gbc_jTextFieldTotalDuration.gridy = 3;
            gbc_jTextFieldTotalDuration.weightx = 1.0;
            gbc_jTextFieldTotalDuration.insets = new Insets(4, 4, 5, 5);
            this.jPanelDuration.add((Component)this.getJTextFieldTotalDuration(), gbc_jTextFieldTotalDuration);
            this.jLabel3 = new JLabel();
            this.jLabel3.setText("ms.");
            this.jLabel3.setToolTipText("Milliseconds");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.insets = new Insets(4, 4, 5, 4);
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.gridx = 4;
            this.jPanelDuration.add((Component)this.jLabel3, gridBagConstraints4);
        }
        return this.jPanelDuration;
    }

    protected void initFaderClickPropertiesPanel() {
        DocumentListener adjustTotalTime = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FaderClickPropertiesPanel.this.adjustTotalTime();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FaderClickPropertiesPanel.this.adjustTotalTime();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FaderClickPropertiesPanel.this.adjustTotalTime();
            }
        };
        this.getJTextFieldAttackDuration().getDocument().addDocumentListener(adjustTotalTime);
        this.getJTextFieldPeakDuration().getDocument().addDocumentListener(adjustTotalTime);
        this.getJTextFieldReleaseDuration().getDocument().addDocumentListener(adjustTotalTime);
        DocumentListener handleTotalTimeChanged = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FaderClickPropertiesPanel.this.handleTotalTimeChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FaderClickPropertiesPanel.this.handleTotalTimeChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FaderClickPropertiesPanel.this.handleTotalTimeChanged();
            }
        };
        this.getJTextFieldTotalDuration().getDocument().addDocumentListener(handleTotalTimeChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustTotalTime() {
        if (this.refreshing) {
            return;
        }
        try {
            this.refreshing = true;
            this.attackDuration = this.timeValue(this.getJTextFieldAttackDuration().getText());
            this.peakDuration = this.timeValue(this.getJTextFieldPeakDuration().getText());
            this.releaseDuration = this.timeValue(this.getJTextFieldReleaseDuration().getText());
            this.totalTime = this.attackDuration + this.peakDuration + this.releaseDuration;
            this.getJTextFieldTotalDuration().setText(this.timeString(this.totalTime));
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleTotalTimeChanged() {
        if (this.refreshing) {
            return;
        }
        try {
            this.refreshing = true;
            double newTotal = this.timeValue(this.getJTextFieldTotalDuration().getText());
            if (this.totalTime > 0.0 && newTotal > 0.0) {
                this.attackDuration = this.attackDuration * newTotal / this.totalTime;
                this.releaseDuration = this.releaseDuration * newTotal / this.totalTime;
                this.peakDuration = newTotal - this.attackDuration - this.releaseDuration;
                this.totalTime = this.attackDuration + this.peakDuration + this.releaseDuration;
                this.getJTextFieldAttackDuration().setText(this.timeString(this.attackDuration));
                this.getJTextFieldPeakDuration().setText(this.timeString(this.peakDuration));
                this.getJTextFieldReleaseDuration().setText(this.timeString(this.releaseDuration));
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        finally {
            this.refreshing = false;
        }
    }

    private JLabel getLblPeakValue() {
        if (this.lblPeakValue == null) {
            this.lblPeakValue = new JLabel("Peak position:");
        }
        return this.lblPeakValue;
    }

    private JLabel getLblTargetValue() {
        if (this.lblTargetValue == null) {
            this.lblTargetValue = new JLabel("Target position:");
        }
        return this.lblTargetValue;
    }

    private JLabel getLblPrevious() {
        if (this.lblPrevious == null) {
            this.lblPrevious = new JLabel("Initial position:");
        }
        return this.lblPrevious;
    }

    private JTextField getTextFieldInitValue() {
        if (this.textFieldInitValue == null) {
            this.textFieldInitValue = new JTextField();
            this.textFieldInitValue.setOpaque(false);
            this.textFieldInitValue.setEditable(false);
            this.textFieldInitValue.setColumns(6);
        }
        return this.textFieldInitValue;
    }

    private JTextField getTextFieldPeakValue() {
        if (this.textFieldPeakValue == null) {
            this.textFieldPeakValue = new JTextField();
            this.textFieldPeakValue.setOpaque(false);
            this.textFieldPeakValue.setColumns(6);
        }
        return this.textFieldPeakValue;
    }

    private JTextField getTextFieldTargetValue() {
        if (this.textFieldTargetValue == null) {
            this.textFieldTargetValue = new JTextField();
            this.textFieldTargetValue.setOpaque(false);
            this.textFieldTargetValue.setColumns(6);
        }
        return this.textFieldTargetValue;
    }
}

