/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.FaderPoint;
import com.waxmonster.editor.impl.AbstractFaderPointRenderer;
import com.waxmonster.fader.FaderCurve;
import java.awt.Color;
import java.awt.Graphics;

public class FaderMoveFaderPointRenderer
extends AbstractFaderPointRenderer {
    private Color pointLineColor = Color.GRAY;
    private Color[] pointFillColors = new Color[]{Color.BLACK};

    public FaderMoveFaderPointRenderer() {
        this.setMinPointSize(4);
        this.setMaxPointSize(40);
    }

    public void paintPoint(Graphics g, FaderPoint fp, FaderCurve fc, double mpu, double tpu, int orientation, boolean inverted) {
        int py;
        int px;
        int ph;
        int pw;
        double v = inverted ? fp.getPointValue() / tpu : -fp.getPointValue() / tpu;
        double t = fp.getPointTime() / mpu;
        double s = fp.getTimeLength() / mpu;
        int ps = (int)Math.round(s);
        if (ps < this.minPointSize) {
            ps = this.minPointSize;
        } else if (ps > this.maxPointSize) {
            ps = this.maxPointSize;
        }
        switch (orientation) {
            case 0: {
                pw = ps;
                ph = ps;
                px = (int)Math.round(t - (double)pw / 2.0);
                py = (int)Math.round(v - (double)ph / 2.0);
                break;
            }
            case 2: {
                pw = ps;
                ph = ps;
                px = (int)Math.round(v - (double)pw / 2.0);
                py = (int)Math.round(t - (double)ph / 2.0);
                break;
            }
            default: {
                return;
            }
        }
        Color fill = null;
        FaderMove fm = fp.getFaderMove();
        if (fm != null) {
            int num;
            int x;
            float vol = fm.getTargetValue();
            if (fc != null) {
                vol = fc.getVolume(vol);
            }
            if ((x = Math.round(vol * (float)(num = this.pointFillColors.length))) < 0) {
                x = 0;
            } else if (x >= num) {
                x = num - 1;
            }
            fill = this.pointFillColors[x];
        }
        if (fill != null) {
            g.setColor(fill);
            g.fillOval(px, py, pw, ph);
        }
        if (this.pointLineColor != null) {
            g.setColor(this.pointLineColor);
            g.drawOval(px, py, pw, ph);
        }
    }

    public void paintBackground(Graphics g, FaderPoint fp, FaderCurve fc, double mpu, double tpu, int orientation, boolean inverted) {
    }

    public Color getPointLineColor() {
        return this.pointLineColor;
    }

    public void setPointLineColor(Color pointLineColor) {
        this.pointLineColor = pointLineColor;
    }

    public Color[] getPointFillColors() {
        return this.pointFillColors;
    }

    public void setPointFillColors(Color[] pointFillColors) {
        this.pointFillColors = pointFillColors;
    }
}

