/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.Interpolator;

public class HermiteSplineInterpolator
implements Interpolator {
    private static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    private double[] x = EMPTY_DOUBLE_ARRAY;
    private double[] y = EMPTY_DOUBLE_ARRAY;
    private double[] d = EMPTY_DOUBLE_ARRAY;
    private double[] m = EMPTY_DOUBLE_ARRAY;
    private int size;
    private double human;

    public HermiteSplineInterpolator() {
        this(1.0);
    }

    public HermiteSplineInterpolator(double human) {
        this.setHuman(human);
    }

    public double getHuman() {
        return this.human;
    }

    public void setHuman(double human) {
        this.human = human;
    }

    public void update(double[] x, double[] y, int n) {
        int i;
        this.x = x;
        this.y = y;
        this.size = n;
        if (n - 1 > this.d.length) {
            this.d = new double[n - 1];
        }
        for (i = 1; i < n; ++i) {
            double h = x[i] - x[i - 1];
            this.d[i - 1] = (y[i] - y[i - 1]) / h;
        }
        if (n > this.m.length) {
            this.m = new double[n];
        }
        this.m[0] = this.d[0];
        for (i = 1; i < n - 1; ++i) {
            this.m[i] = (this.d[i - 1] + this.d[i]) * 0.5;
        }
        this.m[n - 1] = this.d[n - 2];
        for (int i2 = 0; i2 < n - 1; ++i2) {
            if (this.d[i2] == 0.0) {
                this.m[i2] = 0.0;
                this.m[i2 + 1] = 0.0;
                continue;
            }
            double a = this.m[i2] / this.d[i2];
            double b = this.m[i2 + 1] / this.d[i2];
            double h = StrictMath.sqrt(a * a + b * b);
            if (!(h > 9.0)) continue;
            double t = 3.0 / h;
            this.m[i2] = t * a * this.d[i2];
            this.m[i2 + 1] = t * b * this.d[i2];
        }
    }

    public void interpolate(double mp, double mu, double[] dst, int off, int len) {
        double p;
        int lo = 0;
        int hi = this.size - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            p = this.x[i];
            if (mp < p) {
                hi = i - 1;
                continue;
            }
            if (mp > p) {
                lo = i + 1;
                continue;
            }
            lo = i;
            break;
        }
        if (this.x[lo] > mp) {
            if (--lo < 0) {
                lo = 0;
                hi = 0;
            } else {
                hi = lo + 1;
            }
        } else {
            hi = lo + 1;
        }
        int end = off + len;
        if (hi < this.size) {
            double h = this.x[hi] - this.x[lo];
            while (off < end) {
                double t = (mp - this.x[lo]) / h;
                dst[off++] = (this.y[lo] * (1.0 + 2.0 * t) + h * this.m[lo] * t) * (1.0 - t) * (1.0 - t) + (this.y[hi] * (3.0 - 2.0 * t) + h * this.m[hi] * (t - 1.0)) * t * t;
                if (!(this.x[hi] <= (mp += mu))) continue;
                if (++hi >= this.size) break;
                while (hi < this.size && this.x[hi] <= mp) {
                    ++hi;
                }
                if (hi >= this.size) break;
                lo = hi - 1;
                h = this.x[hi] - this.x[lo];
            }
        }
        if (off < end) {
            double d = p = this.size < 1 ? 0.0 : this.y[this.size - 1];
            while (off < end) {
                dst[off++] = p;
            }
        }
    }
}

