/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.editor.impl.DefaultFaderMove;
import com.waxmonster.model.FaderModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.impl.AbstractLineSampleModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class InterpolatedFaderModel
extends AbstractLineSampleModel
implements FaderModel {
    public static final double DEFAULT_FADE_MILLIS = 10.0;
    private double startTime;
    private List items = new ArrayList();
    private double baseTime;
    private double mf;
    private boolean valid = false;
    private float startValue;
    private float fadeInValue = 1.0f;
    private float fadeOutValue = 0.0f;
    private double fadeInMillis = 10.0;
    private double fadeOutMillis = 10.0;
    private int fn;
    private double[] fx;
    private FaderMove[] fv;

    public InterpolatedFaderModel(float frameRate) {
        super(frameRate);
        this.setFrameRate(frameRate);
    }

    public int getWaxEditorItemCount() {
        return this.items.size();
    }

    public WaxEditorItem getWaxEditorItemAt(int index) {
        return (WaxEditorItem)this.items.get(index);
    }

    public int getWaxEditorItemIndex(WaxEditorItem item) {
        return this.items.indexOf(item);
    }

    public void addWaxEditorItem(WaxEditorItem item) {
        this.insertWaxEditorItemAt(item, this.items.size());
    }

    public void insertWaxEditorItemAt(WaxEditorItem item, int index) {
        this.items.add(index, item);
        this.invalidate();
        this.adjustFrameLen();
    }

    public void removeWaxEditorItem(WaxEditorItem item) {
        int index = this.items.indexOf(item);
        if (index < 0) {
            return;
        }
        this.removeWaxEditorItemAt(index);
    }

    public void removeWaxEditorItemAt(int index) {
        this.items.remove(index);
        this.invalidate();
        this.adjustFrameLen();
    }

    protected void setFrameRate(float frameRate) {
        super.setFrameRate(frameRate);
        this.mf = 1000.0 / (double)this.getFrameRate();
        this.adjustFrameLen();
    }

    protected void adjustFrameLen() {
        long frameLen = 0L;
        int num = this.items.size();
        if (num > 0) {
            double startTime;
            WaxEditorItem ref = (WaxEditorItem)this.items.get(0);
            ScratchEditorModel sem = ref.getModel();
            WaxEditorModel wem = ref.getParent();
            this.baseTime = startTime = wem.getStartTime() + ref.getStartTime();
            ref = (WaxEditorItem)this.items.get(num - 1);
            sem = ref.getModel();
            wem = ref.getParent();
            double endTime = wem.getStartTime() + ref.getStartTime() + sem.getTimeLength();
            double frames = (endTime - startTime) * (double)this.getFrameRate() / 1000.0;
            if (frames > (double)(frameLen = (long)frames)) {
                ++frameLen;
            }
        }
        this.setFrameLength(frameLen);
    }

    public void close() throws IOException {
    }

    public float getFadeInValue() {
        return this.fadeInValue;
    }

    public void setFadeInValue(float fadeInValue) {
        this.fadeInValue = fadeInValue;
        this.invalidate();
    }

    public float getFadeOutValue() {
        return this.fadeOutValue;
    }

    public void setFadeOutValue(float fadeOutValue) {
        this.fadeOutValue = fadeOutValue;
        this.invalidate();
    }

    public double getFadeInMillis() {
        return this.fadeInMillis;
    }

    public void setFadeInMillis(double fadeInMillis) {
        this.fadeInMillis = fadeInMillis;
        this.invalidate();
    }

    public double getFadeOutMillis() {
        return this.fadeOutMillis;
    }

    public void setFadeOutMillis(double fadeOutMillis) {
        this.fadeOutMillis = fadeOutMillis;
        this.invalidate();
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    public void validate() {
        ScratchEditorModel sem;
        WaxEditorItem ref;
        if (this.valid) {
            return;
        }
        int num = this.items.size();
        int capacity = 2;
        for (int i = 0; i < num; ++i) {
            ref = (WaxEditorItem)this.items.get(i);
            sem = ref.getModel();
            capacity += sem.getFaderMoveCount();
        }
        if (this.fx == null || this.fx.length < capacity) {
            this.fx = new double[capacity];
            this.fv = new FaderMove[capacity];
        } else {
            int n = this.fn;
            for (int i = 0; i < n; ++i) {
                this.fv[i] = null;
            }
        }
        this.fn = 0;
        if (this.fadeInMillis >= 0.0) {
            this.putFaderMove(0.0, new DefaultFaderMove(this.fadeInMillis, this.fadeInValue));
        }
        double timeLen = 0.0;
        for (int i = 0; i < num; ++i) {
            ref = (WaxEditorItem)this.items.get(i);
            sem = ref.getModel();
            WaxEditorModel wem = ref.getParent();
            double startTime = wem.getStartTime() + ref.getStartTime() - this.baseTime;
            double endTime = startTime + sem.getTimeLength();
            if (endTime > timeLen) {
                timeLen = endTime;
            }
            int count = sem.getFaderMoveCount();
            for (int k = 0; k < count; ++k) {
                double ofs = sem.getFaderMoveOffsetAt(k);
                FaderMove fm = sem.getFaderMoveAt(k);
                this.putFaderMove(startTime + ofs, fm);
            }
        }
        if (this.fadeOutMillis >= 0.0) {
            double fadeOutOffset = timeLen - this.fadeOutMillis;
            if (fadeOutOffset < 0.0) {
                fadeOutOffset = 0.0;
            }
            this.putFaderMove(fadeOutOffset, new DefaultFaderMove(this.fadeOutMillis, this.fadeOutValue));
        }
        this.valid = true;
    }

    protected void putFaderMove(double o, FaderMove v) {
        int i;
        int lo = 0;
        int hi = this.fn - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            double p = this.fx[i];
            if (o < p) {
                hi = i - 1;
                continue;
            }
            if (o > p) {
                lo = i + 1;
                continue;
            }
            this.fv[i] = v;
            return;
        }
        i = this.fn - lo;
        if (++this.fn > this.fx.length) {
            double[] newX = new double[this.fx.length * 2];
            System.arraycopy(this.fx, 0, newX, 0, lo);
            newX[lo] = o;
            System.arraycopy(this.fx, lo, newX, lo + 1, i);
            this.fx = newX;
            FaderMove[] newY = new FaderMove[newX.length];
            System.arraycopy(this.fv, 0, newY, 0, lo);
            newY[lo] = v;
            System.arraycopy(this.fv, lo, newY, lo + 1, i);
            this.fv = newY;
        } else {
            System.arraycopy(this.fx, lo, this.fx, lo + 1, i);
            System.arraycopy(this.fv, lo, this.fv, lo + 1, i);
            this.fx[lo] = o;
            this.fv[lo] = v;
        }
    }

    public float getStartValue() {
        return this.startValue;
    }

    public void setStartValue(float startValue) {
        this.startValue = startValue;
    }

    public void getValues(long framePosition, float[] dst, int off, int len) throws IOException {
        this.getValues((double)framePosition, 1.0, dst, off, len);
    }

    public void getValues(double framePosition, double framesPerUnit, float[] dst, int off, int len) throws IOException {
        FaderMove m;
        double t;
        double x;
        int i;
        if (!this.valid) {
            this.validate();
        }
        double mp = framePosition * this.mf;
        double mu = framesPerUnit * this.mf;
        int end = off + len;
        int lo = 0;
        int hi = this.fn - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            double p = this.fx[i];
            if (mp < p) {
                hi = i - 1;
                continue;
            }
            if (mp > p) {
                lo = i + 1;
                continue;
            }
            hi = i;
            break;
        }
        if ((i = hi) < 0) {
            i = 0;
            if (this.fn < 1) {
                float sv = this.startValue;
                while (off < end) {
                    dst[off++] = sv;
                }
                return;
            }
        }
        if ((x = this.fx[i]) + (t = (m = this.fv[i]).getTimeLength()) <= mp) {
            if (++i >= this.fn) {
                float sv = this.fn < 1 ? this.startValue : this.fv[this.fn - 1].getTargetValue();
                while (off < end) {
                    dst[off++] = sv;
                }
                return;
            }
            x = this.fx[i];
            m = this.fv[i];
            t = m.getTimeLength();
        }
        float sv = i < 1 ? this.startValue : this.fv[i - 1].getTargetValue();
        while (off < end) {
            int num;
            if (mp < x) {
                num = Math.min(end - off, 1 + (int)((x - mp) / mu));
                mp += (double)num * mu;
                num += off;
                while (off < num) {
                    dst[off++] = sv;
                }
            }
            if ((num = Math.min(end - off, (int)((x + t - mp) / mu))) > 0) {
                m.interpolate(sv, mp - x, mu, dst, off, num);
                off += num;
                mp += (double)num * mu;
            }
            sv = m.getTargetValue();
            if (++i >= this.fn) {
                while (off < end) {
                    dst[off++] = sv;
                }
                break;
            }
            x = this.fx[i];
            m = this.fv[i];
            t = m.getTimeLength();
        }
    }

    public void getValues(double framePosition, double framesPerUnit, double[] dst, int off, int len) throws IOException {
        FaderMove m;
        double t;
        double x;
        int i;
        if (!this.valid) {
            this.validate();
        }
        double mp = framePosition * this.mf;
        double mu = framesPerUnit * this.mf;
        int end = off + len;
        int lo = 0;
        int hi = this.fn - 1;
        while (lo <= hi) {
            i = lo + hi >> 1;
            double p = this.fx[i];
            if (mp < p) {
                hi = i - 1;
                continue;
            }
            if (mp > p) {
                lo = i + 1;
                continue;
            }
            hi = i;
            break;
        }
        if ((i = hi) < 0) {
            i = 0;
            if (this.fn < 1) {
                float sv = this.startValue;
                while (off < end) {
                    dst[off++] = sv;
                }
                return;
            }
        }
        if ((x = this.fx[i]) + (t = (m = this.fv[i]).getTimeLength()) <= mp) {
            if (++i >= this.fn) {
                float sv = this.fn < 1 ? this.startValue : this.fv[this.fn - 1].getTargetValue();
                while (off < end) {
                    dst[off++] = sv;
                }
                return;
            }
            x = this.fx[i];
            m = this.fv[i];
            t = m.getTimeLength();
        }
        float sv = i < 1 ? this.startValue : this.fv[i - 1].getTargetValue();
        while (off < end) {
            int num;
            if (mp < x) {
                num = Math.min(end - off, 1 + (int)((x - mp) / mu));
                mp += (double)num * mu;
                num += off;
                while (off < num) {
                    dst[off++] = sv;
                }
            }
            if ((num = Math.min(end - off, (int)((x + t - mp) / mu))) > 0) {
                m.interpolate(sv, mp - x, mu, dst, off, num);
                off += num;
                mp += (double)num * mu;
            }
            sv = m.getTargetValue();
            if (++i >= this.fn) {
                while (off < end) {
                    dst[off++] = sv;
                }
                break;
            }
            x = this.fx[i];
            m = this.fv[i];
            t = m.getTimeLength();
        }
    }

    public long getSamples() {
        return this.getFrameLength();
    }

    public int getChannels() {
        return 1;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void get(long i, float[] dst, int off, int len) throws IOException {
        this.getValues(i, dst, off, len);
    }

    public float getFloat(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, double[] dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, FloatBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, float v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, double v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void clear(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void remove(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void insert(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        throw new UnsupportedOperationException();
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }
}

