/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.spacekiller.util.sound.SampleBuffer;
import com.waxmonster.editor.Interpolator;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.model.MutableLineChunk;
import com.waxmonster.model.TimecodeModel;
import com.waxmonster.model.impl.AbstractLineSampleModel;
import java.io.IOException;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class InterpolatedTimecodeModel
extends AbstractLineSampleModel
implements TimecodeModel {
    private double startTime;
    private List items;
    private double baseTime;
    private double mf;
    private boolean valid;
    private Interpolator inter;

    public InterpolatedTimecodeModel(float frameRate, Interpolator inter) {
        super(frameRate);
        this.inter = inter;
        this.items = new ArrayList();
        this.valid = false;
        this.setFrameRate(frameRate);
    }

    public int getWaxEditorItemCount() {
        return this.items.size();
    }

    public WaxEditorItem getWaxEditorItemAt(int index) {
        return (WaxEditorItem)this.items.get(index);
    }

    public int getWaxEditorItemIndex(WaxEditorItem item) {
        return this.items.indexOf(item);
    }

    public void addWaxEditorItem(WaxEditorItem item) {
        this.insertWaxEditorItemAt(item, this.items.size());
    }

    public void insertWaxEditorItemAt(WaxEditorItem item, int index) {
        this.items.add(index, item);
        this.invalidate();
        this.adjustFrameLen();
    }

    public void removeWaxEditorItem(WaxEditorItem item) {
        int index = this.items.indexOf(item);
        if (index < 0) {
            return;
        }
        this.removeWaxEditorItemAt(index);
    }

    public void removeWaxEditorItemAt(int index) {
        this.items.remove(index);
        this.invalidate();
        this.adjustFrameLen();
    }

    protected void setFrameRate(float frameRate) {
        super.setFrameRate(frameRate);
        this.mf = 1000.0 / (double)this.getFrameRate();
        this.adjustFrameLen();
    }

    protected void adjustFrameLen() {
        long frameLen = 0L;
        int num = this.items.size();
        if (num > 0) {
            double startTime;
            WaxEditorItem ref = (WaxEditorItem)this.items.get(0);
            ScratchEditorModel sem = ref.getModel();
            WaxEditorModel wem = ref.getParent();
            this.baseTime = startTime = wem.getStartTime() + ref.getStartTime();
            ref = (WaxEditorItem)this.items.get(num - 1);
            sem = ref.getModel();
            wem = ref.getParent();
            double endTime = wem.getStartTime() + ref.getStartTime() + sem.getTimeLength();
            double frames = (endTime - startTime) * (double)this.getFrameRate() / 1000.0;
            if (frames > (double)(frameLen = (long)frames)) {
                ++frameLen;
            }
        }
        this.setFrameLength(frameLen);
    }

    public void close() throws IOException {
    }

    public boolean isValid() {
        return this.valid;
    }

    public void invalidate() {
        this.valid = false;
    }

    public void validate() {
        ScratchEditorModel sem;
        WaxEditorItem ref;
        if (this.valid) {
            return;
        }
        int points = 0;
        int num = this.items.size();
        for (int i = 0; i < num; ++i) {
            ref = (WaxEditorItem)this.items.get(i);
            sem = ref.getModel();
            points += sem.getTimecodePointCount() + 1;
        }
        double[] x = new double[points];
        double[] y = new double[points];
        int ofs = 0;
        for (int i = 0; i < num; ++i) {
            ref = (WaxEditorItem)this.items.get(i);
            sem = ref.getModel();
            WaxEditorModel wem = ref.getParent();
            double startTime = wem.getStartTime() + ref.getStartTime() - this.baseTime;
            double startValue = ref.getStartValue();
            if (ofs > 0 && x[ofs - 1] == startTime) {
                y[ofs - 1] = startValue;
            } else {
                x[ofs] = startTime;
                y[ofs] = startValue;
                ++ofs;
            }
            int size = sem.getTimecodePointCount();
            if (size <= 0) continue;
            sem.getTimecodePointOffsets(0, x, ofs, size);
            sem.getTimecodePointValues(0, y, ofs, size);
            int end = ofs + size;
            int k = ofs;
            while (k < end) {
                int n = k++;
                x[n] = x[n] + startTime;
            }
            k = ofs;
            while (k < end) {
                int n = k++;
                y[n] = y[n] + startValue;
            }
            ofs = end;
        }
        this.inter.update(x, y, ofs);
        this.valid = true;
    }

    public void getValues(long framePosition, double[] dst, int off, int len) throws IOException {
        this.getValues(framePosition, 1.0, dst, off, len);
    }

    public void getValues(double framePosition, double framesPerUnit, double[] dst, int off, int len) throws IOException {
        if (!this.valid) {
            this.validate();
        }
        double mp = framePosition * this.mf;
        double mu = framesPerUnit * this.mf;
        this.inter.interpolate(mp, mu, dst, off, len);
    }

    public long getSamples() {
        return this.getFrameLength();
    }

    public int getChannels() {
        return 1;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void get(long i, double[] dst, int off, int len) throws IOException {
        this.getValues(i, dst, off, len);
    }

    public void get(long i, float[] dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public float getFloat(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(long i) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, DoubleBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, FloatBuffer dst, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void get(long i, SampleBuffer dst, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, float v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, double v) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void set(long i, SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void clear(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void remove(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void insert(long i, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(double[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(DoubleBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(float[] src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(FloatBuffer src, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public long append(SampleBuffer src, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws IOException {
    }

    public MutableLineChunk createLineChunk(long chunkOfs, long chunkEnd, long modelOfs, long modelEnd) {
        throw new UnsupportedOperationException();
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        this.startTime = startTime;
    }
}

