/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.Interpolator;

public class LinearInterpolator
implements Interpolator {
    private double[] x;
    private double[] y;
    private int size;

    public void update(double[] x, double[] y, int n) {
        this.x = x;
        this.y = y;
        this.size = n;
    }

    public void interpolate(double mp, double mu, double[] dst, int off, int len) {
        double p;
        int lo = 0;
        int hi = this.size - 1;
        while (lo <= hi) {
            int i = lo + hi >> 1;
            p = this.x[i];
            if (mp < p) {
                hi = i - 1;
                continue;
            }
            if (mp > p) {
                lo = i + 1;
                continue;
            }
            lo = i;
            break;
        }
        if (this.x[lo] > mp) {
            if (--lo < 0) {
                lo = 0;
                hi = 0;
            } else {
                hi = lo + 1;
            }
        } else {
            hi = lo + 1;
        }
        int end = off + len;
        if (hi < this.size) {
            double h = this.x[hi] - this.x[lo];
            while (off < end) {
                double a = (this.x[hi] - mp) / h;
                double b = (mp - this.x[lo]) / h;
                dst[off++] = this.y[lo] * a + this.y[hi] * b;
                if (!(this.x[hi] <= (mp += mu))) continue;
                if (++hi >= this.size) break;
                while (hi < this.size && this.x[hi] <= mp) {
                    ++hi;
                }
                if (hi >= this.size) break;
                lo = hi - 1;
                h = this.x[hi] - this.x[lo];
            }
        }
        if (off < end) {
            double d = p = this.size < 1 ? 0.0 : this.y[this.size - 1];
            while (off < end) {
                dst[off++] = p;
            }
        }
    }
}

