/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.impl.DefaultScratchEditorModel;

public final class ScaledScratchEditorModel
extends DefaultScratchEditorModel {
    private final ScratchEditorModel model;
    private double timeScale;
    private double needleScale;

    public ScaledScratchEditorModel(ScratchEditorModel model, double timeScale, double needleScale) {
        super(model.getTimecodePointCount(), model.getFaderMoveCount());
        this.model = model;
        this.scale(timeScale, needleScale);
    }

    public final ScratchEditorModel getModel() {
        return this.model;
    }

    public double getTimeScale() {
        return this.timeScale;
    }

    public double getNeedleScale() {
        return this.needleScale;
    }

    public void scale(double newTimeScale, double newNeedleScale) {
        int i;
        this.timeScale = newTimeScale;
        this.needleScale = newNeedleScale;
        this.tn = this.model.getTimecodePointCount();
        if (this.tn > this.tx.length) {
            this.tx = new double[this.tn];
            this.tv = new double[this.tn];
        }
        for (i = 0; i < this.tn; ++i) {
            this.tx[i] = this.model.getTimecodePointOffsetAt(i) * this.timeScale;
            this.tv[i] = this.model.getTimecodePointValueAt(i) * this.needleScale;
        }
        this.fn = this.model.getFaderMoveCount();
        if (this.fn > this.fx.length) {
            this.fx = new double[this.fn];
            this.fv = new FaderMove[this.fn];
        }
        for (i = 0; i < this.fn; ++i) {
            this.fx[i] = this.model.getFaderMoveOffsetAt(i) * this.timeScale;
            this.fv[i] = this.model.getFaderMoveAt(i).createCopy(this.timeScale);
        }
    }

    @Override
    public int putTimecodePoint(double o, double v) {
        double mo = o / this.timeScale;
        double mv = v / this.needleScale;
        if (this.model.containsTimecodePoint(mo)) {
            int i = this.model.putTimecodePoint(mo, mv);
            this.tx[i] = o;
            this.tv[i] = v;
            return i;
        }
        int i = this.model.putTimecodePoint(mo, mv);
        int n = this.tn - i;
        if (++this.tn > this.tx.length) {
            double[] newX = new double[this.tx.length * 2];
            System.arraycopy(this.tx, 0, newX, 0, i);
            newX[i] = o;
            System.arraycopy(this.tx, i, newX, i + 1, n);
            double[] newY = new double[newX.length];
            System.arraycopy(this.tv, 0, newY, 0, i);
            newY[i] = v;
            System.arraycopy(this.tv, i, newY, i + 1, n);
            this.tx = newX;
            this.tv = newY;
        } else {
            System.arraycopy(this.tx, i, this.tx, i + 1, n);
            System.arraycopy(this.tv, i, this.tv, i + 1, n);
            this.tx[i] = o;
            this.tv[i] = v;
        }
        return i;
    }

    @Override
    public double removeTimecodePointAt(int i) {
        this.model.removeTimecodePointAt(i);
        return super.removeTimecodePointAt(i);
    }

    @Override
    public void removeAllTimecodePoints() {
        this.model.removeAllTimecodePoints();
        super.removeAllTimecodePoints();
    }

    @Override
    public void moveTimecodePoints(int index, int end, double ro, double rv) {
        this.model.moveTimecodePoints(index, end, ro / this.timeScale, rv / this.needleScale);
        super.moveTimecodePoints(index, end, ro, rv);
    }

    @Override
    public int putFaderMove(double o, FaderMove v) {
        double mo = o / this.timeScale;
        FaderMove mv = v.createCopy(1.0 / this.timeScale);
        if (this.model.containsFaderMove(mo)) {
            int i = this.model.putFaderMove(mo, mv);
            this.fx[i] = o;
            this.fv[i] = v;
            return i;
        }
        int i = this.model.putFaderMove(mo, mv);
        int n = this.fn - i;
        if (++this.fn > this.fx.length) {
            double[] newX = new double[this.fx.length * 2];
            System.arraycopy(this.fx, 0, newX, 0, i);
            newX[i] = o;
            System.arraycopy(this.fx, i, newX, i + 1, n);
            FaderMove[] newY = new FaderMove[newX.length];
            System.arraycopy(this.fv, 0, newY, 0, i);
            newY[i] = v;
            System.arraycopy(this.fv, i, newY, i + 1, n);
            this.fx = newX;
            this.fv = newY;
        } else {
            System.arraycopy(this.fx, i, this.fx, i + 1, n);
            System.arraycopy(this.fv, i, this.fv, i + 1, n);
            this.fx[i] = o;
            this.fv[i] = v;
        }
        return i;
    }

    @Override
    public FaderMove removeFaderMoveAt(int i) {
        this.model.removeFaderMoveAt(i);
        return super.removeFaderMoveAt(i);
    }

    @Override
    public void moveFaderMoves(int index, int end, double ro) {
        this.model.moveFaderMoves(index, end, ro / this.timeScale);
        super.moveFaderMoves(index, end, ro);
    }

    @Override
    public ScratchEditorModel createCopy(double timeScale, double needleScale) {
        return new ScaledScratchEditorModel(this.model.createCopy(), timeScale * this.timeScale, needleScale * this.needleScale);
    }
}

