/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.InterpolatorProvider;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.impl.PropertiesPanel;
import com.waxmonster.editor.impl.ScaledScratchEditorModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class WaxEditorItemPropertiesPanel
extends JPanel
implements PropertiesPanel {
    private static final long serialVersionUID = 66487680022895471L;
    private static final String DEFAULT_INTERPOLATOR = "<default>";
    private String title;
    private WaxEditorItem item;
    private InterpolatorRegistry interpolatorRegistry;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JTextField jTextFieldStartTime = null;
    private JTextField jTextFieldStartValue = null;
    private JCheckBox jCheckBoxAutoConnect = null;
    private JLabel jLabel2 = null;
    private JLabel jLabel21 = null;
    private JLabel jLabel3 = null;
    private JComboBox jComboBoxInterpolation = null;
    private JPanel panelOptions = null;
    private JPanel panelScale;
    private JPanel panelPosition;
    private JLabel lblScaleFactor;
    private JLabel lblScaleFactor_1;
    private JTextField textFieldTimeScale;
    private JTextField textFieldNeedleScale;
    private JLabel lblNewLabel;
    private JLabel lblNewLabel_1;

    public WaxEditorItemPropertiesPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gbc_panelOptions = new GridBagConstraints();
        gbc_panelOptions.gridx = 0;
        gbc_panelOptions.weightx = 1.0;
        gbc_panelOptions.fill = 2;
        gbc_panelOptions.insets = new Insets(4, 0, 0, 0);
        gbc_panelOptions.gridy = 2;
        this.jLabel3 = new JLabel();
        this.jLabel3.setText("Interpolation:");
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(331, 299));
        GridBagConstraints gbc_panelPosition = new GridBagConstraints();
        gbc_panelPosition.insets = new Insets(0, 0, 5, 0);
        gbc_panelPosition.fill = 1;
        gbc_panelPosition.gridx = 0;
        gbc_panelPosition.gridy = 0;
        this.add((Component)this.getPanelPosition(), gbc_panelPosition);
        GridBagConstraints gbc_panelScale = new GridBagConstraints();
        gbc_panelScale.insets = new Insets(0, 0, 5, 0);
        gbc_panelScale.fill = 1;
        gbc_panelScale.gridx = 0;
        gbc_panelScale.gridy = 1;
        this.add((Component)this.getPanelScale(), gbc_panelScale);
        this.add((Component)this.getPanelOptions(), gbc_panelOptions);
    }

    private JTextField getJTextFieldStartTime() {
        if (this.jTextFieldStartTime == null) {
            this.jTextFieldStartTime = new JTextField();
            this.jTextFieldStartTime.setToolTipText("Start timestamp in milliseconds");
        }
        return this.jTextFieldStartTime;
    }

    private JTextField getJTextFieldStartValue() {
        if (this.jTextFieldStartValue == null) {
            this.jTextFieldStartValue = new JTextField();
            this.jTextFieldStartValue.setToolTipText("Start needle position in milliseconds");
        }
        return this.jTextFieldStartValue;
    }

    private JCheckBox getJCheckBoxAutoConnect() {
        if (this.jCheckBoxAutoConnect == null) {
            this.jCheckBoxAutoConnect = new JCheckBox();
            this.jCheckBoxAutoConnect.setText("Auto-Connect");
            this.jCheckBoxAutoConnect.setToolTipText("Auto connect to previous model ?");
        }
        return this.jCheckBoxAutoConnect;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void refresh() {
        InterpolatorProvider[] providers;
        double startTime = this.item.getStartTime();
        double startValue = this.item.getStartValue();
        boolean autoConnect = this.item.isAutoConnect();
        String interName = this.item.getInterpolation();
        double timeScale = 1.0;
        double needleScale = 1.0;
        ScratchEditorModel sem = this.item.getModel();
        if (sem != null && sem instanceof ScaledScratchEditorModel) {
            ScaledScratchEditorModel scaled = (ScaledScratchEditorModel)sem;
            timeScale = scaled.getTimeScale();
            needleScale = scaled.getNeedleScale();
        }
        this.getJTextFieldStartTime().setText(this.timeString(startTime));
        this.getJTextFieldStartValue().setText(this.timeString(startValue));
        this.getTextFieldTimeScale().setText(String.valueOf(timeScale));
        this.getTextFieldNeedleScale().setText(String.valueOf(needleScale));
        this.getJCheckBoxAutoConnect().setSelected(autoConnect);
        this.getJComboBoxInterpolation().removeAllItems();
        this.getJComboBoxInterpolation().addItem(DEFAULT_INTERPOLATOR);
        int selInter = -1;
        if (this.interpolatorRegistry != null && (providers = this.interpolatorRegistry.getInterpolatorProviders()) != null) {
            for (int i = 0; i < providers.length; ++i) {
                String title;
                InterpolatorProvider ip = providers[i];
                if (ip == null) continue;
                String name = ip.getName();
                if (name != null && name.equals(interName) && selInter < 0) {
                    selInter = this.getJComboBoxInterpolation().getItemCount();
                }
                if ((title = ip.getTitle()) == null) {
                    title = ip.getClass().getName();
                }
                this.getJComboBoxInterpolation().addItem(title);
            }
        }
        if (selInter >= 0) {
            this.getJComboBoxInterpolation().setSelectedIndex(selInter);
        }
    }

    protected String timeString(double millis) {
        long ms = (long)millis;
        if ((double)ms == millis) {
            return String.valueOf(ms);
        }
        return String.valueOf(millis);
    }

    protected double timeValue(String s) throws NumberFormatException {
        return Double.parseDouble(s.trim());
    }

    @Override
    public void apply() {
        ScaledScratchEditorModel scaled;
        InterpolatorProvider[] providers;
        this.item.setStartTime(this.timeValue(this.jTextFieldStartTime.getText()));
        this.item.setStartValue(this.timeValue(this.jTextFieldStartValue.getText()));
        this.item.setAutoConnect(this.jCheckBoxAutoConnect.isSelected());
        String interName = null;
        int selInter = this.jComboBoxInterpolation.getSelectedIndex();
        if (selInter >= 1 && this.interpolatorRegistry != null && --selInter < (providers = this.interpolatorRegistry.getInterpolatorProviders()).length) {
            interName = providers[selInter].getName();
        }
        this.item.setInterpolation(interName);
        ScratchEditorModel sem = this.item.getModel();
        if (sem == null) {
            return;
        }
        double newTimeScale = Double.parseDouble(this.textFieldTimeScale.getText().trim());
        double newNeedleScale = Double.parseDouble(this.textFieldNeedleScale.getText().trim());
        if (sem instanceof ScaledScratchEditorModel) {
            scaled = (ScaledScratchEditorModel)sem;
            if (scaled.getTimeScale() == newTimeScale && scaled.getNeedleScale() == newNeedleScale) {
                return;
            }
            sem = scaled.getModel();
        } else if (newTimeScale == 1.0 && newNeedleScale == 1.0) {
            return;
        }
        scaled = new ScaledScratchEditorModel(sem, newTimeScale, newNeedleScale);
        this.item.setModel((ScratchEditorModel)scaled);
    }

    private JComboBox getJComboBoxInterpolation() {
        if (this.jComboBoxInterpolation == null) {
            this.jComboBoxInterpolation = new JComboBox();
            this.jComboBoxInterpolation.setOpaque(false);
        }
        return this.jComboBoxInterpolation;
    }

    private JPanel getPanelOptions() {
        if (this.panelOptions == null) {
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.gridwidth = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.gridwidth = 2;
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.insets = new Insets(4, 4, 4, 4);
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.insets = new Insets(4, 4, 4, 4);
            this.panelOptions = new JPanel();
            this.panelOptions.setLayout(new GridBagLayout());
            this.panelOptions.setOpaque(true);
            this.panelOptions.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Options", 0, 0, null, null));
            this.panelOptions.add((Component)this.jLabel3, gridBagConstraints7);
            this.panelOptions.add((Component)this.getJComboBoxInterpolation(), gridBagConstraints8);
            this.panelOptions.add((Component)this.getJCheckBoxAutoConnect(), gridBagConstraints4);
        }
        return this.panelOptions;
    }

    public InterpolatorRegistry getInterpolatorRegistry() {
        return this.interpolatorRegistry;
    }

    public void setInterpolatorRegistry(InterpolatorRegistry interpolatorRegistry) {
        this.interpolatorRegistry = interpolatorRegistry;
    }

    private JPanel getPanelScale() {
        if (this.panelScale == null) {
            this.panelScale = new JPanel();
            this.panelScale.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Scale Factor", 4, 2, null, null));
            GridBagLayout gbl_panelScale = new GridBagLayout();
            gbl_panelScale.columnWidths = new int[]{0, 133, 0, 0};
            gbl_panelScale.rowHeights = new int[]{16, 0, 0};
            gbl_panelScale.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_panelScale.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelScale.setLayout(gbl_panelScale);
            GridBagConstraints gbc_lblScaleFactor = new GridBagConstraints();
            gbc_lblScaleFactor.anchor = 17;
            gbc_lblScaleFactor.insets = new Insets(4, 4, 5, 5);
            gbc_lblScaleFactor.gridx = 0;
            gbc_lblScaleFactor.gridy = 0;
            this.panelScale.add((Component)this.getLblScaleFactor(), gbc_lblScaleFactor);
            GridBagConstraints gbc_textFieldTimeScale = new GridBagConstraints();
            gbc_textFieldTimeScale.weightx = 1.0;
            gbc_textFieldTimeScale.insets = new Insets(4, 4, 5, 5);
            gbc_textFieldTimeScale.fill = 2;
            gbc_textFieldTimeScale.gridx = 1;
            gbc_textFieldTimeScale.gridy = 0;
            this.panelScale.add((Component)this.getTextFieldTimeScale(), gbc_textFieldTimeScale);
            GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
            gbc_lblNewLabel.insets = new Insets(4, 4, 5, 5);
            gbc_lblNewLabel.gridx = 2;
            gbc_lblNewLabel.gridy = 0;
            this.panelScale.add((Component)this.getLblNewLabel(), gbc_lblNewLabel);
            GridBagConstraints gbc_lblScaleFactor_1 = new GridBagConstraints();
            gbc_lblScaleFactor_1.anchor = 17;
            gbc_lblScaleFactor_1.insets = new Insets(4, 4, 5, 5);
            gbc_lblScaleFactor_1.gridx = 0;
            gbc_lblScaleFactor_1.gridy = 1;
            this.panelScale.add((Component)this.getLblScaleFactor_1(), gbc_lblScaleFactor_1);
            GridBagConstraints gbc_textFieldNeedleScale = new GridBagConstraints();
            gbc_textFieldNeedleScale.weightx = 1.0;
            gbc_textFieldNeedleScale.insets = new Insets(4, 4, 5, 5);
            gbc_textFieldNeedleScale.fill = 2;
            gbc_textFieldNeedleScale.gridx = 1;
            gbc_textFieldNeedleScale.gridy = 1;
            this.panelScale.add((Component)this.getTextFieldNeedleScale(), gbc_textFieldNeedleScale);
            GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
            gbc_lblNewLabel_1.insets = new Insets(4, 4, 5, 5);
            gbc_lblNewLabel_1.gridx = 2;
            gbc_lblNewLabel_1.gridy = 1;
            this.panelScale.add((Component)this.getLblNewLabel_1(), gbc_lblNewLabel_1);
        }
        return this.panelScale;
    }

    private JPanel getPanelPosition() {
        if (this.panelPosition == null) {
            this.panelPosition = new JPanel();
            this.panelPosition.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "Model Position", 4, 2, null, null));
            GridBagLayout gbl_panelPosition = new GridBagLayout();
            gbl_panelPosition.columnWidths = new int[]{0, 0, 0, 0};
            gbl_panelPosition.rowHeights = new int[]{0, 0, 0};
            gbl_panelPosition.columnWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
            gbl_panelPosition.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelPosition.setLayout(gbl_panelPosition);
            this.jLabel = new JLabel();
            GridBagConstraints gbc_jLabel = new GridBagConstraints();
            gbc_jLabel.anchor = 17;
            gbc_jLabel.insets = new Insets(4, 4, 5, 5);
            gbc_jLabel.gridx = 0;
            gbc_jLabel.gridy = 0;
            this.panelPosition.add((Component)this.jLabel, gbc_jLabel);
            this.jLabel.setText("Start Time:");
            this.jLabel.setToolTipText("Start timestamp in milliseconds");
            GridBagConstraints gbc_jTextFieldStartTime = new GridBagConstraints();
            gbc_jTextFieldStartTime.fill = 2;
            gbc_jTextFieldStartTime.weightx = 1.0;
            gbc_jTextFieldStartTime.insets = new Insets(4, 4, 5, 5);
            gbc_jTextFieldStartTime.gridx = 1;
            gbc_jTextFieldStartTime.gridy = 0;
            this.panelPosition.add((Component)this.getJTextFieldStartTime(), gbc_jTextFieldStartTime);
            this.jLabel2 = new JLabel();
            GridBagConstraints gbc_jLabel2 = new GridBagConstraints();
            gbc_jLabel2.insets = new Insets(4, 4, 5, 5);
            gbc_jLabel2.gridx = 2;
            gbc_jLabel2.gridy = 0;
            this.panelPosition.add((Component)this.jLabel2, gbc_jLabel2);
            this.jLabel2.setText("ms.");
            this.jLabel2.setToolTipText("Milliseconds");
            this.jLabel1 = new JLabel();
            GridBagConstraints gbc_jLabel1 = new GridBagConstraints();
            gbc_jLabel1.anchor = 17;
            gbc_jLabel1.insets = new Insets(4, 4, 5, 5);
            gbc_jLabel1.gridx = 0;
            gbc_jLabel1.gridy = 1;
            this.panelPosition.add((Component)this.jLabel1, gbc_jLabel1);
            this.jLabel1.setText("Needle Position:");
            this.jLabel1.setToolTipText("Needle start position in milliseconds");
            GridBagConstraints gbc_jTextFieldStartValue = new GridBagConstraints();
            gbc_jTextFieldStartValue.weightx = 1.0;
            gbc_jTextFieldStartValue.fill = 2;
            gbc_jTextFieldStartValue.insets = new Insets(4, 4, 5, 5);
            gbc_jTextFieldStartValue.gridx = 1;
            gbc_jTextFieldStartValue.gridy = 1;
            this.panelPosition.add((Component)this.getJTextFieldStartValue(), gbc_jTextFieldStartValue);
            this.jLabel21 = new JLabel();
            GridBagConstraints gbc_jLabel21 = new GridBagConstraints();
            gbc_jLabel21.insets = new Insets(4, 4, 5, 5);
            gbc_jLabel21.gridx = 2;
            gbc_jLabel21.gridy = 1;
            this.panelPosition.add((Component)this.jLabel21, gbc_jLabel21);
            this.jLabel21.setText("ms.");
            this.jLabel21.setToolTipText("Milliseconds");
        }
        return this.panelPosition;
    }

    private JLabel getLblScaleFactor() {
        if (this.lblScaleFactor == null) {
            this.lblScaleFactor = new JLabel("Time Scale:");
        }
        return this.lblScaleFactor;
    }

    private JLabel getLblScaleFactor_1() {
        if (this.lblScaleFactor_1 == null) {
            this.lblScaleFactor_1 = new JLabel("Needle Scale:");
        }
        return this.lblScaleFactor_1;
    }

    public WaxEditorItem getItem() {
        return this.item;
    }

    public void setItem(WaxEditorItem item) {
        this.item = item;
        this.refresh();
    }

    private JTextField getTextFieldTimeScale() {
        if (this.textFieldTimeScale == null) {
            this.textFieldTimeScale = new JTextField();
            this.textFieldTimeScale.setColumns(10);
        }
        return this.textFieldTimeScale;
    }

    private JTextField getTextFieldNeedleScale() {
        if (this.textFieldNeedleScale == null) {
            this.textFieldNeedleScale = new JTextField();
            this.textFieldNeedleScale.setColumns(10);
        }
        return this.textFieldNeedleScale;
    }

    private JLabel getLblNewLabel() {
        if (this.lblNewLabel == null) {
            this.lblNewLabel = new JLabel(" % ");
        }
        return this.lblNewLabel;
    }

    private JLabel getLblNewLabel_1() {
        if (this.lblNewLabel_1 == null) {
            this.lblNewLabel_1 = new JLabel(" % ");
        }
        return this.lblNewLabel_1;
    }
}

