/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.Interpolator;
import com.waxmonster.editor.InterpolatorFactory;
import com.waxmonster.editor.InterpolatorProvider;
import com.waxmonster.editor.InterpolatorRegistry;
import com.waxmonster.editor.InterpolatorSettings;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.WaxEditorItem;
import com.waxmonster.editor.WaxEditorModel;
import com.waxmonster.editor.impl.InterpolatedFaderModel;
import com.waxmonster.editor.impl.InterpolatedTimecodeModel;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;

public class WaxEditorUtil {
    private static final WrapperComparator wrapperComparator = new WrapperComparator();

    private WaxEditorUtil() {
    }

    public static InterpolatedTimecodeModel[] createInterpolatedTimecodeModels(float frameRate, WaxEditorModel[] editorModels, int num, InterpolatorRegistry interRegistry) {
        ScratchEditorModel sem;
        WaxEditorItem item;
        WaxEditorModel wem;
        LinkedList<ItemWrapper> wrapperList = new LinkedList<ItemWrapper>();
        for (int m = 0; m < num; ++m) {
            wem = editorModels[m];
            double wemStart = wem.getStartTime();
            int count = wem.getItemCount();
            for (int i = 0; i < count; ++i) {
                item = wem.getItemAt(i);
                sem = item.getModel();
                wrapperList.add(new ItemWrapper(item, wemStart + item.getStartTime()));
            }
        }
        ItemWrapper[] wrappers = wrapperList.toArray(new ItemWrapper[wrapperList.size()]);
        Arrays.sort(wrappers, wrapperComparator);
        LinkedList<InterpolatedTimecodeModel> interModels = new LinkedList<InterpolatedTimecodeModel>();
        InterpolatedTimecodeModel interModel = null;
        String prevInterpolation = null;
        double interEnd = 0.0;
        for (ItemWrapper wrapper : wrappers) {
            InterpolatorProvider interProvider;
            item = wrapper.item;
            sem = item.getModel();
            wem = item.getParent();
            String interName = item.getInterpolation();
            if (interName == null) {
                interName = wem.getDefaultInterpolation();
            }
            if (interName != null) {
                interProvider = interRegistry.getInterpolatorProvider(interName);
                if (interProvider == null) {
                    throw new RuntimeException("Scratch interpolation provider not found: " + interName);
                }
            } else {
                interProvider = interRegistry.getDefaultInterpolatorProvider();
                if (interProvider == null) {
                    throw new RuntimeException("No default scratch interpolation provider available!");
                }
                interName = interProvider.getName();
            }
            if (interModel != null && item.isAutoConnect() && wrapper.startTime >= interEnd && interName.equals(prevInterpolation)) {
                interModel.addWaxEditorItem(item);
                interEnd = wrapper.startTime + sem.getTimeLength();
                continue;
            }
            InterpolatorFactory factory = interProvider.createInterpolatorFactory();
            InterpolatorSettings settings = factory.createDefaultInterpolatorSettings();
            Interpolator inter = factory.createInterpolator(settings);
            interModel = new InterpolatedTimecodeModel(frameRate, inter);
            interModel.setStartTime(wrapper.startTime);
            interModel.addWaxEditorItem(item);
            interEnd = wrapper.startTime + sem.getTimeLength();
            interModels.add(interModel);
            prevInterpolation = interName;
        }
        return interModels.toArray(new InterpolatedTimecodeModel[interModels.size()]);
    }

    public static InterpolatedFaderModel[] createInterpolatedFaderModels(float frameRate, WaxEditorModel[] editorModels, int num, InterpolatorRegistry interRegistry, double fadeInMillis, double fadeOutMillis) {
        WaxEditorItem item;
        LinkedList<ItemWrapper> wrapperList = new LinkedList<ItemWrapper>();
        for (int m = 0; m < num; ++m) {
            WaxEditorModel wem = editorModels[m];
            double wemStart = wem.getStartTime();
            int count = wem.getItemCount();
            for (int i = 0; i < count; ++i) {
                item = wem.getItemAt(i);
                wrapperList.add(new ItemWrapper(item, wemStart + item.getStartTime()));
            }
        }
        ItemWrapper[] wrappers = wrapperList.toArray(new ItemWrapper[wrapperList.size()]);
        Arrays.sort(wrappers, wrapperComparator);
        LinkedList<InterpolatedFaderModel> interModels = new LinkedList<InterpolatedFaderModel>();
        InterpolatedFaderModel interModel = null;
        String prevInterpolation = null;
        double interEnd = 0.0;
        for (ItemWrapper wrapper : wrappers) {
            InterpolatorProvider interProvider;
            item = wrapper.item;
            ScratchEditorModel model = item.getModel();
            WaxEditorModel parent = item.getParent();
            String interName = item.getInterpolation();
            if (interName == null) {
                interName = parent.getDefaultInterpolation();
            }
            if (interName != null) {
                interProvider = interRegistry.getInterpolatorProvider(interName);
                if (interProvider == null) {
                    throw new RuntimeException("Scratch interpolation provider not found: " + interName);
                }
            } else {
                interProvider = interRegistry.getDefaultInterpolatorProvider();
                if (interProvider == null) {
                    throw new RuntimeException("No default scratch interpolation provider available!");
                }
                interName = interProvider.getName();
            }
            if (interModel != null && item.isAutoConnect() && wrapper.startTime >= interEnd && interName.equals(prevInterpolation)) {
                interModel.addWaxEditorItem(item);
                interEnd = wrapper.startTime + model.getTimeLength();
                continue;
            }
            interModel = new InterpolatedFaderModel(frameRate);
            interModel.setStartTime(wrapper.startTime);
            interModel.setStartValue(0.0f);
            interModel.setFadeInValue(1.0f);
            interModel.setFadeOutValue(0.0f);
            interModel.setFadeInMillis(fadeInMillis);
            interModel.setFadeOutMillis(fadeOutMillis);
            interModel.addWaxEditorItem(item);
            interEnd = wrapper.startTime + model.getTimeLength();
            interModels.add(interModel);
            prevInterpolation = interName;
        }
        return interModels.toArray(new InterpolatedFaderModel[interModels.size()]);
    }

    protected static class WrapperComparator
    implements Comparator {
        protected WrapperComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            ItemWrapper a = (ItemWrapper)arg0;
            ItemWrapper b = (ItemWrapper)arg1;
            return a.startTime < b.startTime ? -1 : 1;
        }
    }

    protected static class ItemWrapper {
        final WaxEditorItem item;
        final double startTime;

        public ItemWrapper(WaxEditorItem item, double startTime) {
            this.item = item;
            this.startTime = startTime;
        }
    }
}

