/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.FaderModelAnalyzer;
import com.waxmonster.editor.Interpolator;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.impl.DefaultFaderMove;
import com.waxmonster.editor.impl.DefaultScratchEditorModel;
import com.waxmonster.editor.impl.LinearInterpolator;
import com.waxmonster.model.FaderModel;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxMonsterFaderModelAnalyzer
implements FaderModelAnalyzer {
    private static final Logger logger = Logger.getLogger(WaxMonsterFaderModelAnalyzer.class.getName());
    private final FaderModel model;
    private final int maxPoints;
    private final double maxErrorRate;
    private volatile double peakError;
    private volatile double maxPeakError;
    private volatile boolean cancel;
    private int size;
    private double[] x;
    private double[] y;
    private int addCount;
    private double[] nx;
    private double[] ny;

    public WaxMonsterFaderModelAnalyzer(FaderModel model, int maxPoints, double maxErrorRate) {
        if (maxErrorRate <= 0.0) {
            throw new IllegalArgumentException("Invalid maximum error rate: " + maxErrorRate);
        }
        if (maxPoints < 2) {
            throw new IllegalArgumentException("Invalid maximum points: " + maxPoints);
        }
        this.model = model;
        this.maxPoints = maxPoints;
        this.maxErrorRate = maxErrorRate;
        this.peakError = Double.MAX_VALUE;
        this.maxPeakError = -1.0;
        this.cancel = false;
        this.size = 0;
        int initCapacity = 1000;
        this.x = new double[initCapacity];
        this.y = new double[initCapacity];
        this.nx = new double[initCapacity];
        this.ny = new double[initCapacity];
        this.addCount = 0;
    }

    public synchronized ScratchEditorModel analyzeFaderModel() throws IOException {
        long peakErrPos;
        int np;
        int i;
        long p;
        int n;
        float frameRate = this.model.getFrameRate();
        long frames = this.model.getFrameLength();
        if (frames < 1L) {
            return new DefaultScratchEditorModel();
        }
        int bufSize = (int)frameRate;
        double[] b = new double[bufSize];
        double millisPerFrame = 1000.0 / (double)frameRate;
        LinearInterpolator inter = new LinearInterpolator();
        this.model.get(0L, b, 0, 1);
        this.add(0.0, b[0]);
        if (frames < 2L) {
            return new DefaultScratchEditorModel();
        }
        double mPeak = 0.0;
        long mPeakOfs = -1L;
        boolean increasing = true;
        long lastPointOfs = Long.MIN_VALUE;
        long minPeakPointDist = (long)(10.0 / millisPerFrame);
        for (p = 1L; p < frames && !this.cancel; p += (long)n) {
            n = (int)Math.min((long)bufSize, frames - p);
            this.model.get(p, b, 0, n);
            for (i = 0; i < n; ++i) {
                double m = b[i];
                if (m > mPeak) {
                    if (!increasing) {
                        if (mPeakOfs >= 0L && mPeakOfs > lastPointOfs + minPeakPointDist) {
                            this.add((double)mPeakOfs * millisPerFrame, mPeak);
                            lastPointOfs = mPeakOfs;
                        }
                        increasing = true;
                    }
                    mPeak = m;
                    mPeakOfs = p + (long)i;
                    continue;
                }
                if (!(m < mPeak)) continue;
                if (increasing) {
                    if (mPeakOfs >= 0L && mPeakOfs > lastPointOfs + minPeakPointDist) {
                        this.add((double)mPeakOfs * millisPerFrame, mPeak);
                        lastPointOfs = mPeakOfs;
                    }
                    increasing = false;
                }
                mPeak = m;
                mPeakOfs = p + (long)i;
            }
        }
        this.model.get(frames - 1L, b, 0, 1);
        this.add((double)(frames - 1L) * millisPerFrame, b[0]);
        this.apply();
        int peakPoints = np = this.size;
        int maxPnts = this.maxPoints;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Fader peak points: " + peakPoints);
        }
        double maxErr = this.maxErrorRate;
        long minPeakErrorDist = (long)(1000.0 / millisPerFrame);
        double[] s = new double[bufSize];
        double prevPeakErr = Double.MAX_VALUE;
        long prevPeakErrPos = -1L;
        double peakErr = -1.0;
        while (true) {
            inter.update(this.x, this.y, this.size);
            peakErr = 0.0;
            peakErrPos = -1L;
            double peakErrVal = 0.0;
            for (p = 0L; p < frames && !this.cancel; p += (long)n) {
                n = (int)Math.min((long)bufSize, frames - p);
                this.model.get(p, b, 0, n);
                inter.interpolate((double)p * millisPerFrame, millisPerFrame, s, 0, n);
                for (i = 0; i < n; ++i) {
                    double err = Math.abs(b[i] - s[i]);
                    if (!(err > peakErr)) continue;
                    if (peakErrPos + minPeakErrorDist < p + (long)i && peakErr > maxErr && peakErrPos > 0L && np < maxPnts) {
                        this.add((double)peakErrPos * millisPerFrame, peakErrVal);
                        ++np;
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("errorPoint: pos=" + peakErrPos + ", peakErr=" + peakErr + ", value=" + peakErrVal);
                        }
                    }
                    peakErr = err;
                    peakErrPos = p + (long)i;
                    peakErrVal = b[i];
                }
            }
            if (peakErr < this.peakError) {
                this.peakError = peakErr;
            } else if (peakErr > this.maxPeakError) {
                this.maxPeakError = peakErr;
            }
            if (!(peakErr > maxErr) || peakErrPos <= 0L || peakErrPos == prevPeakErrPos || np >= maxPnts || this.cancel) break;
            this.add((double)peakErrPos * millisPerFrame, peakErrVal);
            ++np;
            this.apply();
            prevPeakErr = peakErr;
            prevPeakErrPos = peakErrPos;
            if (!logger.isLoggable(Level.FINER)) continue;
            logger.finer("peakError: pos=" + peakErrPos + ", peakErr=" + peakErr + ", value=" + peakErrVal);
        }
        np = this.size;
        if (this.cancel) {
            logger.info("Operation cancelled.");
        }
        if (peakErrPos == prevPeakErrPos && (double)peakErrPos >= 0.0) {
            logger.warning("Same peak error position: " + peakErrPos);
        }
        if (logger.isLoggable(Level.FINE)) {
            if (!this.cancel) {
                logger.fine("Done: totalPoints=" + np + ", peakPoints=" + peakPoints + ", errorPoints=" + (np - peakPoints) + ", peakErr=" + peakErr + ", maxErr=" + maxErr + ", prevErr=" + prevPeakErr);
            } else {
                logger.fine("Done: totalPoints=" + np + ", peakPoints=" + peakPoints + ", errorPoints=" + (np - peakPoints) + ", peakErr=" + prevPeakErr);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            double overallErrorRate = this.computeModelErrorRate(inter, this.model);
            logger.fine("Fader model error rate: " + (double)Math.round(overallErrorRate * 10000.0) / 10000.0);
            if (overallErrorRate > maxErr) {
                logger.warning("Unexpected model error rate: " + overallErrorRate + " > " + maxErr);
            }
        }
        int num = this.size;
        DefaultScratchEditorModel sem = new DefaultScratchEditorModel(64, num);
        if (num > 0) {
            double po = 1.0E-5;
            float pv = -1.0f;
            for (i = 0; i < num; ++i) {
                double ofs = this.x[i];
                if (ofs <= po) continue;
                float val = (float)this.y[i];
                if (val == pv) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.finer("Fader hold: pos=" + po + ", len=" + (ofs - po) + ", value=" + pv);
                    }
                    po = ofs;
                    continue;
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Fader move: pos=" + po + ", len=" + (ofs - po) + ", value=" + pv + " -> " + val);
                }
                DefaultFaderMove fm = new DefaultFaderMove(ofs - po, val);
                sem.putFaderMove(po, fm);
                po = ofs;
                pv = val;
            }
        }
        return sem;
    }

    public void cancel() {
        this.cancel = true;
    }

    public double getProgress() {
        double elapsed = this.maxPeakError - this.peakError;
        if (elapsed <= 0.0) {
            return 0.0;
        }
        double range = this.maxPeakError - this.maxErrorRate;
        if (range <= 0.0) {
            return 1.0;
        }
        double p = elapsed / range;
        p = p <= 0.0 ? 0.0 : (p >= 1.0 ? 1.0 : Math.pow(p, 512.0));
        return p;
    }

    public FaderModel getFaderModel() {
        return this.model;
    }

    public double getMaxErrorRate() {
        return this.maxErrorRate;
    }

    public int getMaxPointCount() {
        return this.maxPoints;
    }

    public double getPeakError() {
        return this.peakError;
    }

    protected void add(double o, double v) {
        if (this.addCount >= this.nx.length) {
            double[] newX = new double[this.addCount * 2];
            System.arraycopy(this.nx, 0, newX, 0, this.addCount);
            this.nx = newX;
            double[] newY = new double[this.addCount * 2];
            System.arraycopy(this.ny, 0, newY, 0, this.addCount);
            this.ny = newY;
        }
        this.nx[this.addCount] = o;
        this.ny[this.addCount] = v;
        ++this.addCount;
    }

    protected void apply() {
        int i;
        if (this.addCount < 1) {
            return;
        }
        int newCount = this.size + this.addCount;
        double[] newX = new double[newCount];
        double[] newY = new double[newCount];
        int o = 0;
        int no = 0;
        for (i = 0; i < newCount; ++i) {
            if (o < this.size && (no >= this.addCount || this.x[o] < this.nx[no])) {
                newX[i] = this.x[o];
                newY[i] = this.y[o];
                ++o;
                continue;
            }
            newX[i] = this.nx[no];
            newY[i] = this.ny[no];
            ++no;
        }
        if (i != newCount) {
            throw new RuntimeException("Unexpected number of points: " + i + " != " + newCount);
        }
        this.x = newX;
        this.y = newY;
        this.size = newCount;
        this.addCount = 0;
    }

    protected double computeModelErrorRate(Interpolator inter, FaderModel expected) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("computeModelErrorRate: inter=" + inter + ", expected=" + expected);
        }
        int np = this.size;
        double[] x = new double[np + 1];
        double[] y = new double[np + 1];
        System.arraycopy(this.x, 0, x, 1, np);
        System.arraycopy(this.y, 0, y, 1, np);
        x[0] = 0.0;
        y[0] = 0.0;
        inter.update(x, y, np);
        float frameRate = expected.getFrameRate();
        long frames = (long)(x[np] * (double)frameRate / 1000.0);
        long expectedFrames = expected.getFrameLength();
        if (frames > expectedFrames) {
            frames = expectedFrames;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("comparing frames: " + frames + " of " + expectedFrames);
        }
        int bufSize = (int)frameRate;
        double[] b1 = new double[bufSize];
        double[] b2 = new double[bufSize];
        int p = 0;
        double mu = 1000.0 / (double)frameRate;
        double err = 0.0;
        while ((long)p < frames) {
            int n = (int)Math.min((long)bufSize, frames - (long)p);
            expected.get((long)p, b1, 0, n);
            inter.interpolate((double)p * mu, mu, b2, 0, n);
            for (int i = 0; i < n; ++i) {
                err += Math.abs(b2[i] - b1[i]);
            }
            p += n;
        }
        double errorRate = err / (double)frames;
        return errorRate;
    }
}

