/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.editor.impl;

import com.waxmonster.editor.FaderClick;
import com.waxmonster.editor.FaderMove;
import com.waxmonster.editor.FaderMoveInterpreter;
import com.waxmonster.editor.ScratchEditorModel;
import com.waxmonster.editor.impl.DefaultFaderClick;
import com.waxmonster.editor.impl.DefaultFaderMove;
import com.waxmonster.editor.impl.DefaultScratchEditorModel;
import com.waxmonster.editor.impl.WaxMonsterFaderMoveInterpreterConfig;
import com.waxmonster.fader.FaderCurve;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WaxMonsterFaderMoveInterpreter
implements FaderMoveInterpreter {
    private static final Logger logger = Logger.getLogger(WaxMonsterFaderMoveInterpreter.class.getName());
    private final ScratchEditorModel model;
    private final FaderCurve curve;
    private final WaxMonsterFaderMoveInterpreterConfig config;
    private volatile double progress;
    private int faderMoveReduceCount = 0;
    private int faderOffClickCount = 0;
    private int faderOnClickCount = 0;

    public WaxMonsterFaderMoveInterpreter(ScratchEditorModel model, FaderCurve curve, WaxMonsterFaderMoveInterpreterConfig config) {
        this.model = model;
        this.curve = curve;
        this.config = config;
    }

    public void cancel() {
    }

    public double getProgress() {
        return this.progress;
    }

    private float volume(float v) {
        return this.curve == null ? v : this.curve.getVolume(v);
    }

    public static void dumpFaderMoves(FaderMove[] moves, double[] offs, int idx, int num, StringBuffer sb) {
        for (int i = 0; i < num; ++i) {
            FaderMove move = moves[idx];
            double ofs = offs[idx];
            sb.append("\n - ");
            if (move instanceof DefaultFaderMove) {
                sb.append("move: ofs=" + ofs + ", len=" + move.getTimeLength() + ", targetValue=" + move.getTargetValue());
            } else if (move instanceof DefaultFaderClick) {
                sb.append("click: ofs=" + ofs + ", len=" + move.getTimeLength() + ", targetValue=" + move.getTargetValue());
            } else {
                sb.append(move.toString());
                sb.append(": ofs=" + ofs + ", len=" + move.getTimeLength() + ", targetValue=" + move.getTargetValue());
            }
            ++idx;
        }
    }

    public synchronized ScratchEditorModel interpretFaderMoves() throws IOException {
        this.progress = 0.0;
        int moveCount = this.model.getFaderMoveCount();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("interpretFaderMoves: count=" + moveCount + ", model=" + this.model + ", curve=" + this.curve);
        }
        FaderMove[] moves = new FaderMove[moveCount];
        double[] offs = new double[moveCount];
        double prevOfs = Double.MIN_VALUE;
        for (int i = 0; i < moveCount; ++i) {
            moves[i] = this.model.getFaderMoveAt(i);
            offs[i] = this.model.getFaderMoveOffsetAt(i);
            if (offs[i] < prevOfs) {
                logger.warning("Invalid fader move offset: index=" + i + ", ofs=" + offs[i] + " < " + prevOfs);
            }
            prevOfs = offs[i];
        }
        this.progress = 0.01;
        moveCount = this.interpretFaderMoves(moves, offs, moveCount);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("interpretFaderMoves: Number of interpreted fader moves: " + moveCount);
        }
        this.progress = 0.99;
        DefaultScratchEditorModel sem = new DefaultScratchEditorModel(64, moveCount);
        for (int i = 0; i < moveCount; ++i) {
            sem.putFaderMove(offs[i], moves[i]);
        }
        this.progress = 1.0;
        return sem;
    }

    protected int interpretFaderMoves(FaderMove[] moves, double[] offs, int moveCount) {
        int oldCount = moveCount;
        if (this.config.isSimplifyFaderMoves() && moveCount > 1) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Simplifying fader moves: " + moveCount);
            }
            moveCount = this.simplifyFaderMoves(moves, offs, moveCount);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Number of fader moves simplified: " + this.faderMoveReduceCount);
            }
        }
        this.progress = 0.5;
        if (this.config.isInterpretFaderClicks() && moveCount > 1) {
            boolean detectFaderOnClicks = this.config.isDetectFaderOnClicks();
            boolean detectFaderOffClicks = this.config.isDetectFaderOffClicks();
            boolean detectFaderOffClicksFirst = this.config.isDetectFaderOffClicksFirst();
            if (detectFaderOnClicks && !detectFaderOffClicksFirst) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Detecting fader on-clicks: moves=" + moveCount);
                }
                moveCount = this.detectFaderClicks(moves, offs, moveCount, false, true);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Number of fader on-clicks detected: " + this.faderOnClickCount);
                }
            }
            if (detectFaderOffClicks) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Detecting fader off-clicks: moves=" + moveCount);
                }
                moveCount = this.detectFaderClicks(moves, offs, moveCount, true, false);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Number of fader off-clicks detected: " + this.faderOffClickCount);
                }
            }
            if (detectFaderOnClicks && detectFaderOffClicksFirst) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Detecting fader on-clicks: moves=" + moveCount);
                }
                moveCount = this.detectFaderClicks(moves, offs, moveCount, false, true);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Number of fader on-clicks detected: " + this.faderOnClickCount);
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Number of fader moves interpreted: old=" + oldCount + ", reduced=" + this.faderMoveReduceCount + ", new=" + moveCount);
        }
        return moveCount;
    }

    protected int simplifyFaderMoves(FaderMove[] moves, double[] offs, int moveCount) {
        double simplifyTolerance = this.config.getSimplifyTolerance();
        FaderMove prevMove = moves[0];
        double prevOfs = offs[0];
        double prevLen = prevMove.getTimeLength();
        float prevVol = this.volume(prevMove.getTargetValue());
        double prevInc = (double)prevVol / prevLen;
        int reduceCount = 0;
        for (int i = 1; i < moveCount; ++i) {
            FaderMove move = moves[i];
            double ofs = offs[i];
            double len = move.getTimeLength();
            float val = move.getTargetValue();
            float vol = this.volume(val);
            double volInc = (double)(vol - prevVol) / len;
            if (ofs == prevOfs + prevLen && move instanceof DefaultFaderMove && prevMove instanceof DefaultFaderMove && (volInc >= 0.0 && prevInc >= 0.0 || volInc < 0.0 && prevInc < 0.0) && Math.abs(volInc - prevInc) <= simplifyTolerance) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("interpretFaderMoves: Combine fader moves: ofs=" + prevOfs + ", millis=" + (prevLen + len) + ", volume=" + prevVol + " -> " + vol + ", change=" + Math.abs(volInc - prevInc));
                }
                ++reduceCount;
                if (i + 1 < moveCount) {
                    System.arraycopy(moves, i + 1, moves, i, moveCount - i - 1);
                    System.arraycopy(offs, i + 1, offs, i, moveCount - i - 1);
                }
                --moveCount;
                DefaultFaderMove pm = (DefaultFaderMove)prevMove;
                move = pm;
                ofs = prevOfs;
                len = prevLen + len;
                pm.setTimeLength(len);
                pm.setTargetValue(val);
                volInc = (volInc + prevInc) / 2.0;
            }
            prevMove = move;
            prevOfs = ofs;
            prevLen = len;
            prevVol = vol;
            prevInc = volInc;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("simplifyFaderMoves: Number of fader moves reduced: " + reduceCount);
        }
        this.faderMoveReduceCount += reduceCount;
        return moveCount;
    }

    protected int detectFaderClicks(FaderMove[] moves, double[] offs, int moveCount, boolean offClicks, boolean onClicks) {
        double maxFaderClickMillis = this.config.getMaxFaderClickMillis();
        FaderMove prevMove = moves[0];
        double prevOfs = offs[0];
        double prevLen = prevMove.getTimeLength();
        float prevVol = this.volume(prevMove.getTargetValue());
        double prevInc = (double)prevVol / prevLen;
        int[] newClickIndex = new int[1];
        int[] newMoveCount = new int[1];
        int offClickCount = 0;
        int onClickCount = 0;
        for (int i = 1; i < moveCount; ++i) {
            FaderMove move = moves[i];
            if (move == null) continue;
            double ofs = offs[i];
            double len = move.getTimeLength();
            float val = move.getTargetValue();
            float vol = this.volume(val);
            double volInc = (double)(vol - prevVol) / len;
            if (move instanceof DefaultFaderMove && ofs - prevOfs + len < maxFaderClickMillis) {
                FaderClick click;
                boolean onClick = false;
                boolean offClick = false;
                if (offClicks) {
                    boolean bl = offClick = prevInc <= 0.0 && volInc > 0.0;
                }
                if (onClicks && !offClick) {
                    boolean bl = onClick = prevInc >= 0.0 && volInc < 0.0;
                }
                if ((offClick || onClick) && (click = this.detectFaderClick(moves, offs, moveCount, i - 1, offClick, newClickIndex, newMoveCount)) != null) {
                    if (offClick) {
                        ++offClickCount;
                    } else {
                        ++onClickCount;
                    }
                    i = newClickIndex[0];
                    moveCount = newMoveCount[0];
                    prevMove = moves[i];
                    prevOfs = offs[i];
                    prevLen = prevMove.getTimeLength();
                    prevVol = prevMove.getTargetValue();
                    prevInc = (double)(click.getTargetValue() - click.getPeakValue()) / click.getReleaseDuration();
                    continue;
                }
            }
            prevMove = move;
            prevOfs = ofs;
            prevLen = len;
            prevVol = vol;
            prevInc = volInc;
        }
        this.faderOffClickCount += offClickCount;
        this.faderOnClickCount += onClickCount;
        return moveCount;
    }

    protected FaderClick detectFaderClick(FaderMove[] moves, double[] offs, int moveCount, int peakIndex, boolean offClick, int[] newClickIndex, int[] newMoveCount) {
        FaderMove nextMove;
        double len;
        double ofs;
        float val;
        float vol;
        FaderMove prevMove;
        int prevIndex = peakIndex - 1;
        if (prevIndex < 0) {
            return null;
        }
        int nextIndex = peakIndex + 1;
        if (nextIndex >= moveCount) {
            return null;
        }
        FaderMove peakMove = moves[peakIndex];
        if (!(peakMove instanceof DefaultFaderMove)) {
            return null;
        }
        double peakMoveOfs = offs[peakIndex];
        double peakMoveLen = peakMove.getTimeLength();
        float peakValue = peakMove.getTargetValue();
        float peakVolume = this.volume(peakValue);
        double peakEndOfs = offs[nextIndex];
        double peakStartOfs = peakMoveOfs + peakMoveLen;
        double maxFaderPeakMillis = this.config.getMaxFaderPeakMillis();
        if (peakEndOfs - peakStartOfs > maxFaderPeakMillis) {
            return null;
        }
        while (prevIndex >= 0 && (prevMove = moves[prevIndex]) instanceof DefaultFaderMove && (vol = this.volume(val = prevMove.getTargetValue())) == peakVolume) {
            peakStartOfs = offs[prevIndex] + prevMove.getTimeLength();
            if (peakEndOfs - peakStartOfs > maxFaderPeakMillis) {
                return null;
            }
            --prevIndex;
        }
        double peakDuration = peakEndOfs - peakStartOfs;
        double attackOffset = peakStartOfs;
        float initValue = peakValue;
        double maxFaderAttackMillis = this.config.getMaxFaderAttackMillis();
        while (prevIndex >= 0) {
            prevMove = moves[prevIndex];
            ofs = offs[prevIndex];
            if (peakStartOfs - ofs > maxFaderAttackMillis) break;
            val = prevMove.getTargetValue();
            if (!(prevMove instanceof DefaultFaderMove) || (offClick ? val < initValue : val > initValue)) break;
            attackOffset = ofs;
            initValue = val;
            --prevIndex;
        }
        double releaseOffset = peakEndOfs;
        float targetValue = peakValue;
        double maxFaderReleaseMillis = this.config.getMaxFaderReleaseMillis();
        while (nextIndex < moveCount && !((ofs = offs[nextIndex]) + (len = (nextMove = moves[nextIndex]).getTimeLength()) - peakEndOfs > maxFaderReleaseMillis)) {
            val = nextMove.getTargetValue();
            if (!(nextMove instanceof DefaultFaderMove) || (offClick ? val < targetValue : val > targetValue)) break;
            releaseOffset = ofs + len;
            targetValue = val;
            ++nextIndex;
        }
        double attackDuration = peakStartOfs - attackOffset;
        double releaseDuration = releaseOffset - peakEndOfs;
        double totalDuration = attackDuration + peakDuration + releaseDuration;
        int idx = prevIndex + 1;
        int num = nextIndex - idx;
        boolean accept = true;
        if (attackDuration < this.config.getMinFaderAttackMillis() && releaseDuration < this.config.getMinFaderReleaseMillis()) {
            accept = false;
        }
        if (accept && totalDuration < this.config.getMinFaderClickMillis()) {
            accept = false;
        }
        if (accept && totalDuration > this.config.getMaxFaderClickMillis()) {
            accept = false;
        }
        if (!accept) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Ignored possible fader click: ofs=" + attackOffset + ", len=" + totalDuration + ", attackDuration=" + attackDuration + ", peakDuration=" + peakDuration + ", releaseDuration=" + releaseDuration + ", initValue=" + initValue + ", peakValue=" + peakValue + ", targetValue=" + targetValue + ", num=" + num);
                StringBuffer sb = new StringBuffer();
                sb.append("Click moves: " + num);
                WaxMonsterFaderMoveInterpreter.dumpFaderMoves(moves, offs, idx, num, sb);
                logger.log(Level.FINER, sb.toString());
            }
            return null;
        }
        DefaultFaderClick click = new DefaultFaderClick(totalDuration, attackDuration, releaseDuration, peakValue, targetValue);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Detected fader click: ofs=" + attackOffset + ", len=" + totalDuration + ", attackDuration=" + attackDuration + ", peakDuration=" + peakDuration + ", releaseDuration=" + releaseDuration + ", initValue=" + initValue + ", peakValue=" + peakValue + ", targetValue=" + targetValue + ", num=" + num);
            if (logger.isLoggable(Level.FINEST)) {
                StringBuffer sb = new StringBuffer();
                sb.append("Click moves: " + num);
                WaxMonsterFaderMoveInterpreter.dumpFaderMoves(moves, offs, idx, num, sb);
                logger.log(Level.FINEST, sb.toString());
            }
        }
        moves[idx] = click;
        offs[idx] = attackOffset;
        if (nextIndex < moveCount && num > 1) {
            System.arraycopy(moves, nextIndex, moves, idx + 1, moveCount - nextIndex);
            System.arraycopy(offs, nextIndex, offs, idx + 1, moveCount - nextIndex);
        }
        this.faderMoveReduceCount += num - 1;
        newClickIndex[0] = idx;
        newMoveCount[0] = moveCount + 1 - num;
        return click;
    }
}

