/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.midi;

import com.waxmonster.fader.Fader;
import com.waxmonster.fader.FaderConfig;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.FaderDecoder;
import com.waxmonster.fader.VolumeShader;
import com.waxmonster.fader.impl.AbstractFaderConfig;
import com.waxmonster.fader.impl.FaderCurveUtil;
import com.waxmonster.fader.midi.MidiFaderConfig;
import com.waxmonster.midi.MidiMapping;

public abstract class AbstractMidiFaderDecoder
implements FaderDecoder {
    protected static final int MIDI_CONTROLS = 128;
    protected static final FaderImpl[] NO_FADER_IMPLS = new FaderImpl[0];
    protected static final Fader[] NO_FADERS = new Fader[0];
    protected static final VolumeShader[] NO_SHADERS = new VolumeShader[0];
    protected FaderConfig[] faderConfigs;
    protected VolumeShader[] volumeShaders = NO_SHADERS;
    protected FaderImpl[] faders = NO_FADER_IMPLS;
    protected Fadeable[][] matrix = new Fadeable[16][];
    protected int channelCount;

    public synchronized FaderConfig[] getFaderConfigArray() {
        return this.faderConfigs;
    }

    public synchronized void setFaderConfigArray(FaderConfig[] array) {
        this.faderConfigs = array;
        this.updateFaderMatrix();
        this.linkFadersWithShaders();
        this.linkShadersWithFaders();
    }

    public synchronized VolumeShader[] getVolumeShaderArray() {
        return this.volumeShaders;
    }

    public synchronized void setVolumeShaderArray(VolumeShader[] array) {
        this.volumeShaders = array;
        this.linkFadersWithShaders();
        this.linkShadersWithFaders();
    }

    public synchronized int getChannelCount() {
        return this.channelCount;
    }

    public synchronized void setChannelCount(int channelCount) {
        if (this.channelCount == channelCount) {
            return;
        }
        this.channelCount = channelCount;
        this.linkFadersWithShaders();
        this.linkShadersWithFaders();
    }

    protected void updateFaderMatrix() {
        FaderImpl fader;
        FaderConfig[] configs = this.getFaderConfigArray();
        int num = configs.length;
        FaderImpl[] arr = new FaderImpl[num];
        int idx = 0;
        for (int i = 0; i < num; ++i) {
            float initPos;
            FaderCurve curve;
            int command;
            int control;
            int channel;
            MidiMapping mapping;
            FaderConfig fc = configs[i];
            MidiFaderConfig config = null;
            if (fc != null && fc instanceof MidiFaderConfig) {
                config = (MidiFaderConfig)fc;
            }
            if (config == null || !config.isFaderEnabled() || (mapping = config.getMidiMapping()) == null || (channel = mapping.getChannel()) < 0 || channel >= 16 || (control = mapping.getIndex()) < 0 || control >= 128 || (command = mapping.getCommand()) != 176 || (curve = config.getFaderCurve()) == null) continue;
            boolean reverse = config.isReverseMode();
            switch (config.getFaderType()) {
                case 1: {
                    reverse = !reverse;
                    break;
                }
                case 3: {
                    boolean bl = reverse = !reverse;
                }
            }
            if (reverse) {
                curve = FaderCurveUtil.getReversedFaderCurve((FaderCurve)curve);
            }
            if ((initPos = config.getInitValue()) < 0.0f) {
                initPos = 0.0f;
            } else if (initPos > 1.0f) {
                initPos = 1.0f;
            }
            int mask = config.getChannelMask();
            fader = null;
            Object runtimeId = null;
            if (config instanceof AbstractFaderConfig) {
                AbstractFaderConfig afc = (AbstractFaderConfig)config;
                runtimeId = afc.getRuntimeId();
                fader = this.getFader(runtimeId);
            }
            if (fader == null) {
                fader = new FaderImpl(runtimeId, channel, control, initPos, curve, mask);
            } else {
                fader.channel = channel;
                fader.control = control;
                fader.curve = curve;
                fader.mask = mask;
                if (fader.pos == fader.initPos) {
                    fader.move(initPos);
                }
                fader.initPos = initPos;
            }
            arr[idx++] = fader;
        }
        if (idx < num) {
            FaderImpl[] arr2 = new FaderImpl[idx];
            System.arraycopy(arr, 0, arr2, 0, idx);
            arr = arr2;
        }
        num = idx;
        Fadeable[][] matrix = new Fadeable[16][];
        for (int i = 0; i < num; ++i) {
            fader = arr[i];
            Fadeable[] fa = matrix[fader.channel];
            if (fa == null) {
                matrix[fader.channel] = fa = new Fadeable[128];
            }
            fa[fader.control] = this.appendFader(fa[fader.control], fader);
        }
        this.faders = arr;
        this.matrix = matrix;
    }

    protected FaderImpl getFader(Object runtimeId) {
        if (runtimeId == null) {
            return null;
        }
        for (FaderImpl fader : this.faders) {
            if (fader.runtimeId != runtimeId) continue;
            return fader;
        }
        return null;
    }

    protected Fadeable appendFader(Fadeable f, FaderImpl fader) {
        if (f == null) {
            return fader;
        }
        if (f instanceof MultiFader) {
            MultiFader multi = (MultiFader)f;
            FaderImpl[] old = multi.faders;
            int num = old.length;
            FaderImpl[] arr = new FaderImpl[num + 1];
            System.arraycopy(old, 0, arr, 0, num);
            arr[num] = fader;
            multi.faders = arr;
            multi.shaders = null;
            return multi;
        }
        if (f instanceof FaderImpl) {
            return new MultiFader(new FaderImpl[]{(FaderImpl)f, fader});
        }
        return null;
    }

    protected VolumeShader[] getVolumeShaders(int faderMask, VolumeShader[] temp) {
        int shaderCount = this.volumeShaders.length;
        int num = 0;
        for (int k = 0; k < shaderCount; ++k) {
            VolumeShader shader = this.volumeShaders[k];
            int mask = faderMask | shader.getChannelMask();
            if (Fader.areAllChannelsMasked((int)mask, (int)this.channelCount)) continue;
            temp[num++] = shader;
        }
        if (num == shaderCount) {
            return this.volumeShaders;
        }
        VolumeShader[] arr = new VolumeShader[num];
        System.arraycopy(temp, 0, arr, 0, num);
        return arr;
    }

    protected void linkFadersWithShaders() {
        int faderMask;
        FaderImpl fader;
        int i;
        int shaderCount = this.volumeShaders == null ? 0 : this.volumeShaders.length;
        int faderCount = this.faders == null ? 0 : this.faders.length;
        VolumeShader[] temp = new VolumeShader[shaderCount];
        for (i = 0; i < faderCount; ++i) {
            fader = this.faders[i];
            faderMask = fader.mask;
            fader.shaders = this.getVolumeShaders(faderMask, temp);
        }
        for (i = 0; i < faderCount; ++i) {
            Fadeable fade;
            fader = this.faders[i];
            Fadeable[] fa = this.matrix[fader.channel];
            if (fa == null || (fade = fa[fader.control]) == null || !(fade instanceof MultiFader)) continue;
            MultiFader multi = (MultiFader)fade;
            faderMask = this.combineChannelMask(multi.faders);
            multi.shaders = this.getVolumeShaders(faderMask, temp);
        }
    }

    protected int combineChannelMask(FaderImpl[] faders) {
        int combinedMask = -1;
        int num = faders.length;
        for (int i = 0; i < num; ++i) {
            int faderMask = faders[i].mask;
            combinedMask &= faderMask;
        }
        return combinedMask;
    }

    protected void linkShadersWithFaders() {
        int shaderCount = this.volumeShaders == null ? 0 : this.volumeShaders.length;
        int faderCount = this.faders == null ? 0 : this.faders.length;
        Fader[] tempFaders = new Fader[faderCount];
        for (int i = 0; i < shaderCount; ++i) {
            Fader[] volFaders;
            VolumeShader shader = this.volumeShaders[i];
            if (shader == null) continue;
            int shaderMask = shader.getChannelMask();
            int num = 0;
            for (int k = 0; k < faderCount; ++k) {
                FaderImpl fader = this.faders[k];
                int mask = fader.mask | shaderMask;
                if (Fader.areAllChannelsMasked((int)mask, (int)this.channelCount)) continue;
                tempFaders[num++] = fader;
            }
            if (num > 0) {
                volFaders = new Fader[num];
                System.arraycopy(tempFaders, 0, volFaders, 0, num);
            } else {
                volFaders = NO_FADERS;
            }
            shader.setFaders(volFaders);
        }
    }

    protected void resetFaderValues() {
        FaderImpl[] faders = this.faders;
        int faderCount = faders.length;
        for (int i = 0; i < faderCount; ++i) {
            faders[i].val = -1;
        }
    }

    protected static class MultiFader
    implements Fadeable {
        protected FaderImpl[] faders;
        protected VolumeShader[] shaders;

        public MultiFader(FaderImpl[] faders) {
            this.faders = faders;
            this.shaders = null;
        }

        @Override
        public VolumeShader[] getShaders() {
            return this.shaders;
        }

        @Override
        public boolean move(int v) {
            boolean moved = false;
            int n = this.faders.length;
            for (int i = 0; i < n; ++i) {
                if (!this.faders[i].move(v)) continue;
                moved = true;
            }
            return moved;
        }

        @Override
        public boolean move(float p) {
            boolean moved = false;
            int n = this.faders.length;
            for (int i = 0; i < n; ++i) {
                if (!this.faders[i].move(p)) continue;
                moved = true;
            }
            return moved;
        }
    }

    protected static class FaderImpl
    extends Fader
    implements Fadeable {
        protected Object runtimeId;
        protected int channel;
        protected int control;
        protected float initPos;
        protected FaderCurve curve;
        protected int val;
        protected float pos;
        protected VolumeShader[] shaders;

        public FaderImpl(Object runtimeId, int channel, int control, float initPos, FaderCurve curve, int mask) {
            this.runtimeId = runtimeId;
            this.channel = channel;
            this.control = control;
            this.initPos = initPos;
            this.curve = curve;
            this.mask = mask;
            this.shaders = NO_SHADERS;
            this.move(initPos);
        }

        public double getInitVolume() {
            return this.curve.getVolume(this.initPos);
        }

        @Override
        public VolumeShader[] getShaders() {
            return this.shaders;
        }

        @Override
        public boolean move(int v) {
            if ((v &= 0x7F) != this.val) {
                if (this.val < 0) {
                    this.volume = -1.0;
                }
                this.val = v;
                this.pos = (float)v / 127.0f;
                float f = this.curve.getVolume(this.pos);
                if ((double)f != this.volume) {
                    this.volume = f;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean move(float p) {
            if (p < 0.0f) {
                p = 0.0f;
            } else if (p > 1.0f) {
                p = 1.0f;
            }
            if (p != this.pos) {
                this.pos = p;
                this.val = (int)(p * 127.0f);
                float f = this.curve.getVolume(this.pos);
                if ((double)f != this.volume) {
                    this.volume = f;
                    return true;
                }
            }
            return false;
        }
    }

    protected static interface Fadeable {
        public VolumeShader[] getShaders();

        public boolean move(int var1);

        public boolean move(float var1);
    }
}

