/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.midi;

import com.waxmonster.fader.VolumeShader;
import com.waxmonster.fader.midi.AbstractMidiFaderDecoder;
import com.waxmonster.midi.MidiProcessor;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.SysexMessage;

public class MidiProcessorFaderDecoder
extends AbstractMidiFaderDecoder
implements MidiProcessor {
    public void process(long time, int status) {
    }

    public void process(long time, int status, int data1) {
    }

    public void process(long time, int status, int data1, int data2) {
        if ((status & 0xF0) != 176) {
            return;
        }
        int channel = status & 0xF;
        AbstractMidiFaderDecoder.Fadeable[] arr = this.matrix[channel];
        if (arr == null) {
            return;
        }
        if (data1 < 0 || data1 >= 128) {
            return;
        }
        AbstractMidiFaderDecoder.Fadeable fader = arr[data1];
        if (fader != null && fader.move(data2)) {
            VolumeShader[] sha = fader.getShaders();
            int num = sha.length;
            int i = 0;
            while (i < num) {
                sha[i++].move(time);
            }
        }
    }

    public void process(long time, ShortMessage sm) {
        int status = sm.getStatus();
        if ((status & 0xF0) != 176) {
            return;
        }
        int channel = status & 0xF;
        AbstractMidiFaderDecoder.Fadeable[] arr = this.matrix[channel];
        if (arr == null) {
            return;
        }
        int data1 = sm.getData1();
        if (data1 < 0 || data1 >= 128) {
            return;
        }
        AbstractMidiFaderDecoder.Fadeable fader = arr[data1];
        if (fader != null && fader.move(sm.getData2())) {
            VolumeShader[] sha = fader.getShaders();
            int num = sha.length;
            int i = 0;
            while (i < num) {
                sha[i++].move(time);
            }
        }
    }

    public void process(long time, SysexMessage sm) {
    }

    public void shutdown() {
    }
}

