/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.thread.plugin;

import com.spacekiller.util.ThreadListener;
import com.spacekiller.util.ThreadManager;
import com.spacekiller.util.thread.plugin.ThreadInfo;
import com.spacekiller.util.thread.plugin.ThreadTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class ThreadTableViewer
extends JPanel {
    private static final long serialVersionUID = 4643103468653100211L;
    private Map threadInfoMap;
    private ThreadTableModel model;
    private ThreadManager threadManager;
    private ThreadHandler threadHandler = new ThreadHandler();
    private ThreadPublisher publisher = new ThreadPublisher();
    private ThreadRemover remover = new ThreadRemover();
    private JScrollPane jScrollPane = null;
    private JTable jTableExec = null;
    private boolean autoScroll = true;
    private boolean autoRemove = true;
    private List toRemove = new ArrayList();
    private JToolBar jToolBar = null;
    private JToggleButton jToggleButtonHold = null;
    private JPanel jPanel = null;
    private JToggleButton jToggleButtonLock = null;

    public ThreadTableViewer() {
        this.initialize();
        this.initThreadTableViewer();
    }

    protected void initThreadTableViewer() {
        FontMetrics fm;
        this.threadInfoMap = new HashMap();
        this.model = new ThreadTableModel();
        this.getJTableExec().setAutoResizeMode(0);
        this.getJTableExec().setColumnSelectionAllowed(false);
        this.getJTableExec().setRowSelectionAllowed(true);
        this.getJTableExec().setModel(this.model);
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        ThreadCellRenderer renderer = new ThreadCellRenderer();
        TableColumn col = new TableColumn(0, 250, renderer, null);
        col.setHeaderValue("Thread");
        columnModel.addColumn(col);
        col = new TableColumn(1, 100, renderer, null);
        col.setHeaderValue("Status");
        columnModel.addColumn(col);
        col = new TableColumn(2, 90, renderer, null);
        col.setHeaderValue("Priority");
        columnModel.addColumn(col);
        this.getJTableExec().setColumnModel(columnModel);
        Font font = renderer.getFont();
        if (font != null && (fm = this.getFontMetrics(font)) != null) {
            int rowHeight = fm.getHeight() + this.getJTableExec().getRowMargin();
            this.getJTableExec().setRowHeight(rowHeight);
        }
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(382, 262));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
        this.add((Component)this.getJToolBar(), gridBagConstraints1);
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJTableExec());
        }
        return this.jScrollPane;
    }

    private JTable getJTableExec() {
        if (this.jTableExec == null) {
            this.jTableExec = new JTable();
        }
        return this.jTableExec;
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    private JToolBar getJToolBar() {
        if (this.jToolBar == null) {
            this.jToolBar = new JToolBar();
            this.jToolBar.setFloatable(false);
            this.jToolBar.add(this.getJPanel());
            this.jToolBar.add(this.getJToggleButtonHold());
            this.jToolBar.add(this.getJToggleButtonLock());
        }
        return this.jToolBar;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public synchronized void setThreadManager(ThreadManager newManager) {
        if (this.threadManager != null) {
            this.threadManager.removeThreadListener((ThreadListener)this.threadHandler);
        }
        this.threadManager = newManager;
        this.model.clear();
        if (newManager != null) {
            Thread[] newThreads = newManager.getThreads();
            if (newThreads != null) {
                for (int i = 0; i < newThreads.length; ++i) {
                    Thread thread = newThreads[i];
                    if (thread == null) continue;
                    ThreadInfo info = (ThreadInfo)this.threadInfoMap.get(thread);
                    if (info == null) {
                        info = new ThreadInfo(thread);
                        this.threadInfoMap.put(thread, info);
                    }
                    this.model.addThreadInfo(info);
                }
            }
            newManager.addThreadListener((ThreadListener)this.threadHandler);
        }
    }

    protected synchronized void handleThreadRegistered(Thread thread) {
        if (thread == null) {
            return;
        }
        ThreadInfo info = (ThreadInfo)this.threadInfoMap.get(thread);
        if (info == null) {
            info = new ThreadInfo(thread);
            this.threadInfoMap.put(thread, info);
        }
        this.publisher.add(info);
    }

    protected synchronized void handleThreadUnregistered(Thread thread) {
        ThreadInfo info = (ThreadInfo)this.threadInfoMap.get(thread);
        if (info == null) {
            return;
        }
        if (this.autoRemove) {
            this.remover.add(info);
        } else {
            this.toRemove.add(info);
        }
    }

    public synchronized void dispose() {
        if (this.threadManager != null) {
            this.threadManager.removeThreadListener((ThreadListener)this.threadHandler);
        }
        this.threadManager = null;
        this.model.clear();
    }

    protected void refresh() {
        this.getJTableExec().repaint();
    }

    private JToggleButton getJToggleButtonHold() {
        if (this.jToggleButtonHold == null) {
            this.jToggleButtonHold = new JToggleButton();
            this.jToggleButtonHold.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/thread/plugin/icons/clear_log.gif")));
            this.jToggleButtonHold.setToolTipText("Hold completed threads");
            this.jToggleButtonHold.setSelected(false);
            this.jToggleButtonHold.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ThreadTableViewer.this.setAutoRemove(!ThreadTableViewer.this.getJToggleButtonHold().isSelected());
                    if (ThreadTableViewer.this.autoRemove) {
                        ThreadTableViewer.this.removeCompletedThreads();
                    }
                }
            });
        }
        return this.jToggleButtonHold;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setSize(new Dimension(10, 10));
            this.jPanel.setOpaque(false);
            this.jPanel.setMaximumSize(new Dimension(10, 10));
        }
        return this.jPanel;
    }

    private JToggleButton getJToggleButtonLock() {
        if (this.jToggleButtonLock == null) {
            this.jToggleButtonLock = new JToggleButton();
            this.jToggleButtonLock.setIcon(new ImageIcon(this.getClass().getResource("/com/spacekiller/util/thread/plugin/icons/lock.gif")));
            this.jToggleButtonLock.setToolTipText("Lock scroll position");
            this.jToggleButtonLock.setSelected(false);
            this.jToggleButtonLock.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ThreadTableViewer.this.setAutoScroll(!ThreadTableViewer.this.getJToggleButtonLock().isSelected());
                }
            });
        }
        return this.jToggleButtonLock;
    }

    public boolean isAutoRemove() {
        return this.autoRemove;
    }

    public void setAutoRemove(boolean autoRemove) {
        this.autoRemove = autoRemove;
    }

    protected void removeCompletedThreads() {
        Object[] tasks = this.toRemove.toArray();
        this.toRemove.clear();
        int num = tasks.length;
        for (int c = 0; c < num; ++c) {
            ThreadInfo exec = (ThreadInfo)tasks[c];
            this.model.removeThreadInfo(exec);
        }
    }

    protected class ThreadCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1367666856469050340L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Icon icon = null;
            TableColumn col = table.getColumnModel().getColumn(column);
            int colIndex = col.getModelIndex();
            if (colIndex == 2 && value != null && value instanceof Integer) {
                int v = (Integer)value;
                this.setText("" + v);
            }
            this.setIcon(icon);
            return this;
        }
    }

    protected class ThreadRemover
    implements Runnable {
        private LinkedList listAdd = new LinkedList();
        private LinkedList listAdd2 = new LinkedList();
        private boolean todo = false;

        protected ThreadRemover() {
        }

        public synchronized void add(ThreadInfo x) {
            this.listAdd.add(x);
            if (!this.todo) {
                SwingUtilities.invokeLater(this);
                this.todo = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList l = this.listAdd;
            ThreadRemover threadRemover = this;
            synchronized (threadRemover) {
                this.listAdd = this.listAdd2;
                this.listAdd2 = l;
                this.todo = false;
            }
            Iterator i = l.iterator();
            while (i.hasNext()) {
                ThreadInfo rec = (ThreadInfo)i.next();
                i.remove();
                ThreadTableViewer.this.model.removeThreadInfo(rec);
            }
        }
    }

    protected class ThreadPublisher
    implements Runnable {
        private LinkedList listAdd = new LinkedList();
        private LinkedList listAdd2 = new LinkedList();
        private boolean todo = false;

        protected ThreadPublisher() {
        }

        public synchronized void add(ThreadInfo x) {
            this.listAdd.add(x);
            if (!this.todo) {
                SwingUtilities.invokeLater(this);
                this.todo = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList l = this.listAdd;
            ThreadPublisher threadPublisher = this;
            synchronized (threadPublisher) {
                this.listAdd = this.listAdd2;
                this.listAdd2 = l;
                this.todo = false;
            }
            int row = -1;
            Iterator i = l.iterator();
            while (i.hasNext()) {
                ThreadInfo rec = (ThreadInfo)i.next();
                i.remove();
                row = ThreadTableViewer.this.model.getRowCount();
                ThreadTableViewer.this.model.addThreadInfo(rec);
            }
            if (row >= 0 && ThreadTableViewer.this.autoScroll) {
                Rectangle rect = ThreadTableViewer.this.getJTableExec().getCellRect(row, 0, true);
                ThreadTableViewer.this.getJTableExec().scrollRectToVisible(rect);
            }
        }
    }

    protected class ThreadHandler
    implements ThreadListener {
        protected ThreadHandler() {
        }

        public void threadRegistered(Thread thread) {
            ThreadTableViewer.this.handleThreadRegistered(thread);
        }

        public void threadUnregistered(Thread thread) {
            ThreadTableViewer.this.handleThreadUnregistered(thread);
        }
    }
}

