/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.other.tools;

import com.waxmonster.other.tools.MemoDevice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MemoPanel
extends JPanel {
    private static final long serialVersionUID = 1118504930880956962L;
    private MemoDevice device;
    private boolean refreshing;
    private JTextPane textPane;

    public MemoPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JScrollPane scrollPane = new JScrollPane();
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.weighty = 1.0;
        gbc_scrollPane.weightx = 1.0;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 0;
        this.add((Component)scrollPane, gbc_scrollPane);
        this.textPane = new JTextPane();
        this.textPane.setOpaque(false);
        scrollPane.setViewportView(this.textPane);
        this.initMemoPanel();
    }

    protected void initMemoPanel() {
        this.setPreferredSize(new Dimension(150, 100));
        this.textPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!MemoPanel.this.refreshing) {
                    MemoPanel.this.apply();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!MemoPanel.this.refreshing) {
                    MemoPanel.this.apply();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!MemoPanel.this.refreshing) {
                    MemoPanel.this.apply();
                }
            }
        });
    }

    public MemoDevice getDevice() {
        return this.device;
    }

    public void setDevice(MemoDevice device) {
        this.device = device;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        try {
            this.refreshing = true;
            String memoText = null;
            MemoDevice dev = this.device;
            if (dev != null) {
                memoText = dev.getMemoText();
            }
            if (memoText == null) {
                memoText = "";
            }
            this.textPane.setText(memoText);
            this.textPane.setCaretPosition(0);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        MemoDevice dev = this.device;
        if (dev == null) {
            return;
        }
        dev.setMemoText(this.textPane.getText());
    }

    protected JTextPane getTextPane() {
        return this.textPane;
    }
}

