/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.plugin;

import com.spacekiller.util.midi.MidiFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.sound.midi.MidiDevice;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;

public class MidiControllerPanel
extends JPanel {
    private static final long serialVersionUID = 4952271886231617056L;
    private MidiFormatter midiFormatter;
    private MidiDevice device;
    private int channel;
    private int controller;
    private int value;
    private JTextField jTextFieldController = null;
    private JLabel jLabel1 = null;
    private JTextField jTextFieldValue = null;
    private JSlider jSliderValue = null;
    private JCheckBox jCheckBoxSelected = null;

    public MidiControllerPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.gridy = 0;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.weightx = 0.0;
        gridBagConstraints4.gridx = 5;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints3.gridx = 4;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints2.gridy = 0;
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("Value:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints1.gridx = 2;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(518, 79));
        this.add((Component)this.getJTextFieldController(), gridBagConstraints1);
        this.add((Component)this.jLabel1, gridBagConstraints2);
        this.add((Component)this.getJTextFieldValue(), gridBagConstraints3);
        this.add((Component)this.getJSliderValue(), gridBagConstraints4);
        this.add((Component)this.getJCheckBoxSelected(), gridBagConstraints11);
    }

    public int getController() {
        return this.controller;
    }

    public void setController(int controller) {
        String name;
        this.controller = controller;
        String text = "#" + controller;
        if (this.midiFormatter != null && (name = this.midiFormatter.getControllerName(controller)) != null) {
            text = text + " (" + name + ")";
        }
        this.getJTextFieldController().setText(text);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
        this.getJTextFieldValue().setText(String.valueOf(value));
        this.getJSliderValue().setValue(value);
    }

    private JTextField getJTextFieldController() {
        if (this.jTextFieldController == null) {
            this.jTextFieldController = new JTextField();
            this.jTextFieldController.setEditable(false);
            this.jTextFieldController.setOpaque(false);
        }
        return this.jTextFieldController;
    }

    private JTextField getJTextFieldValue() {
        if (this.jTextFieldValue == null) {
            this.jTextFieldValue = new JTextField();
            this.jTextFieldValue.setColumns(4);
            this.jTextFieldValue.setOpaque(false);
            this.jTextFieldValue.setEditable(false);
        }
        return this.jTextFieldValue;
    }

    private JSlider getJSliderValue() {
        if (this.jSliderValue == null) {
            this.jSliderValue = new JSlider();
            this.jSliderValue.setMaximum(127);
            this.jSliderValue.setOpaque(false);
            this.jSliderValue.setPreferredSize(new Dimension(128, 16));
        }
        return this.jSliderValue;
    }

    public JCheckBox getJCheckBoxSelected() {
        if (this.jCheckBoxSelected == null) {
            this.jCheckBoxSelected = new JCheckBox();
            this.jCheckBoxSelected.setText("");
            this.jCheckBoxSelected.setToolTipText("Selected ?");
        }
        return this.jCheckBoxSelected;
    }

    public boolean isSelected() {
        return this.jCheckBoxSelected.isSelected();
    }

    public void setSelected(boolean selected) {
        this.jCheckBoxSelected.setSelected(selected);
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public MidiDevice getDevice() {
        return this.device;
    }

    public void setDevice(MidiDevice device) {
        this.device = device;
    }
}

