/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.plugin;

import com.spacekiller.util.midi.MidiManager;
import com.spacekiller.util.swing.SwingTools;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MidiDeviceChooser
extends JPanel
implements ItemSelectable {
    private static final long serialVersionUID = 6339863933398934895L;
    private MidiManager midiManager;
    private boolean includeMidiInDevices = true;
    private boolean includeMidiOutDevices = true;
    private JScrollPane jScrollPane = null;
    private JList jList = null;
    private transient ItemListener itemListeners;

    public MidiDeviceChooser() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(374, 253));
        this.add((Component)this.getJScrollPane(), gridBagConstraints);
    }

    public MidiManager getMidiManager() {
        return this.midiManager;
    }

    public void setMidiManager(MidiManager midiManager) {
        this.midiManager = midiManager;
        this.refresh();
    }

    public void refresh() {
        DefaultListModel<MidiDevice.Info> model = new DefaultListModel<MidiDevice.Info>();
        MidiManager manager = this.getMidiManager();
        if (manager != null) {
            MidiDevice.Info[] info = manager.getMidiDeviceInfo();
            for (int i = 0; i < info.length; ++i) {
                if (!this.includeMidiOutDevices) {
                    try {
                        MidiDevice dev = manager.getMidiDevice(info[i]);
                        if (dev.getMaxTransmitters() == 0) {
                        }
                    }
                    catch (MidiUnavailableException e) {}
                    continue;
                }
                model.addElement(info[i]);
            }
        }
        this.getJList().setModel(model);
        this.validate();
        this.repaint();
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJList());
        }
        return this.jScrollPane;
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    MidiDeviceChooser.this.handleSelectionChanged();
                }
            });
        }
        return this.jList;
    }

    protected void fireItemStateChanged(ItemEvent e) {
        if (this.itemListeners == null) {
            return;
        }
        this.itemListeners.itemStateChanged(e);
    }

    @Override
    public void addItemListener(ItemListener listener) {
        this.itemListeners = AWTEventMulticaster.add(this.itemListeners, listener);
    }

    @Override
    public void removeItemListener(ItemListener listener) {
        this.itemListeners = AWTEventMulticaster.remove(this.itemListeners, listener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])AWTEventMulticaster.getListeners((EventListener)this.itemListeners, ItemListener.class);
    }

    @Override
    public Object[] getSelectedObjects() {
        JList list = this.getJList();
        return SwingTools.getSelectedObjects((JList)list);
    }

    public boolean isIncludeMidiOutDevices() {
        return this.includeMidiOutDevices;
    }

    public void setIncludeMidiOutDevices(boolean includeMidiOutDevices) {
        this.includeMidiOutDevices = includeMidiOutDevices;
    }

    public boolean isIncludeMidiInDevices() {
        return this.includeMidiInDevices;
    }

    public void setIncludeMidiInDevices(boolean includeMidiInDevices) {
        this.includeMidiInDevices = includeMidiInDevices;
    }

    protected void handleSelectionChanged() {
        this.fireItemStateChanged(new ItemEvent(this, 701, null, 1));
    }

    public void selectAll() {
        int size = this.getJList().getModel().getSize();
        if (size > 0) {
            this.getJList().setSelectionInterval(0, size - 1);
        }
    }
}

