/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.plugin;

import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.impl.DefaultMidiFormatter;
import com.spacekiller.util.swing.AbstractCellRenderer;
import java.awt.Component;
import java.awt.GridLayout;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class MidiEventListCellRenderer
extends AbstractCellRenderer
implements ListCellRenderer {
    private static final long serialVersionUID = 4786323153194452903L;
    private JLabel label;
    private MidiFormatter formatter;

    public MidiEventListCellRenderer() {
        this.setOpaque(false);
        this.label = new JLabel();
        this.label.setFont(this.getFont());
        this.setLayout(new GridLayout(1, 1));
        this.add(this.label);
        this.formatter = DefaultMidiFormatter.getSharedInstance();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        this.setSelected(isSelected);
        this.setFocus(cellHasFocus);
        String tooltip = null;
        String text = null;
        if (value != null && value instanceof MidiEvent) {
            MidiEvent event = (MidiEvent)value;
            MidiMessage message = event.getMessage();
            text = this.formatter.formatMidiMessage(message);
        }
        if (text == null) {
            text = "";
        }
        this.label.setText(text);
        this.setToolTipText(tooltip);
        return this;
    }
}

