/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.plugin;

import com.spacekiller.util.midi.MidiFilter;
import com.spacekiller.util.midi.MidiListener;
import java.util.LinkedList;
import java.util.List;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.swing.AbstractListModel;
import javax.swing.SwingUtilities;

public class MidiEventListModel
extends AbstractListModel {
    private static final long serialVersionUID = 7180674670987359570L;
    private int maxSize;
    private volatile int size;
    private MidiEvent[] array;
    private int head;
    private int tail;
    private MidiHandler handler;
    private MidiFilter filter;

    public MidiEventListModel(int maxSize) {
        this.maxSize = ++maxSize;
        this.array = new MidiEvent[maxSize];
        this.handler = new MidiHandler();
        this.setFilter((MidiFilter)MidiFilter.SPAM_FILTER);
        this.clear();
    }

    @Override
    public synchronized int getSize() {
        return this.size;
    }

    @Override
    public synchronized Object getElementAt(int index) {
        return this.array[(this.head + index) % this.maxSize];
    }

    public synchronized void clear() {
        int num = this.size;
        if (num < 1) {
            return;
        }
        this.size = 0;
        this.head = 0;
        this.tail = 0;
        this.fireIntervalRemoved(this, 0, num - 1);
    }

    protected synchronized void add(List events) {
        int addedCount = events.size();
        if (addedCount < 1) {
            return;
        }
        int removedCount = 0;
        int oldSize = this.size;
        for (int i = 0; i < addedCount; ++i) {
            this.array[this.tail++] = (MidiEvent)events.get(i);
            if (this.tail >= this.maxSize) {
                this.tail = 0;
            }
            if (this.tail == this.head) {
                this.head = (this.head + 1) % this.maxSize;
                ++removedCount;
                continue;
            }
            ++this.size;
        }
        if (removedCount > 0) {
            this.fireIntervalRemoved(this, 0, removedCount - 1);
        }
        if (addedCount > 0) {
            this.fireIntervalAdded(this, oldSize - removedCount, oldSize - removedCount + addedCount - 1);
        }
    }

    public MidiHandler getHandler() {
        return this.handler;
    }

    public MidiFilter getFilter() {
        return this.filter;
    }

    public void setFilter(MidiFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter must not be null");
        }
        this.filter = filter;
    }

    protected class MidiHandler
    implements MidiListener,
    Runnable {
        private LinkedList queue = new LinkedList();
        private LinkedList queue2 = new LinkedList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(MidiEvent event) {
            if (MidiEventListModel.this.filter.accept(event.getMessage())) {
                boolean first;
                MidiHandler midiHandler = this;
                synchronized (midiHandler) {
                    first = this.queue.isEmpty();
                    this.queue.add(event);
                }
                if (first) {
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(MidiMessage message, long time) {
            if (MidiEventListModel.this.filter.accept(message)) {
                boolean first;
                MidiHandler midiHandler = this;
                synchronized (midiHandler) {
                    first = this.queue.isEmpty();
                    this.queue.add(new MidiEvent(message, time));
                }
                if (first) {
                    SwingUtilities.invokeLater(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList list;
            MidiHandler midiHandler = this;
            synchronized (midiHandler) {
                list = this.queue;
                this.queue = this.queue2;
                this.queue2 = list;
            }
            MidiEventListModel.this.add(list);
            list.clear();
        }
    }
}

