/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.plugin;

import com.spacekiller.util.midi.plugin.MidiEventListCellRenderer;
import com.spacekiller.util.midi.plugin.MidiEventListModel;
import com.spacekiller.util.midi.plugin.MidiLogPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MidiEventListPanel
extends JPanel {
    private static final long serialVersionUID = -2156543723958896392L;
    private MidiEventListModel model;
    private boolean scrollLock;
    private ListDataHandler listDataHandler = new ListDataHandler();
    private ScrollLastEvent scrollLastEvent = new ScrollLastEvent();
    private JPanel panelTools;
    private JToggleButton tglbtnLockScroll;
    private JButton btnClearList;
    private JScrollPane jScrollPaneEvents = null;
    private JList jListEvents = null;

    public MidiEventListPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        GridBagConstraints gbc_jScrollPaneEvents = new GridBagConstraints();
        gbc_jScrollPaneEvents.insets = new Insets(0, 0, 0, 4);
        gbc_jScrollPaneEvents.weighty = 1.0;
        gbc_jScrollPaneEvents.weightx = 1.0;
        gbc_jScrollPaneEvents.fill = 1;
        gbc_jScrollPaneEvents.gridx = 0;
        gbc_jScrollPaneEvents.gridy = 0;
        this.add((Component)this.getJScrollPaneEvents(), gbc_jScrollPaneEvents);
        GridBagConstraints gbc_panelTools = new GridBagConstraints();
        gbc_panelTools.fill = 1;
        gbc_panelTools.gridx = 1;
        gbc_panelTools.gridy = 0;
        this.add((Component)this.getPanelTools(), gbc_panelTools);
        this.initMidiEventListPanel();
    }

    protected void initMidiEventListPanel() {
        MidiEventListCellRenderer renderer = new MidiEventListCellRenderer();
        this.getJListEvents().setCellRenderer(renderer);
    }

    private JScrollPane getJScrollPaneEvents() {
        if (this.jScrollPaneEvents == null) {
            this.jScrollPaneEvents = new JScrollPane();
            this.jScrollPaneEvents.setViewportView(this.getJListEvents());
        }
        return this.jScrollPaneEvents;
    }

    private JList getJListEvents() {
        if (this.jListEvents == null) {
            this.jListEvents = new JList();
        }
        return this.jListEvents;
    }

    public MidiEventListModel getModel() {
        return this.model;
    }

    public void setModel(MidiEventListModel model) {
        MidiEventListModel old = this.model;
        if (model == old) {
            return;
        }
        if (old != null) {
            old.removeListDataListener(this.listDataHandler);
        }
        this.model = model;
        if (model != null) {
            model.addListDataListener(this.listDataHandler);
        }
        this.getJListEvents().setModel(model);
    }

    private JPanel getPanelTools() {
        if (this.panelTools == null) {
            this.panelTools = new JPanel();
            GridBagLayout gbl_panelTools = new GridBagLayout();
            gbl_panelTools.columnWidths = new int[]{0, 0};
            gbl_panelTools.rowHeights = new int[]{0, 0, 0};
            gbl_panelTools.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelTools.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelTools.setLayout(gbl_panelTools);
            GridBagConstraints gbc_btnClearList = new GridBagConstraints();
            gbc_btnClearList.insets = new Insets(0, 0, 5, 0);
            gbc_btnClearList.gridx = 0;
            gbc_btnClearList.gridy = 0;
            this.panelTools.add((Component)this.getBtnClearList(), gbc_btnClearList);
            GridBagConstraints gbc_tglbtnLockScroll = new GridBagConstraints();
            gbc_tglbtnLockScroll.gridx = 0;
            gbc_tglbtnLockScroll.gridy = 1;
            this.panelTools.add((Component)this.getTglbtnLockScroll(), gbc_tglbtnLockScroll);
        }
        return this.panelTools;
    }

    private JToggleButton getTglbtnLockScroll() {
        if (this.tglbtnLockScroll == null) {
            this.tglbtnLockScroll = new JToggleButton("");
            this.tglbtnLockScroll.setIcon(new ImageIcon(MidiLogPanel.class.getResource("/com/spacekiller/util/midi/plugin/icons/lock.gif")));
            this.tglbtnLockScroll.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MidiEventListPanel.this.handleScrollLockChanged();
                }
            });
            this.tglbtnLockScroll.setToolTipText("Lock scroll position");
            this.tglbtnLockScroll.setMargin(new Insets(2, 2, 2, 2));
        }
        return this.tglbtnLockScroll;
    }

    private JButton getBtnClearList() {
        if (this.btnClearList == null) {
            this.btnClearList = new JButton("");
            this.btnClearList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MidiEventListPanel.this.actionClearEventList();
                }
            });
            this.btnClearList.setIcon(new ImageIcon(MidiLogPanel.class.getResource("/com/spacekiller/util/midi/plugin/icons/clear_log.gif")));
            this.btnClearList.setToolTipText("Clear event list");
            this.btnClearList.setMargin(new Insets(2, 2, 2, 2));
        }
        return this.btnClearList;
    }

    protected void actionClearEventList() {
        if (this.model == null) {
            return;
        }
        this.model.clear();
    }

    protected void handleScrollLockChanged() {
        this.setScrollLock(this.tglbtnLockScroll.isSelected());
    }

    public boolean isScrollLock() {
        return this.scrollLock;
    }

    public void setScrollLock(boolean scrollLock) {
        this.scrollLock = scrollLock;
    }

    protected class ScrollLastEvent
    implements Runnable {
        protected ScrollLastEvent() {
        }

        @Override
        public void run() {
            Rectangle aRect;
            int index = MidiEventListPanel.this.model.getSize() - 1;
            if (index >= 0 && (aRect = MidiEventListPanel.this.jListEvents.getCellBounds(index, index)) != null) {
                MidiEventListPanel.this.jListEvents.scrollRectToVisible(aRect);
            }
        }
    }

    protected class ListDataHandler
    implements ListDataListener {
        protected ListDataHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            if (!MidiEventListPanel.this.scrollLock) {
                SwingUtilities.invokeLater(MidiEventListPanel.this.scrollLastEvent);
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            if (MidiEventListPanel.this.scrollLock) {
                int index0 = e.getIndex0();
                int index1 = e.getIndex1();
                Rectangle delRect = MidiEventListPanel.this.jListEvents.getCellBounds(index0, index1);
                Rectangle visRect = MidiEventListPanel.this.jListEvents.getVisibleRect();
                if (delRect != null && visRect != null && delRect.y < visRect.y) {
                    visRect.y -= delRect.height;
                    if (visRect.y < 0) {
                        visRect.y = 0;
                    }
                    MidiEventListPanel.this.jListEvents.scrollRectToVisible(visRect);
                }
            }
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }
    }
}

