/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.plugin;

import com.spacekiller.util.midi.MidiFormatter;
import com.spacekiller.util.midi.MidiManager;
import com.spacekiller.util.midi.impl.MidiDeviceEvent;
import com.spacekiller.util.midi.plugin.MidiControllerPanel;
import com.spacekiller.util.midi.plugin.MidiEventListModel;
import com.spacekiller.util.midi.plugin.MidiLogPanel;
import com.spacekiller.util.midi.plugin.MidiNotePanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class MidiLearnPanel
extends JPanel {
    private static final long serialVersionUID = -8884516726438024715L;
    public static final int MODE_ALL = 0;
    public static final int MODE_NOTE_ONLY = 1;
    public static final int MODE_CONTROLLER_ONLY = 2;
    private MidiManager midiManager;
    private MidiFormatter midiFormatter;
    private MidiEventListModel model;
    private boolean autoSelect = true;
    private boolean autoSelected = false;
    private int mode = 0;
    private MidiDevice.Info midiDeviceInfo = null;
    private int midiChannel = -1;
    private int midiNote = -1;
    private int midiController = -1;
    private ListDataHandler listDataHandler = new ListDataHandler();
    private MidiNotePanel[] notes;
    private MidiControllerPanel[] controllers;
    private ButtonGroup selectedButtonGroup;
    private SelectedItemHandler selectedItemHandler = new SelectedItemHandler();
    private Window window;
    private boolean confirm;
    private JPanel jPanelLearn = null;
    private JPanel jPanelOptions = null;
    private JButton jButtonOkay = null;
    private JButton jButtonCancel = null;
    private MidiLogPanel midiLogPanel = null;
    private JScrollPane jScrollPaneMidiComponents = null;
    private JPanel jPanelMidiComponents = null;
    private JPanel panelTools;
    private JButton btnClear;
    private JToggleButton tglbtnLock;

    public MidiLearnPanel() {
        this.initialize();
        this.initMidiLearnPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 2;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.weighty = 1.0;
        gridBagConstraints5.gridy = 1;
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
        gridBagConstraints21.insets = new Insets(0, 0, 4, 0);
        gridBagConstraints21.gridx = 0;
        gridBagConstraints21.fill = 1;
        gridBagConstraints21.weightx = 1.0;
        gridBagConstraints21.weighty = 1.0;
        gridBagConstraints21.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(578, 436));
        this.add((Component)this.getMidiLogPanel(), gridBagConstraints21);
        this.add((Component)this.getJPanelLearn(), gridBagConstraints5);
        this.add((Component)this.getJPanelOptions(), gridBagConstraints6);
    }

    private JPanel getJPanelLearn() {
        if (this.jPanelLearn == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.insets = new Insets(0, 0, 0, 4);
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.weighty = 1.0;
            gridBagConstraints7.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.gridwidth = 1;
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.insets = new Insets(4, 4, 4, 4);
            this.jPanelLearn = new JPanel();
            GridBagLayout gbl_jPanelLearn = new GridBagLayout();
            gbl_jPanelLearn.rowWeights = new double[]{0.0};
            gbl_jPanelLearn.columnWeights = new double[]{0.0, 0.0};
            this.jPanelLearn.setLayout(gbl_jPanelLearn);
            this.jPanelLearn.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "MIDI Controllers", 0, 0, null, null));
            this.jPanelLearn.add((Component)this.getJScrollPaneMidiComponents(), gridBagConstraints7);
            GridBagConstraints gbc_panelTools = new GridBagConstraints();
            gbc_panelTools.fill = 1;
            gbc_panelTools.gridx = 1;
            gbc_panelTools.gridy = 0;
            this.jPanelLearn.add((Component)this.getPanelTools(), gbc_panelTools);
        }
        return this.jPanelLearn;
    }

    public MidiDevice.Info getMidiDeviceInfo() {
        return this.midiDeviceInfo;
    }

    public void setMidiDeviceInfo(MidiDevice.Info midiDeviceInfo) {
        this.midiDeviceInfo = midiDeviceInfo;
    }

    public int getMidiNote() {
        return this.midiNote;
    }

    public void setMidiNote(int midiNote) {
        this.midiNote = midiNote;
    }

    public int getMidiController() {
        return this.midiController;
    }

    public void setMidiController(int midiController) {
        this.midiController = midiController;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public MidiManager getMidiManager() {
        return this.midiManager;
    }

    public synchronized void setMidiManager(MidiManager midiManager) {
        this.midiManager = midiManager;
        this.getMidiLogPanel().setMidiManager(midiManager);
        this.getMidiLogPanel().setModel(this.model);
    }

    public static boolean showMidiLearnDialog(Component parentComponent, String title, MidiLearnPanel midiLearnPanel) {
        JOptionPane pane = new JOptionPane();
        pane.setOptions(new Object[0]);
        pane.setMessageType(-1);
        pane.setMessage(midiLearnPanel);
        JDialog dialog = pane.createDialog(parentComponent, title);
        midiLearnPanel.window = dialog;
        dialog.setResizable(true);
        dialog.setModal(true);
        dialog.pack();
        dialog.setVisible(true);
        dialog.dispose();
        return midiLearnPanel.confirm;
    }

    private JPanel getJPanelOptions() {
        if (this.jPanelOptions == null) {
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(4, 4, 4, 4);
            gridBagConstraints2.gridy = 0;
            this.jPanelOptions = new JPanel();
            this.jPanelOptions.setLayout(new GridBagLayout());
            this.jPanelOptions.setOpaque(false);
            this.jPanelOptions.add((Component)this.getJButtonOkay(), gridBagConstraints2);
            this.jPanelOptions.add((Component)this.getJButtonCancel(), gridBagConstraints3);
        }
        return this.jPanelOptions;
    }

    private JButton getJButtonOkay() {
        if (this.jButtonOkay == null) {
            this.jButtonOkay = new JButton();
            this.jButtonOkay.setText("OK");
            this.jButtonOkay.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MidiLearnPanel.this.confirm = true;
                    if (MidiLearnPanel.this.window != null) {
                        MidiLearnPanel.this.window.dispose();
                    }
                }
            });
        }
        return this.jButtonOkay;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MidiLearnPanel.this.confirm = false;
                    if (MidiLearnPanel.this.window != null) {
                        MidiLearnPanel.this.window.dispose();
                    }
                }
            });
        }
        return this.jButtonCancel;
    }

    private MidiLogPanel getMidiLogPanel() {
        if (this.midiLogPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(4, 0, 0, 0);
            this.midiLogPanel = new MidiLogPanel();
        }
        return this.midiLogPanel;
    }

    public MidiEventListModel getModel() {
        return this.model;
    }

    public synchronized void setModel(MidiEventListModel newModel) {
        if (this.model == newModel) {
            return;
        }
        if (this.model != null) {
            this.model.removeListDataListener(this.listDataHandler);
        }
        this.model = newModel;
        this.getMidiLogPanel().setModel(newModel);
        if (this.model != null) {
            this.model.addListDataListener(this.listDataHandler);
        }
    }

    protected void handleMidiEvent(MidiEvent me) {
        MidiMessage msg = me.getMessage();
        byte[] data = msg.getMessage();
        if (data.length < 3) {
            return;
        }
        switch (data[0] & 0xF0) {
            case 176: {
                if (this.mode == 1) {
                    return;
                }
                int channel = data[0] & 0xF;
                byte controller = data[1];
                byte value = data[2];
                this.handleMidiControlChange(this.getDevice(me), channel, controller, value);
                return;
            }
            case 144: {
                if (this.mode == 2) {
                    return;
                }
                int channel = data[0] & 0xF;
                byte note = data[1];
                byte velocity = data[2];
                if (velocity > 0) {
                    this.handleMidiNoteOn(this.getDevice(me), channel, note, velocity);
                } else {
                    this.handleMidiNoteOff(this.getDevice(me), channel, note, 64);
                }
                return;
            }
            case 128: {
                if (this.mode == 2) {
                    return;
                }
                int channel = data[0] & 0xF;
                byte note = data[1];
                byte velocity = data[2];
                this.handleMidiNoteOff(this.getDevice(me), channel, note, velocity);
                return;
            }
        }
    }

    protected MidiDevice getDevice(MidiEvent me) {
        if (me instanceof MidiDeviceEvent) {
            return ((MidiDeviceEvent)me).getDevice();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMidiControlChange(MidiDevice device, int channel, int controller, int value) {
        if (controller > 127 || controller < 0) {
            return;
        }
        MidiControllerPanel[] midiControllerPanelArray = this.controllers;
        synchronized (this.controllers) {
            MidiControllerPanel panel = this.controllers[controller];
            if (panel == null) {
                panel = new MidiControllerPanel();
                panel.setMidiFormatter(this.midiFormatter);
                panel.setController(controller);
                JCheckBox checkBox = panel.getJCheckBoxSelected();
                checkBox.addItemListener(this.selectedItemHandler);
                this.selectedButtonGroup.add(checkBox);
                this.controllers[controller] = panel;
                this.addMidiComponent(panel);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            panel.setDevice(device);
            panel.setChannel(channel);
            panel.setValue(value);
            if (this.autoSelect) {
                try {
                    this.autoSelected = true;
                    panel.setSelected(true);
                }
                finally {
                    this.autoSelected = false;
                }
                this.getJPanelMidiComponents().scrollRectToVisible(panel.getBounds());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMidiNoteOn(MidiDevice device, int channel, int note, int velocity) {
        if (note > 127 || note < 0) {
            return;
        }
        MidiNotePanel[] midiNotePanelArray = this.notes;
        synchronized (this.notes) {
            MidiNotePanel panel = this.notes[note];
            if (panel == null) {
                panel = new MidiNotePanel();
                panel.setMidiFormatter(this.midiFormatter);
                panel.setNote(note);
                JCheckBox checkBox = panel.getJCheckBoxSelected();
                checkBox.addItemListener(this.selectedItemHandler);
                this.selectedButtonGroup.add(checkBox);
                this.notes[note] = panel;
                this.addMidiComponent(panel);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            panel.setDevice(device);
            panel.setChannel(channel);
            panel.setVelocity(velocity);
            if (this.autoSelect) {
                try {
                    this.autoSelected = true;
                    panel.setSelected(true);
                }
                finally {
                    this.autoSelected = false;
                }
                this.getJPanelMidiComponents().scrollRectToVisible(panel.getBounds());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMidiNoteOff(MidiDevice device, int channel, int note, int velocity) {
        if (note > 127 || note < 0) {
            return;
        }
        MidiNotePanel[] midiNotePanelArray = this.notes;
        synchronized (this.notes) {
            MidiNotePanel panel = this.notes[note];
            if (panel == null) {
                panel = new MidiNotePanel();
                panel.setMidiFormatter(this.midiFormatter);
                panel.setNote(note);
                JCheckBox checkBox = panel.getJCheckBoxSelected();
                checkBox.addItemListener(this.selectedItemHandler);
                this.selectedButtonGroup.add(checkBox);
                this.notes[note] = panel;
                this.addMidiComponent(panel);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            panel.setDevice(device);
            panel.setChannel(channel);
            panel.setVelocity(0);
            if (this.autoSelect) {
                try {
                    this.autoSelected = true;
                    panel.setSelected(true);
                }
                finally {
                    this.autoSelected = false;
                }
                this.getJPanelMidiComponents().scrollRectToVisible(panel.getBounds());
            }
            return;
        }
    }

    public int getMidiChannel() {
        return this.midiChannel;
    }

    public void setMidiChannel(int midiChannel) {
        this.midiChannel = midiChannel;
    }

    protected void initMidiLearnPanel() {
        this.notes = new MidiNotePanel[128];
        this.controllers = new MidiControllerPanel[128];
        this.selectedButtonGroup = new ButtonGroup();
        this.getJButtonOkay().setEnabled(false);
        this.setPreferredSize(new Dimension(600, 500));
    }

    protected void addMidiComponent(Component comp) {
        this.getJPanelMidiComponents().add(comp);
        GridLayout layout = new GridLayout(this.getJPanelMidiComponents().getComponentCount(), 1);
        this.getJPanelMidiComponents().setLayout(layout);
        this.getJScrollPaneMidiComponents().validate();
        this.getJScrollPaneMidiComponents().repaint();
    }

    private JScrollPane getJScrollPaneMidiComponents() {
        if (this.jScrollPaneMidiComponents == null) {
            this.jScrollPaneMidiComponents = new JScrollPane();
            this.jScrollPaneMidiComponents.setViewportView(this.getJPanelMidiComponents());
        }
        return this.jScrollPaneMidiComponents;
    }

    private JPanel getJPanelMidiComponents() {
        if (this.jPanelMidiComponents == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            this.jPanelMidiComponents = new JPanel();
            this.jPanelMidiComponents.setLayout(gridLayout);
        }
        return this.jPanelMidiComponents;
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    public void selectAllMidiDevices() {
        this.getMidiLogPanel().selectAllMidiDevices();
    }

    protected MidiControllerPanel getSelectedMidiControllerPanel() {
        for (int i = 0; i < this.controllers.length; ++i) {
            MidiControllerPanel panel = this.controllers[i];
            if (panel == null || !panel.isSelected()) continue;
            return panel;
        }
        return null;
    }

    protected MidiNotePanel getSelectedMidiNotePanel() {
        for (int i = 0; i < this.notes.length; ++i) {
            MidiNotePanel panel = this.notes[i];
            if (panel == null || !panel.isSelected()) continue;
            return panel;
        }
        return null;
    }

    protected void handleControllerSelected() {
        MidiControllerPanel mcp = this.getSelectedMidiControllerPanel();
        MidiNotePanel mnp = this.getSelectedMidiNotePanel();
        boolean selected = false;
        if (mcp != null) {
            MidiDevice device = mcp.getDevice();
            this.midiDeviceInfo = device == null ? null : device.getDeviceInfo();
            this.midiChannel = mcp.getChannel();
            this.midiController = mcp.getController();
            this.midiNote = -1;
            selected = true;
        } else if (mnp != null) {
            MidiDevice device = mnp.getDevice();
            this.midiDeviceInfo = device == null ? null : device.getDeviceInfo();
            this.midiChannel = mnp.getChannel();
            this.midiNote = mnp.getNote();
            this.midiController = -1;
            selected = true;
        }
        this.getJButtonOkay().setEnabled(selected);
    }

    public boolean isAutoSelect() {
        return this.autoSelect;
    }

    public void setAutoSelect(boolean autoSelect) {
        this.autoSelect = autoSelect;
    }

    private JPanel getPanelTools() {
        if (this.panelTools == null) {
            this.panelTools = new JPanel();
            GridBagLayout gbl_panelTools = new GridBagLayout();
            gbl_panelTools.columnWidths = new int[]{0, 0};
            gbl_panelTools.rowHeights = new int[]{0, 0, 0};
            gbl_panelTools.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelTools.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
            this.panelTools.setLayout(gbl_panelTools);
            GridBagConstraints gbc_btnClear = new GridBagConstraints();
            gbc_btnClear.insets = new Insets(0, 0, 5, 0);
            gbc_btnClear.gridx = 0;
            gbc_btnClear.gridy = 0;
            this.panelTools.add((Component)this.getBtnClear(), gbc_btnClear);
            GridBagConstraints gbc_tglbtnLock = new GridBagConstraints();
            gbc_tglbtnLock.gridx = 0;
            gbc_tglbtnLock.gridy = 1;
            this.panelTools.add((Component)this.getTglbtnLock(), gbc_tglbtnLock);
        }
        return this.panelTools;
    }

    private JButton getBtnClear() {
        if (this.btnClear == null) {
            this.btnClear = new JButton("");
            this.btnClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MidiLearnPanel.this.actionClearComponentList();
                }
            });
            this.btnClear.setMargin(new Insets(2, 2, 2, 2));
            this.btnClear.setIcon(new ImageIcon(MidiLearnPanel.class.getResource("/com/spacekiller/util/midi/plugin/icons/clear_log.gif")));
            this.btnClear.setToolTipText("Clear list");
        }
        return this.btnClear;
    }

    private JToggleButton getTglbtnLock() {
        if (this.tglbtnLock == null) {
            this.tglbtnLock = new JToggleButton("");
            this.tglbtnLock.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MidiLearnPanel.this.handleScrollLockChanged();
                }
            });
            this.tglbtnLock.setMargin(new Insets(2, 2, 2, 2));
            this.tglbtnLock.setIcon(new ImageIcon(MidiLearnPanel.class.getResource("/com/spacekiller/util/midi/plugin/icons/lock.gif")));
            this.tglbtnLock.setToolTipText("Lock selected event");
        }
        return this.tglbtnLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void actionClearComponentList() {
        JPanel[] jPanelArray = this.controllers;
        synchronized (this.controllers) {
            Arrays.fill(this.controllers, null);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            jPanelArray = this.notes;
            synchronized (this.notes) {
                Arrays.fill(this.notes, null);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                this.getJPanelMidiComponents().removeAll();
                GridLayout layout = new GridLayout(0, 1);
                this.getJPanelMidiComponents().setLayout(layout);
                this.getJScrollPaneMidiComponents().validate();
                this.getJScrollPaneMidiComponents().repaint();
                this.handleControllerSelected();
                return;
            }
        }
    }

    protected void handleScrollLockChanged() {
        this.setAutoSelect(!this.tglbtnLock.isSelected());
    }

    protected class SelectedItemHandler
    implements ItemListener {
        protected SelectedItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!MidiLearnPanel.this.autoSelected) {
                MidiLearnPanel.this.getTglbtnLock().setSelected(true);
            }
            MidiLearnPanel.this.handleControllerSelected();
        }
    }

    protected class ListDataHandler
    implements ListDataListener {
        protected ListDataHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            int index1;
            int index0 = e.getIndex0();
            if (index0 > (index1 = e.getIndex1())) {
                int swap = index0;
                index0 = index1;
                index1 = swap;
            }
            for (int i = index0; i <= index1; ++i) {
                MidiLearnPanel.this.handleMidiEvent((MidiEvent)MidiLearnPanel.this.model.getElementAt(i));
            }
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }
    }
}

