/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.plugin;

import com.spacekiller.util.midi.MidiManager;
import com.spacekiller.util.midi.plugin.MidiDeviceChooser;
import com.spacekiller.util.midi.plugin.MidiEventListModel;
import com.spacekiller.util.midi.plugin.MidiEventListPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MidiLogPanel
extends JPanel {
    private static final long serialVersionUID = -3894471087985334738L;
    private static final Logger logger = Logger.getLogger(MidiLogPanel.class.getName());
    private MidiManager midiManager;
    private MidiDeviceChooser midiDeviceChooser = null;
    private JPanel panelMidiEvents;
    private MidiEventListPanel midiEventListPanel;

    public MidiLogPanel() {
        this.initialize();
        this.initMidiLogPanel();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0};
        this.setLayout(gridBagLayout);
        this.setSize(new Dimension(586, 335));
        GridBagConstraints gbc_panelMidiEvents = new GridBagConstraints();
        gbc_panelMidiEvents.insets = new Insets(0, 4, 0, 0);
        gbc_panelMidiEvents.weighty = 1.0;
        gbc_panelMidiEvents.weightx = 1.0;
        gbc_panelMidiEvents.fill = 1;
        gbc_panelMidiEvents.gridx = 1;
        gbc_panelMidiEvents.gridy = 0;
        this.add((Component)this.getPanelMidiEvents(), gbc_panelMidiEvents);
        this.add((Component)this.getMidiDeviceChooser(), gridBagConstraints1);
    }

    protected void initMidiLogPanel() {
        this.getMidiDeviceChooser().setIncludeMidiInDevices(true);
        this.getMidiDeviceChooser().setIncludeMidiOutDevices(false);
    }

    private MidiDeviceChooser getMidiDeviceChooser() {
        if (this.midiDeviceChooser == null) {
            this.midiDeviceChooser = new MidiDeviceChooser();
            this.midiDeviceChooser.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Devices", 4, 2, null, null));
            this.midiDeviceChooser.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MidiLogPanel.this.refresh();
                }
            });
        }
        return this.midiDeviceChooser;
    }

    public MidiManager getMidiManager() {
        return this.midiManager;
    }

    public void setMidiManager(MidiManager midiManager) {
        this.midiManager = midiManager;
        this.getMidiDeviceChooser().setMidiManager(midiManager);
    }

    public void setModel(MidiEventListModel model) {
        this.getMidiEventListPanel().setModel(model);
    }

    public void refresh() {
        MidiManager manager = this.midiManager;
        if (manager == null) {
            return;
        }
        Object[] sel = this.midiDeviceChooser.getSelectedObjects();
        HashSet<Object> set = new HashSet<Object>(sel.length);
        for (int i = 0; i < sel.length; ++i) {
            set.add(sel[i]);
        }
        MidiDevice.Info[] infos = manager.getMidiDeviceInfo();
        for (int i = 0; i < infos.length; ++i) {
            MidiDevice.Info info = infos[i];
            try {
                MidiDevice dev = manager.getMidiDevice(info);
                if (set.contains(info)) {
                    manager.openMidiDevice(dev);
                    continue;
                }
                manager.closeMidiDevice(dev);
                continue;
            }
            catch (MidiUnavailableException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }

    public void selectAllMidiDevices() {
        this.getMidiDeviceChooser().selectAll();
    }

    private JPanel getPanelMidiEvents() {
        if (this.panelMidiEvents == null) {
            this.panelMidiEvents = new JPanel();
            this.panelMidiEvents.setBorder(new TitledBorder(new EtchedBorder(1, null, null), "MIDI Events", 4, 2, null, null));
            GridBagLayout gbl_panelMidiEvents = new GridBagLayout();
            gbl_panelMidiEvents.columnWidths = new int[]{0, 0};
            gbl_panelMidiEvents.rowHeights = new int[]{0, 0};
            gbl_panelMidiEvents.columnWeights = new double[]{0.0, Double.MIN_VALUE};
            gbl_panelMidiEvents.rowWeights = new double[]{0.0, Double.MIN_VALUE};
            this.panelMidiEvents.setLayout(gbl_panelMidiEvents);
            this.midiEventListPanel = new MidiEventListPanel();
            GridBagConstraints gbc_midiEventListPanel = new GridBagConstraints();
            gbc_midiEventListPanel.weighty = 1.0;
            gbc_midiEventListPanel.weightx = 1.0;
            gbc_midiEventListPanel.fill = 1;
            gbc_midiEventListPanel.gridx = 0;
            gbc_midiEventListPanel.gridy = 0;
            this.panelMidiEvents.add((Component)this.midiEventListPanel, gbc_midiEventListPanel);
        }
        return this.panelMidiEvents;
    }

    protected MidiEventListPanel getMidiEventListPanel() {
        return this.midiEventListPanel;
    }
}

