/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.plugin;

import com.spacekiller.util.midi.MidiFactory;
import com.spacekiller.util.midi.MidiFilter;
import com.spacekiller.util.midi.MidiListener;
import com.spacekiller.util.midi.MidiManager;
import com.spacekiller.util.midi.impl.DefaultMidiFactory;
import com.spacekiller.util.midi.plugin.MidiEventListModel;
import com.spacekiller.util.midi.plugin.MidiLogPanel;
import com.spacekiller.util.workbench.View;
import java.awt.Component;
import java.awt.Dimension;

public class MidiLogView
extends View {
    private MidiManager midiManager;
    private MidiEventListModel model;
    private int maxSize = 1000;

    protected Component createComponent() {
        MidiManager manager = this.getMidiManager();
        if (manager == null) {
            try {
                MidiFactory factory = DefaultMidiFactory.getInstance();
                this.midiManager = manager = factory.createMidiManager();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        MidiEventListModel model = new MidiEventListModel(this.maxSize);
        model.setFilter((MidiFilter)MidiFilter.SPAM_FILTER);
        manager.addMidiListener((MidiListener)model.getHandler());
        MidiLogPanel panel = new MidiLogPanel();
        panel.setPreferredSize(new Dimension(750, 650));
        panel.setMidiManager(manager);
        panel.setModel(model);
        return panel;
    }

    protected void installChildComponent(View child, Component childComponent) {
    }

    protected void uninstallChildComponent(View child, Component childComponent) {
    }

    protected synchronized void dispose() {
        super.dispose();
        MidiManager manager = this.midiManager;
        if (manager != null) {
            manager.close();
            if (this.model != null) {
                manager.removeMidiListener((MidiListener)this.model.getHandler());
            }
            manager = null;
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public MidiManager getMidiManager() {
        return this.midiManager;
    }

    public void setMidiManager(MidiManager midiManager) {
        this.midiManager = midiManager;
    }
}

