/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.midi.plugin;

import com.spacekiller.util.midi.MidiFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.sound.midi.MidiDevice;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MidiNotePanel
extends JPanel {
    private static final long serialVersionUID = -8777423100760953541L;
    private MidiFormatter midiFormatter;
    private MidiDevice device;
    private int channel;
    private int note;
    private int velocity;
    private JCheckBox jCheckBoxSelected = null;
    private JTextField jTextFieldNote = null;
    private JLabel jLabelVelocity = null;
    private JTextField jTextFieldVelocity = null;

    public MidiNotePanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints3.gridx = 3;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.insets = new Insets(4, 4, 4, 0);
        gridBagConstraints2.gridy = 0;
        this.jLabelVelocity = new JLabel();
        this.jLabelVelocity.setText("Velocity:");
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints1.gridx = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.setLayout(new GridBagLayout());
        this.setSize(new Dimension(310, 165));
        this.add((Component)this.getJCheckBoxSelected(), gridBagConstraints);
        this.add((Component)this.getJTextFieldNote(), gridBagConstraints1);
        this.add((Component)this.jLabelVelocity, gridBagConstraints2);
        this.add((Component)this.getJTextFieldVelocity(), gridBagConstraints3);
    }

    public int getNote() {
        return this.note;
    }

    public void setNote(int note) {
        String name;
        this.note = note;
        String text = "#" + note;
        if (this.midiFormatter != null && (name = this.midiFormatter.getNoteKeyName(note)) != null) {
            text = text + " (" + name + ")";
        }
        this.getJTextFieldNote().setText(text);
    }

    public int getVelocity() {
        return this.velocity;
    }

    public void setVelocity(int velocity) {
        this.velocity = velocity;
        this.getJTextFieldVelocity().setText(String.valueOf(velocity));
    }

    public JCheckBox getJCheckBoxSelected() {
        if (this.jCheckBoxSelected == null) {
            this.jCheckBoxSelected = new JCheckBox();
        }
        return this.jCheckBoxSelected;
    }

    private JTextField getJTextFieldNote() {
        if (this.jTextFieldNote == null) {
            this.jTextFieldNote = new JTextField();
            this.jTextFieldNote.setOpaque(false);
            this.jTextFieldNote.setEditable(false);
        }
        return this.jTextFieldNote;
    }

    private JTextField getJTextFieldVelocity() {
        if (this.jTextFieldVelocity == null) {
            this.jTextFieldVelocity = new JTextField();
            this.jTextFieldVelocity.setColumns(4);
            this.jTextFieldVelocity.setOpaque(false);
            this.jTextFieldVelocity.setEditable(false);
        }
        return this.jTextFieldVelocity;
    }

    public boolean isSelected() {
        return this.jCheckBoxSelected.isSelected();
    }

    public void setSelected(boolean selected) {
        this.jCheckBoxSelected.setSelected(selected);
    }

    public MidiFormatter getMidiFormatter() {
        return this.midiFormatter;
    }

    public void setMidiFormatter(MidiFormatter midiFormatter) {
        this.midiFormatter = midiFormatter;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }

    public MidiDevice getDevice() {
        return this.device;
    }

    public void setDevice(MidiDevice device) {
        this.device = device;
    }
}

