/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.tooling;

import com.spacekiller.util.beans.Property;
import com.spacekiller.util.collect.WeakIdentityHashMap;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolEvent;
import com.spacekiller.util.tooling.ToolListener;
import java.awt.Font;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public abstract class AbstractTool
implements Tool {
    private static Font defaultNormalFont;
    private static Font defaultPreferredFont;
    private static int defaultIconSize;
    private static int defaultRolloverIconSize;
    private String name;
    private String text;
    private String tooltip;
    private Icon icon;
    private Icon pressedIcon;
    private Icon disabledIcon;
    private Icon disabledSelectedIcon;
    private Icon rolloverIcon;
    private Icon rolloverSelectedIcon;
    private double priority;
    private boolean preferred;
    private String enabledPropertyName;
    private Font normalFont;
    private Font preferredFont;
    private WeakIdentityHashMap references;
    private List listeners = new ArrayList();

    public AbstractTool() {
        this.references = new WeakIdentityHashMap(true);
    }

    protected void addInstance(Object obj, ToolContext ctx) {
        if (obj == null) {
            return;
        }
        if (!this.references.containsKey(obj)) {
            this.references.put(obj, (Object)ctx);
        }
    }

    @Override
    public Object createInstance(ToolContext context) {
        return this.createInstance(context, null);
    }

    public Object create(Class clazz) throws InstantiationException, IllegalAccessException {
        return this.createInstance(null, clazz);
    }

    protected Iterator getInstances() {
        return this.references.keySet().iterator();
    }

    protected abstract void refreshInstance(Object var1);

    @Override
    public synchronized void refresh() {
        Iterator i = this.getInstances();
        while (i.hasNext()) {
            this.refreshInstance(i.next());
        }
    }

    protected void removeInstance(Object obj) {
        if (obj == null) {
            return;
        }
        this.references.remove(obj);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        if (this.icon == icon) {
            return;
        }
        this.icon = icon;
        this.setupIcons();
        this.refresh();
        this.fireToolChanged();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.refresh();
        this.fireToolChanged();
    }

    @Override
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.refresh();
        this.fireToolChanged();
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
        this.refresh();
        this.fireToolChanged();
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    public void setPriority(double priority) {
        if (this.priority == priority) {
            return;
        }
        this.priority = priority;
        this.refresh();
        this.fireToolChanged();
    }

    protected synchronized void fireChildrenAdded(ToolEvent ev) {
        Object[] l = this.listeners.toArray();
        for (int c = 0; c < l.length; ++c) {
            ((ToolListener)l[c]).childrenAdded(ev);
        }
    }

    protected synchronized void fireChildrenRemoved(ToolEvent ev) {
        Object[] l = this.listeners.toArray();
        for (int c = 0; c < l.length; ++c) {
            ((ToolListener)l[c]).childrenRemoved(ev);
        }
    }

    protected synchronized void fireToolChanged() {
        Object[] l = this.listeners.toArray();
        for (int c = 0; c < l.length; ++c) {
            ((ToolListener)l[c]).toolChanged(this);
        }
    }

    @Override
    public void addToolListener(ToolListener l) {
        if (l != null && !this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void removeToolListener(ToolListener l) {
        this.listeners.remove(l);
    }

    @Override
    public boolean isPreferred() {
        return this.preferred;
    }

    public void setPreferred(boolean preferred) {
        this.preferred = preferred;
        this.refresh();
        this.fireToolChanged();
    }

    @Override
    public ToolContext getToolContext(Object instance) {
        if (instance == null) {
            return null;
        }
        ToolContext ctx = (ToolContext)this.references.get(instance);
        return ctx;
    }

    @Override
    public Icon getPressedIcon() {
        return this.pressedIcon;
    }

    public void setPressedIcon(Icon pressedIcon) {
        if (this.pressedIcon == pressedIcon) {
            return;
        }
        this.pressedIcon = pressedIcon;
        this.refresh();
        this.fireToolChanged();
    }

    @Override
    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Icon rolloverIcon) {
        if (this.rolloverIcon == rolloverIcon) {
            return;
        }
        this.rolloverIcon = rolloverIcon;
        this.refresh();
        this.fireToolChanged();
    }

    @Override
    public Icon getRolloverSelectedIcon() {
        return this.rolloverSelectedIcon;
    }

    public void setRolloverSelectedIcon(Icon rolloverSelectedIcon) {
        if (this.rolloverSelectedIcon == rolloverSelectedIcon) {
            return;
        }
        this.rolloverSelectedIcon = rolloverSelectedIcon;
        this.refresh();
        this.fireToolChanged();
    }

    @Override
    public Icon getDisabledIcon() {
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon disabledIcon) {
        if (this.disabledIcon == disabledIcon) {
            return;
        }
        this.disabledIcon = disabledIcon;
        this.refresh();
        this.fireToolChanged();
    }

    @Override
    public Icon getDisabledSelectedIcon() {
        return this.disabledSelectedIcon;
    }

    public void setDisabledSelectedIcon(Icon disabledSelectedIcon) {
        if (this.disabledSelectedIcon == disabledSelectedIcon) {
            return;
        }
        this.disabledSelectedIcon = disabledSelectedIcon;
        this.refresh();
        this.fireToolChanged();
    }

    @Override
    public String getEnabledPropertyName() {
        return this.enabledPropertyName;
    }

    public void setEnabledPropertyName(String enabledPropertyName) {
        this.enabledPropertyName = enabledPropertyName;
        this.refresh();
        this.fireToolChanged();
    }

    protected void installEnabledPropertyListener(Object instance) {
        Property enabledProperty;
        ToolContext context = this.getToolContext(instance);
        if (context != null && (enabledProperty = this.getEnabledProperty(instance)) != null) {
            enabledProperty.addPropertyChangeListener((PropertyChangeListener)new PropertyChangeHandler(instance));
        }
    }

    protected Property getEnabledProperty(Object instance) {
        String enabledPropertyName;
        ToolContext context = this.getToolContext(instance);
        if (context != null && (enabledPropertyName = this.getEnabledPropertyName()) != null) {
            return context.getProperty(enabledPropertyName);
        }
        return null;
    }

    protected boolean getBooleanValue(Property property) throws Exception {
        Object value = property.getValue();
        if (value != null && value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }

    public void setNormalFont(Font normalFont) {
        if (this.normalFont == normalFont) {
            return;
        }
        this.normalFont = normalFont;
        this.refresh();
        this.fireToolChanged();
    }

    public Font getPreferredFont() {
        return this.preferredFont;
    }

    public void setPreferredFont(Font preferredFont) {
        if (this.preferredFont == preferredFont) {
            return;
        }
        this.preferredFont = preferredFont;
        this.refresh();
        this.fireToolChanged();
    }

    protected Font normalFont() {
        Font font = this.getNormalFont();
        if (font == null) {
            if (defaultNormalFont == null) {
                AbstractTool.initDefaults();
            }
            font = defaultNormalFont;
        }
        return font;
    }

    protected Font preferredFont() {
        Font font = this.getPreferredFont();
        if (font == null) {
            if (defaultPreferredFont == null) {
                AbstractTool.initDefaults();
            }
            font = defaultPreferredFont;
        }
        return font;
    }

    static final void initDefaults() {
        JLabel dummyLabel = new JLabel();
        Font dummyFont = dummyLabel.getFont();
        if (dummyFont == null) {
            dummyFont = new Font("dialog", 0, 12);
        }
        defaultNormalFont = new Font(dummyFont.getName(), 0, dummyFont.getSize());
        defaultPreferredFont = new Font(dummyFont.getName(), 1, dummyFont.getSize());
        defaultIconSize = defaultNormalFont.getSize();
        defaultRolloverIconSize = defaultIconSize * 4 / 3;
    }

    protected void setupIcons() {
        Icon icon = this.icon;
        if (icon == null) {
            return;
        }
        ImageIcon imageIcon = null;
        if (icon instanceof ImageIcon) {
            imageIcon = (ImageIcon)icon;
        }
        if (imageIcon == null) {
            return;
        }
        Image image = imageIcon.getImage();
        if (image == null) {
            return;
        }
        int prefWidth = defaultIconSize;
        int prefHeight = defaultIconSize;
        int hints = 4;
        Image scaled = image.getScaledInstance(prefWidth, prefHeight, hints);
        if (scaled == null) {
            return;
        }
        this.icon = new ImageIcon(scaled);
        if (this.rolloverIcon == null) {
            prefWidth = defaultRolloverIconSize;
            prefHeight = defaultRolloverIconSize;
            Image rollover = image.getScaledInstance(prefWidth, prefHeight, hints);
            if (rollover == null) {
                rollover = scaled;
            }
            if (rollover != scaled) {
                this.rolloverIcon = new ImageIcon(rollover);
            }
        }
    }

    static {
        defaultIconSize = 20;
        defaultRolloverIconSize = 24;
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        private Object instance;

        public PropertyChangeHandler(Object instance) {
            this.instance = instance;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            AbstractTool.this.refreshInstance(this.instance);
        }
    }
}

