/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.tooling;

import com.spacekiller.util.tooling.AbstractTool;
import com.spacekiller.util.tooling.Tool;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolEvent;
import com.spacekiller.util.tooling.ToolGroup;
import com.spacekiller.util.tooling.ToolListener;
import java.awt.Component;
import java.awt.Container;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;

public abstract class AbstractToolGroup
extends AbstractTool
implements ToolGroup {
    private Vector children = new Vector();
    private GroupMembershipHandler groupMembershipHandler = new GroupMembershipHandler();
    private static final Logger logger = Logger.getLogger(AbstractToolGroup.class.getName());

    public AbstractToolGroup() {
        this.initGroup();
    }

    @Override
    public synchronized void addChild(Tool child) {
        double prio = child.getPriority();
        int count = this.getChildCount();
        int index = -1;
        for (int c = 0; c < count; ++c) {
            Tool t = (Tool)this.children.get(c);
            if (!(prio > t.getPriority())) continue;
            index = c;
            break;
        }
        if (index < 0) {
            index = count;
        }
        this.insertChildAt(child, index);
    }

    @Override
    public Tool getChildAt(int i) {
        return (Tool)this.children.elementAt(i);
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    @Override
    public int getIndex(Tool info) {
        return this.children == null ? -1 : this.children.indexOf(info);
    }

    protected abstract void handleChildrenAdded(ToolEvent var1);

    protected abstract void handleChildrenRemoved(ToolEvent var1);

    protected void handleContainerChildrenAdded(ToolEvent ev, Class childType) {
        Iterator i = this.getInstances();
        while (i.hasNext()) {
            Container cont = (Container)i.next();
            if (cont == null) continue;
            ToolContext ctx = this.getToolContext(cont);
            int count = ev.getChildCount();
            if (count <= 0) continue;
            for (int j = 0; j < count; ++j) {
                Object obj = ev.getChild(j).createInstance(ctx, childType);
                if (!(obj instanceof Component)) continue;
                Component cc = (Component)obj;
                if (cc == null) {
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("OOPS, no component available for tool!");
                    logger.fine(" - Tool=" + ev.getChild(j));
                    logger.fine(" - Type=" + childType);
                    continue;
                }
                int index = ev.getChildIndex(j);
                cont.add(cc, index);
            }
            cont.validate();
            cont.repaint();
        }
    }

    protected void handleContainerChildrenRemoved(ToolEvent ev) {
        Iterator i = this.getInstances();
        while (i.hasNext()) {
            int count;
            Container cont = (Container)i.next();
            if (cont == null || (count = ev.getChildCount()) <= 0) continue;
            for (int j = count - 1; j >= 0; --j) {
                int x = ev.getChildIndex(j);
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Removing item: index=" + x + " / " + count);
                }
                cont.remove(x);
            }
            cont.validate();
            cont.repaint();
        }
    }

    protected void initGroup() {
        this.addToolListener(this.groupMembershipHandler);
    }

    protected synchronized void insertChildAt(Tool child, int index) {
        if (child == null) {
            return;
        }
        this.children.insertElementAt(child, index);
        this.fireChildrenAdded(new ToolEvent(this, new Tool[]{child}, new int[]{index}));
    }

    protected void installContainerChildren(Container container, Class childType) {
        int count = this.getChildCount();
        ToolContext ctx = this.getToolContext(container);
        for (int c = 0; c < count; ++c) {
            Tool tool = this.getChildAt(c);
            Object obj = tool.createInstance(ctx, childType);
            Component comp = null;
            if (obj instanceof Component) {
                comp = (Component)obj;
            }
            if (comp != null) {
                container.add(comp, c);
                continue;
            }
            logger.fine("Warning: No component available: tool=" + this.getChildAt(c) + ", type=" + childType);
            JPanel dummy = new JPanel();
            dummy.setOpaque(false);
            container.add((Component)dummy, c);
        }
    }

    public synchronized void removeAll() {
        int count = this.getChildCount();
        for (int c = count - 1; c >= 0; --c) {
            this.removeChildAt(c);
        }
    }

    @Override
    public synchronized void removeChild(Tool child) {
        int index = this.children.indexOf(child);
        if (index >= 0) {
            this.removeChild(child, index);
        }
    }

    public synchronized void removeChild(Tool child, int index) {
        this.children.removeElementAt(index);
        this.fireChildrenRemoved(new ToolEvent(this, new Tool[]{child}, new int[]{index}));
    }

    @Override
    public synchronized void removeChildAt(int index) {
        this.removeChild((Tool)this.children.get(index), index);
    }

    @Override
    public synchronized void refresh() {
        super.refresh();
        int num = this.getChildCount();
        for (int i = 0; i < num; ++i) {
            this.getChildAt(i).refresh();
        }
    }

    public class GroupMembershipHandler
    implements ToolListener {
        @Override
        public void childrenAdded(ToolEvent ev) {
            AbstractToolGroup.this.handleChildrenAdded(ev);
        }

        @Override
        public void childrenRemoved(ToolEvent ev) {
            AbstractToolGroup.this.handleChildrenRemoved(ev);
        }

        @Override
        public void toolChanged(Tool tool) {
        }
    }
}

