/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.tooling;

import com.spacekiller.util.tooling.AbstractToolGroup;
import com.spacekiller.util.tooling.ToolContext;
import com.spacekiller.util.tooling.ToolEvent;
import java.awt.Insets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class TToolBar
extends AbstractToolGroup {
    private static final Logger logger = Logger.getLogger(TToolBar.class.getName());

    @Override
    public Object createInstance(ToolContext context, Class type) {
        if (type != null && !type.isAssignableFrom(JToolBar.class)) {
            return null;
        }
        JToolBar rc = this.createJToolBar();
        rc.setFloatable(false);
        this.addInstance(rc, context);
        this.refreshInstance(rc);
        this.installContainerChildren(rc, JButton.class);
        return rc;
    }

    protected JToolBar createJToolBar() {
        JToolBar tb = new JToolBar();
        tb.setMargin(new Insets(2, 2, 0, 1));
        return tb;
    }

    @Override
    protected void handleChildrenAdded(ToolEvent ev) {
        super.handleContainerChildrenAdded(ev, JButton.class);
    }

    @Override
    protected void handleChildrenRemoved(ToolEvent ev) {
        super.handleContainerChildrenRemoved(ev);
    }

    @Override
    protected void refreshInstance(Object c) {
        JToolBar m = (JToolBar)c;
        try {
            String name = this.getName();
            String tooltip = this.getTooltip();
            m.setName(name);
            m.setToolTipText(tooltip);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

