/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.mp4;

import com.spacekiller.util.Tools;
import com.spacekiller.util.format.AbstractFileFormat;
import com.spacekiller.util.format.FileFormat;
import com.spacekiller.util.format.FileFormatSignature;
import com.spacekiller.util.format.SimpleFileFormatSignature;
import com.spacekiller.util.media.MediaFileFormat;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.mp4.Mp4MediaScanner;

public class Mp4MediaFileFormat
extends AbstractFileFormat
implements MediaFileFormat {
    public static final String FORMAT_NAME = "MP4";
    private static final int SUPPORTED_MEDIA_FLAGS = 3;
    private static final String DEFAULT_FILE_EXTENSION = ".mp4";
    private static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{".mp4", ".m4a", ".aac"};
    private static final String FILE_FORMAT_TITLE = "MP4 Media File";
    private SimpleFileFormatSignature mp4FileSignature;
    private MediaScanner mediaScanner;

    public Mp4MediaFileFormat() {
        super(FORMAT_NAME);
        this.initMediaFileFormat();
    }

    protected void initMediaFileFormat() {
        this.setFormatTitle(FILE_FORMAT_TITLE);
        this.setDefaultFormatIcon(Tools.getIcon(((Object)((Object)this)).getClass(), (String)"/com/spacekiller/util/media/mp4/icons/mp4_format.png"));
        this.setDefaultExtension(DEFAULT_FILE_EXTENSION);
        this.setSupportedExtensions(SUPPORTED_FILE_EXTENSIONS);
        this.mp4FileSignature = new SimpleFileFormatSignature("MP4 Header", (FileFormat)this, 4, new byte[]{102, 116, 121, 112});
        this.setSupportedSignatures(new FileFormatSignature[]{this.mp4FileSignature});
    }

    public int getSupportedMediaFlags() {
        return 3;
    }

    public MediaScanner getMediaScanner() {
        if (this.mediaScanner == null) {
            this.mediaScanner = new Mp4MediaScanner();
        }
        return this.mediaScanner;
    }
}

