/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.media.mp4;

import com.spacekiller.util.Resource;
import com.spacekiller.util.media.AudioEntry;
import com.spacekiller.util.media.DefaultAudioEntry;
import com.spacekiller.util.media.DefaultMediaEntry;
import com.spacekiller.util.media.MediaEntry;
import com.spacekiller.util.media.MediaMarker;
import com.spacekiller.util.media.MediaScanner;
import com.spacekiller.util.media.MutableAudioEntry;
import com.spacekiller.util.media.MutableMediaEntry;
import com.spacekiller.util.media.library.serato.Base64Decoder;
import com.spacekiller.util.media.library.serato.SeratoAutotags;
import com.spacekiller.util.media.library.serato.SeratoMarkers2;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.sourceforge.jaad.mp4.MP4Container;
import net.sourceforge.jaad.mp4.boxes.Box;
import net.sourceforge.jaad.mp4.boxes.impl.meta.GenreBox;
import net.sourceforge.jaad.mp4.boxes.impl.meta.ITunesMetadataBox;

public class Mp4MediaScanner
implements MediaScanner {
    public static final String FORMAT_MP4 = "MP4";
    public static final long DEFAULT_MAX_FILE_SIZE = 0x6400000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaEntry scanMediaResource(Resource resource, MediaEntry me) throws IOException {
        Object mme = me != null && me instanceof MutableMediaEntry ? (MutableMediaEntry)me : new DefaultMediaEntry();
        AudioEntry ae = mme.getAudioEntry();
        Object mae = ae != null && ae instanceof MutableAudioEntry ? (MutableAudioEntry)ae : new DefaultAudioEntry();
        mme.setAudioEntry((AudioEntry)mae);
        mme.setResource(resource);
        InputStream in = resource.createInputStream();
        try {
            MP4Container mp4Container = new MP4Container(in);
            List boxes = mp4Container.getBoxes();
            if (boxes == null) {
                MediaEntry mediaEntry = null;
                return mediaEntry;
            }
            mme.setFormat(FORMAT_MP4);
            for (Box box : boxes) {
                this.parseMp4Box(box, (MutableMediaEntry)mme, (MutableAudioEntry)mae);
            }
        }
        finally {
            in.close();
        }
        return mme;
    }

    protected void dumpMp4Box(Box box, String indent) {
        List children;
        System.out.println(indent + "- Box: name=" + box.getName() + ", size=" + box.getSize() + ", type=" + box.getType() + ", class=" + box.getClass().getName());
        if (box instanceof ITunesMetadataBox) {
            ITunesMetadataBox meta = (ITunesMetadataBox)box;
            String text = meta.getText();
            System.out.println("Text: " + text);
        }
        if (!(children = box.getChildren()).isEmpty()) {
            indent = indent + "  ";
            for (Box child : children) {
                this.dumpMp4Box(child, indent);
            }
        }
    }

    protected void parseMp4Box(Box box, MutableMediaEntry mme, MutableAudioEntry mae) throws IOException {
        String text;
        long type = box.getType();
        if (type == 1953655662L) {
            // empty if block
        }
        if (type == 2842583405L && (text = this.parseMp4TextBox(box)) != null) {
            mme.setTitle(text);
        }
        if (type == 2841734242L && (text = this.parseMp4TextBox(box)) != null) {
            mme.setAlbum(text);
        }
        if (type == 2839630420L && (text = this.parseMp4TextBox(box)) != null) {
            mme.setArtist(text);
        }
        if (type != 1735291493L || box instanceof GenreBox) {
            // empty if block
        }
        if (type == 2842125678L && (text = this.parseMp4TextBox(box)) != null) {
            mme.setGenre(text);
        }
        if (type == 1668249202L) {
            // empty if block
        }
        if (type == 0x2D2D2D2DL && (text = this.parseMp4TextBox(box)) != null && text.startsWith("YXB")) {
            this.parseSeratoBox(text, mme, mae);
        }
        List children = box.getChildren();
        for (Box child : children) {
            this.parseMp4Box(child, mme, mae);
        }
    }

    protected String parseMp4TextBox(Box box) {
        List children = box.getChildren();
        for (Box child : children) {
            ITunesMetadataBox meta;
            String text;
            if (!(child instanceof ITunesMetadataBox) || (text = (meta = (ITunesMetadataBox)child).getText()) == null) continue;
            return text;
        }
        return null;
    }

    protected Long parseMp4NumberBox(Box box) {
        List children = box.getChildren();
        for (Box child : children) {
            if (!(child instanceof ITunesMetadataBox)) continue;
            ITunesMetadataBox meta = (ITunesMetadataBox)child;
            System.out.println("dataType: " + meta.getDataType());
            System.out.println("size: " + meta.getSize());
            System.out.println("data: " + new String(meta.getData()));
            return new Long(meta.getInteger());
        }
        return null;
    }

    protected void parseSeratoBox(String base64Text, MutableMediaEntry mme, MutableAudioEntry mae) {
        try {
            byte[] autoTagsData;
            double bpm;
            byte[] enc;
            byte[] dec;
            int testSize = Math.min(60, base64Text.length());
            String testText = base64Text.substring(0, testSize);
            byte[] testEnc = testText.getBytes();
            byte[] testDec = Base64Decoder.decodeBase64((byte[])testEnc, (int)0, (int)testEnc.length);
            testText = new String(testDec);
            int x = testText.indexOf("Serato Markers2");
            if (x >= 0) {
                byte[] enc2 = base64Text.getBytes();
                byte[] dec2 = Base64Decoder.decodeBase64((byte[])enc2, (int)0, (int)enc2.length);
                testText = new String(dec2);
                x = testText.indexOf("Serato Markers2");
                if (x >= 0) {
                    byte[] base64Input = testText.substring(x + "Serato Markers2".length()).getBytes();
                    MediaMarker[] seratoMarkers = SeratoMarkers2.parseSeratoMarkers((byte[])base64Input);
                    SeratoMarkers2.updateMediaEntrySeratoMarkers((MutableMediaEntry)mme, (MediaMarker[])seratoMarkers);
                }
                return;
            }
            x = testText.indexOf("Serato Autotags");
            if (x >= 0 && (x = (testText = new String(dec = Base64Decoder.decodeBase64((byte[])(enc = base64Text.getBytes()), (int)0, (int)enc.length))).indexOf("Serato Autotags")) >= 0 && !Double.isNaN(bpm = SeratoAutotags.parseSeratoBPM((byte[])(autoTagsData = testText.substring(x + "Serato Autotags".length()).getBytes())))) {
                mae.setBpmStored(bpm);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

