/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.crypto;

import com.spacekiller.util.crypto.CipherStub;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.util.Random;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class CipherStubPbeMd5TripleDes
implements CipherStub {
    private static final String algorithm = "PBEWithMD5AndTripleDES";
    private static final String descr = "PBEWithMD5AndTripleDES (128bit)";
    private Random random = new Random();
    private static final Logger logger = Logger.getLogger(CipherStubPbeMd5TripleDes.class.getName());

    private final Cipher getCipher(int mode, byte[] salt, int iterationCount, char[] passphrase) throws Exception {
        PBEKeySpec keySpec = new PBEKeySpec(passphrase);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
        logger.fine("SecretKeyFactory.algorithm: " + factory.getAlgorithm());
        SecretKey key = factory.generateSecret(keySpec);
        logger.fine("SecretKey.algorithm: " + key.getAlgorithm());
        logger.fine("Encoded-Key-Length: " + key.getEncoded().length);
        Cipher cipher = Cipher.getInstance("TripleDES");
        logger.fine("Cipher.algorithm: " + cipher.getAlgorithm());
        PBEParameterSpec paramSpec = new PBEParameterSpec(salt, iterationCount);
        cipher.init(mode, (Key)key, paramSpec);
        return cipher;
    }

    @Override
    public final InputStream getCipherInputStream(InputStream stream, Object object) throws Exception {
        char[] phrase = null;
        try {
            phrase = (char[])object;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid arguments");
        }
        DataInputStream data = new DataInputStream(stream);
        int iterations = data.readInt();
        int saltLen = data.readInt();
        byte[] salt = new byte[saltLen];
        data.read(salt);
        return new CipherInputStream(data, this.getCipher(2, salt, iterations, phrase));
    }

    @Override
    public final OutputStream getCipherOutputStream(OutputStream stream, Object object) throws Exception {
        char[] phrase = null;
        try {
            phrase = (char[])object;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Invalid arguments");
        }
        DataOutputStream data = new DataOutputStream(stream);
        byte[] salt = this.getSalt(8);
        int iterations = this.getRandom(10000, 20000);
        data.writeInt(iterations);
        data.writeInt(salt.length);
        data.write(salt);
        data.flush();
        return new CipherOutputStream(stream, this.getCipher(1, salt, iterations, phrase));
    }

    @Override
    public String getDescription() {
        return descr;
    }

    @Override
    public String getName() {
        return algorithm;
    }

    private final int getRandom(int min, int max) {
        double delta = max - min;
        return min + (int)(this.random.nextDouble() * delta);
    }

    private final byte[] getSalt(int size) {
        byte[] salt = new byte[size];
        this.random.nextBytes(salt);
        return salt;
    }

    public String toString() {
        return this.getName();
    }
}

