/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.crypto;

import com.spacekiller.util.buffer.Base64Util;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;

public final class CryptoTools {
    private CryptoTools() {
    }

    public static InputStream getCipherInputStream(String base64, Key key) throws Exception {
        byte[] data = Base64Util.getDecoder().decode(base64);
        return CryptoTools.getCipherInputStream(data, key);
    }

    public static InputStream getCipherInputStream(byte[] data, Key key) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        return CryptoTools.getCipherInputStream(bin, key);
    }

    public static InputStream getCipherInputStream(InputStream in, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(2, key);
        CipherInputStream cin = new CipherInputStream(in, cipher);
        return cin;
    }

    public static OutputStream getCipherOutputStream(OutputStream out, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(key.getAlgorithm());
        cipher.init(1, key);
        return new CipherOutputStream(out, cipher);
    }
}

