/*
 * Decompiled with CFR 0.152.
 */
package com.spacekiller.util.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public final class EncryptedData
implements Serializable {
    private static final long serialVersionUID = 6789244092834274954L;
    private static final byte VERSION = 1;
    private transient byte version = 1;
    private transient byte[] data;

    public EncryptedData(byte[] encryptedData, int dataOfs, int dataLen) {
        this.data = new byte[dataLen];
        System.arraycopy(encryptedData, dataOfs, this.data, 0, dataLen);
    }

    public EncryptedData(byte[] encryptedData) {
        this(encryptedData, 0, encryptedData.length);
    }

    public int getDataLength() {
        return this.data.length;
    }

    public byte[] getData() {
        byte[] ret = new byte[this.data.length];
        System.arraycopy(this.data, 0, ret, 0, ret.length);
        return ret;
    }

    public void copyTo(byte[] dst, int off) {
        System.arraycopy(this.data, 0, dst, off, this.data.length);
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.version != 1) {
            throw new UnsupportedOperationException("Unsupported version: " + this.version);
        }
        out.writeByte(this.version);
        out.writeInt(this.data.length);
        out.write(this.data);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.version = in.readByte();
        if (this.version != 1) {
            throw new UnsupportedOperationException("Unsupported version: " + this.version);
        }
        int dataLen = in.readInt();
        this.data = new byte[dataLen];
        in.readFully(this.data);
    }

    protected void finalize() throws Throwable {
        this.clear();
    }

    private void clear() {
        if (this.data != null) {
            Arrays.fill(this.data, (byte)-1);
            this.data = null;
        }
    }
}

