/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.FaderConfig;
import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.impl.AbstractFaderCurve;
import com.waxmonster.fader.impl.FaderCurveUtil;
import java.io.Serializable;

public abstract class AbstractFaderConfig
implements FaderConfig,
Serializable,
Cloneable {
    private static final long serialVersionUID = 4644459274010920551L;
    public static final String TYPENAME_UNSPECIFIED = "<null>";
    public static final String TYPENAME_LINE_FADER = "Line-Fader";
    public static final String TYPENAME_CROSS_FADER_LEFT_DECK = "Cross-Fader (Left Deck)";
    public static final String TYPENAME_CROSS_FADER_RIGHT_DECK = "Cross-Fader (Right Deck)";
    public static final String TYPENAME_BALANCE_FADER_LEFT_CHANNEL = "Balance-Fader (Left Channel)";
    public static final String TYPENAME_BALANCE_FADER_RIGHT_CHANNEL = "Balance-Fader (Right Channel)";
    private transient Object runtimeId;
    private String faderName;
    private int faderType;
    private boolean faderEnabled = true;
    private int channelMask;
    private boolean reverseMode;
    private float initValue = 0.5f;
    private FaderCurve faderCurve = FaderCurveUtil.createDefaultFaderCurve("New Fader Curve", false);

    public static int[] getFaderTypes() {
        return new int[]{0, 1, 2, 3, 4};
    }

    public static String getFaderTypeName(int faderType) {
        switch (faderType) {
            case -1: {
                return TYPENAME_UNSPECIFIED;
            }
            case 0: {
                return TYPENAME_LINE_FADER;
            }
            case 1: {
                return TYPENAME_CROSS_FADER_LEFT_DECK;
            }
            case 2: {
                return TYPENAME_CROSS_FADER_RIGHT_DECK;
            }
            case 3: {
                return TYPENAME_BALANCE_FADER_LEFT_CHANNEL;
            }
            case 4: {
                return TYPENAME_BALANCE_FADER_RIGHT_CHANNEL;
            }
        }
        return "FaderType#" + faderType;
    }

    public static int getFaderType(Object faderTypeName) {
        String s = String.valueOf(faderTypeName);
        if (TYPENAME_LINE_FADER.equalsIgnoreCase(s)) {
            return 0;
        }
        if (TYPENAME_CROSS_FADER_LEFT_DECK.equalsIgnoreCase(s)) {
            return 1;
        }
        if (TYPENAME_CROSS_FADER_RIGHT_DECK.equalsIgnoreCase(s)) {
            return 2;
        }
        if (TYPENAME_BALANCE_FADER_LEFT_CHANNEL.equalsIgnoreCase(s)) {
            return 3;
        }
        if (TYPENAME_BALANCE_FADER_RIGHT_CHANNEL.equalsIgnoreCase(s)) {
            return 4;
        }
        return -1;
    }

    public FaderConfig cloneFaderConfig() throws CloneNotSupportedException {
        AbstractFaderConfig clone = (AbstractFaderConfig)super.clone();
        clone.runtimeId = this.runtimeId;
        FaderCurve curve = this.faderCurve;
        if (curve != null) {
            if (curve instanceof AbstractFaderCurve) {
                AbstractFaderCurve afc = (AbstractFaderCurve)curve;
                curve = afc.cloneFaderCurve();
            } else {
                String curveStr = FaderCurveUtil.formatFaderCurve(curve);
                curve = FaderCurveUtil.parseFaderCurve(curveStr);
            }
            clone.setFaderCurve(curve);
        }
        return clone;
    }

    public Object getRuntimeId() {
        return this.runtimeId;
    }

    public void setRuntimeId(Object runtimeId) {
        this.runtimeId = runtimeId;
    }

    public String getFaderName() {
        return this.faderName;
    }

    public void setFaderName(String faderName) {
        this.faderName = faderName;
    }

    public int getFaderType() {
        return this.faderType;
    }

    public void setFaderType(int faderType) {
        this.faderType = faderType;
    }

    public boolean isFaderEnabled() {
        return this.faderEnabled;
    }

    public void setFaderEnabled(boolean faderEnabled) {
        this.faderEnabled = faderEnabled;
    }

    public int getChannelMask() {
        return this.channelMask;
    }

    public void setChannelMask(int channelMask) {
        this.channelMask = channelMask;
    }

    public boolean isReverseMode() {
        return this.reverseMode;
    }

    public void setReverseMode(boolean reverseMode) {
        this.reverseMode = reverseMode;
    }

    public float getInitValue() {
        return this.initValue;
    }

    public void setInitValue(float initValue) {
        this.initValue = initValue;
    }

    public FaderCurve getFaderCurve() {
        return this.faderCurve;
    }

    public void setFaderCurve(FaderCurve faderCurve) {
        this.faderCurve = faderCurve;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFaderConfig other = (AbstractFaderConfig)obj;
        if (this.channelMask != other.channelMask) {
            return false;
        }
        if (this.faderCurve == null ? other.faderCurve != null : !this.faderCurve.equals(other.faderCurve)) {
            return false;
        }
        if (this.faderEnabled != other.faderEnabled) {
            return false;
        }
        if (this.faderName == null ? other.faderName != null : !this.faderName.equals(other.faderName)) {
            return false;
        }
        if (this.faderType != other.faderType) {
            return false;
        }
        if (Float.floatToIntBits(this.initValue) != Float.floatToIntBits(other.initValue)) {
            return false;
        }
        return this.reverseMode == other.reverseMode;
    }
}

