/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.FaderCurve;
import java.io.Serializable;

public abstract class AbstractFaderCurve
implements FaderCurve,
Serializable,
Cloneable {
    private static final long serialVersionUID = -5608881859467583860L;
    private String name;
    private float cutIn = 0.0f;
    private float decay = 1.0f;
    private float divisor;

    public AbstractFaderCurve() {
        this.adjustDivisor();
    }

    public float getVolume(float pos) {
        if (pos < this.cutIn) {
            return 0.0f;
        }
        if (pos > this.decay) {
            return 1.0f;
        }
        return this.getVolumeImpl((pos - this.cutIn) / this.divisor);
    }

    protected abstract float getVolumeImpl(float var1);

    public float getCutIn() {
        return this.cutIn;
    }

    public void setCutIn(float cutIn) {
        this.cutIn = cutIn;
        this.adjustDivisor();
    }

    public float getDecay() {
        return this.decay;
    }

    public void setDecay(float decay) {
        this.decay = decay;
        this.adjustDivisor();
    }

    protected void adjustDivisor() {
        this.divisor = this.decay - this.cutIn;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", cutIn=" + this.cutIn + ", decay=" + this.decay + "]";
    }

    public FaderCurve cloneFaderCurve() throws CloneNotSupportedException {
        return (FaderCurve)super.clone();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFaderCurve other = (AbstractFaderCurve)obj;
        if (Float.floatToIntBits(this.cutIn) != Float.floatToIntBits(other.cutIn)) {
            return false;
        }
        if (Float.floatToIntBits(this.decay) != Float.floatToIntBits(other.decay)) {
            return false;
        }
        if (Float.floatToIntBits(this.divisor) != Float.floatToIntBits(other.divisor)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

