/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.impl.AbstractFaderCurve;
import java.util.Arrays;

public class ArrayFaderCurve
extends AbstractFaderCurve {
    private static final long serialVersionUID = -7626197177091053789L;
    private final float[] array;
    private final int num;

    public ArrayFaderCurve(float[] array) {
        this.array = array;
        this.num = array.length - 1;
    }

    public ArrayFaderCurve(FaderCurve curve, int length) {
        this.array = new float[length];
        this.num = this.array.length - 1;
        if (length > 0) {
            for (int i = 0; i < this.num; ++i) {
                this.array[i] = curve.getVolume((float)i / (float)this.num);
            }
            this.array[this.num] = curve.getVolume(1.0f);
        }
    }

    @Override
    protected float getVolumeImpl(float value) {
        float p = value * (float)this.num;
        int i = (int)p;
        if (i < 0) {
            return this.array[0];
        }
        if (i >= this.num) {
            return this.array[this.num];
        }
        float f = p - (float)i;
        return this.array[i] * (1.0f - f) + this.array[i + 1] * f;
    }

    public int getArrayLength() {
        return this.array.length;
    }

    public void getArrayValues(float[] dst, int index, int length) {
        System.arraycopy(this.array, 0, dst, index, length);
    }

    @Override
    public String toString() {
        return super.toString() + "[length=" + this.array.length + "]";
    }

    @Override
    public FaderCurve cloneFaderCurve() throws CloneNotSupportedException {
        return this.cloneArrayFaderCurve();
    }

    public ArrayFaderCurve cloneArrayFaderCurve() {
        float[] arr = new float[this.array.length];
        System.arraycopy(this.array, 0, arr, 0, this.array.length);
        ArrayFaderCurve clone = new ArrayFaderCurve(arr);
        clone.setName(this.getName());
        clone.setCutIn(this.getCutIn());
        clone.setDecay(this.getDecay());
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayFaderCurve other = (ArrayFaderCurve)obj;
        if (!Arrays.equals(this.array, other.array)) {
            return false;
        }
        return this.num == other.num;
    }
}

