/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.impl.ArrayFaderCurve;
import com.waxmonster.fader.impl.CommonFaderCurveCustomizer;
import com.waxmonster.fader.impl.FaderCurveEditor;
import com.waxmonster.fader.impl.FaderCurveUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ArrayFaderCurveCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = -5657343460805970005L;
    private static final String PROPERTY_ARRAY = "array";
    private FaderCurveEditor faderCurveEditor;
    private ArrayFaderCurve arrayFaderCurve;
    private boolean refreshing = false;
    private boolean applying = false;
    private CommonFaderCurveCustomizer commonFaderCurveCustomizer;
    private JTextArea textAreaArray;

    public ArrayFaderCurveCustomizer() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.commonFaderCurveCustomizer = new CommonFaderCurveCustomizer();
        this.commonFaderCurveCustomizer.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ArrayFaderCurveCustomizer.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        GridBagConstraints gbc_commonFaderCurveCustomizer = new GridBagConstraints();
        gbc_commonFaderCurveCustomizer.insets = new Insets(0, 0, 5, 0);
        gbc_commonFaderCurveCustomizer.weightx = 1.0;
        gbc_commonFaderCurveCustomizer.fill = 1;
        gbc_commonFaderCurveCustomizer.gridx = 0;
        gbc_commonFaderCurveCustomizer.gridy = 0;
        this.add((Component)this.commonFaderCurveCustomizer, gbc_commonFaderCurveCustomizer);
        JPanel panelArrayCurve = new JPanel();
        GridBagConstraints gbc_panelArrayCurve = new GridBagConstraints();
        gbc_panelArrayCurve.weighty = 1.0;
        gbc_panelArrayCurve.weightx = 1.0;
        gbc_panelArrayCurve.fill = 1;
        gbc_panelArrayCurve.gridx = 0;
        gbc_panelArrayCurve.gridy = 1;
        this.add((Component)panelArrayCurve, gbc_panelArrayCurve);
        GridBagLayout gbl_panelArrayCurve = new GridBagLayout();
        gbl_panelArrayCurve.columnWidths = new int[]{0, 0, 0};
        gbl_panelArrayCurve.rowHeights = new int[]{0, 0};
        gbl_panelArrayCurve.columnWeights = new double[]{0.0, 0.0, Double.MIN_VALUE};
        gbl_panelArrayCurve.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panelArrayCurve.setLayout(gbl_panelArrayCurve);
        JLabel lblArray = new JLabel("Array:");
        GridBagConstraints gbc_lblArray = new GridBagConstraints();
        gbc_lblArray.anchor = 18;
        gbc_lblArray.insets = new Insets(4, 4, 4, 5);
        gbc_lblArray.gridx = 0;
        gbc_lblArray.gridy = 0;
        panelArrayCurve.add((Component)lblArray, gbc_lblArray);
        JScrollPane scrollPaneArray = new JScrollPane();
        GridBagConstraints gbc_scrollPaneArray = new GridBagConstraints();
        gbc_scrollPaneArray.weighty = 1.0;
        gbc_scrollPaneArray.weightx = 1.0;
        gbc_scrollPaneArray.insets = new Insets(4, 0, 4, 4);
        gbc_scrollPaneArray.fill = 1;
        gbc_scrollPaneArray.gridx = 1;
        gbc_scrollPaneArray.gridy = 0;
        panelArrayCurve.add((Component)scrollPaneArray, gbc_scrollPaneArray);
        this.textAreaArray = new JTextArea();
        this.textAreaArray.setLineWrap(true);
        scrollPaneArray.setViewportView(this.textAreaArray);
        this.textAreaArray.setOpaque(false);
        this.initArrayFaderCurveCustomizer();
    }

    public ArrayFaderCurve getArrayFaderCurve() {
        return this.arrayFaderCurve;
    }

    public void setArrayFaderCurve(ArrayFaderCurve arrayFaderCurve) {
        if (this.applying) {
            return;
        }
        this.arrayFaderCurve = arrayFaderCurve;
        this.commonFaderCurveCustomizer.setFaderCurve(arrayFaderCurve);
        this.refresh();
    }

    @Override
    public void setObject(Object bean) {
        this.setArrayFaderCurve((ArrayFaderCurve)bean);
    }

    protected void initArrayFaderCurveCustomizer() {
        this.textAreaArray.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!ArrayFaderCurveCustomizer.this.refreshing) {
                    ArrayFaderCurveCustomizer.this.applyArray();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!ArrayFaderCurveCustomizer.this.refreshing) {
                    ArrayFaderCurveCustomizer.this.applyArray();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!ArrayFaderCurveCustomizer.this.refreshing) {
                    ArrayFaderCurveCustomizer.this.applyArray();
                }
            }
        });
        this.commonFaderCurveCustomizer.setMinimumCutIn(0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            int len;
            this.refreshing = true;
            String text = null;
            ArrayFaderCurve curve = this.arrayFaderCurve;
            if (curve != null && (len = curve.getArrayLength()) > 0) {
                float[] arr = new float[len];
                curve.getArrayValues(arr, 0, len);
                text = FaderCurveUtil.formatFloatArray(arr, " : ");
            }
            if (text == null) {
                text = "";
            }
            this.textAreaArray.setText(text);
        }
        finally {
            this.refreshing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void applyArray() {
        FaderCurveEditor editor = this.faderCurveEditor;
        if (editor == null) {
            return;
        }
        ArrayFaderCurve oldCurve = this.arrayFaderCurve;
        String text = this.textAreaArray.getText();
        float[] array = FaderCurveUtil.parseFloatArray(text, " :  ,;:/|\\\t\r\n");
        if (array.length < 1) {
            return;
        }
        this.arrayFaderCurve = new ArrayFaderCurve(array);
        if (oldCurve != null) {
            this.arrayFaderCurve.setName(oldCurve.getName());
            this.arrayFaderCurve.setCutIn(oldCurve.getCutIn());
            this.arrayFaderCurve.setDecay(oldCurve.getDecay());
        }
        this.commonFaderCurveCustomizer.setFaderCurve(this.arrayFaderCurve);
        try {
            this.applying = true;
            boolean refresh = false;
            editor.setFaderCurve(this.arrayFaderCurve, refresh);
        }
        finally {
            this.applying = false;
        }
        this.firePropertyChange(PROPERTY_ARRAY, null, array);
    }

    protected CommonFaderCurveCustomizer getCommonFaderCurveCustomizer() {
        return this.commonFaderCurveCustomizer;
    }

    protected JTextArea getTextAreaArray() {
        return this.textAreaArray;
    }

    public FaderCurveEditor getFaderCurveEditor() {
        return this.faderCurveEditor;
    }

    public void setFaderCurveEditor(FaderCurveEditor faderCurveEditor) {
        this.faderCurveEditor = faderCurveEditor;
    }
}

