/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ChannelMaskEditor
extends JPanel
implements PropertyEditor {
    private static final long serialVersionUID = -9049327106972285618L;
    private static final String PROPERTY_CHANNEL_MASK = "channelMask";
    private final BoxHandler boxHandler = new BoxHandler();
    private int channelMask;
    private int channelCount;
    private String[] channelNames;
    private String[] channelTips;
    private boolean refreshing;
    private JCheckBox[] checkboxes;
    private boolean boxesValid;
    private Insets boxInsets = new Insets(0, 0, 0, 4);

    public ChannelMaskEditor() {
        this.setLayout(new GridBagLayout());
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public void setChannelCount(int channelCount) {
        if (channelCount < 0) {
            channelCount = 0;
        }
        if (this.channelCount == channelCount) {
            return;
        }
        this.channelCount = channelCount;
        this.boxesValid = false;
        this.refresh();
    }

    public String[] getChannelNames() {
        return this.channelNames;
    }

    public void setChannelNames(String[] channelNames) {
        this.channelNames = channelNames;
        this.boxesValid = false;
    }

    public String[] getChannelTips() {
        return this.channelTips;
    }

    public void setChannelTips(String[] channelTips) {
        this.channelTips = channelTips;
        this.boxesValid = false;
    }

    public Insets getBoxInsets() {
        return this.boxInsets;
    }

    public void setBoxInsets(Insets boxInsets) {
        if (boxInsets == null) {
            return;
        }
        this.boxInsets = boxInsets;
        this.boxesValid = false;
    }

    public int getChannelMask() {
        return this.channelMask;
    }

    public synchronized void setChannelMask(int channelMask) {
        int oldMask = this.channelMask;
        this.channelMask = channelMask;
        this.refresh();
        this.firePropertyChange(PROPERTY_CHANNEL_MASK, oldMask, channelMask);
    }

    @Override
    public void setValue(Object value) {
        int mask = 0;
        if (value != null) {
            if (value instanceof String) {
                String s = (String)value;
                try {
                    mask = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {}
            } else if (value instanceof Number) {
                Number n = (Number)value;
                mask = n.intValue();
            }
        }
        this.setChannelMask(mask);
    }

    @Override
    public Object getValue() {
        return String.valueOf(this.channelMask);
    }

    @Override
    public String getJavaInitializationString() {
        return String.valueOf(this.channelMask);
    }

    @Override
    public String getAsText() {
        return String.valueOf(this.channelMask);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        this.setValue(text);
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JCheckBox[] boxes = this.checkboxes;
        int num = boxes == null ? 0 : boxes.length;
        for (int i = 0; i < num; ++i) {
            boxes[i].setEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            int num;
            this.refreshing = true;
            int newMask = this.channelMask;
            JCheckBox[] boxes = this.checkboxes;
            int n = num = boxes == null ? 0 : boxes.length;
            if (num > this.channelCount) {
                num = this.channelCount;
            }
            if (!this.boxesValid || num != this.channelCount) {
                this.removeAll();
                JCheckBox[] arr = new JCheckBox[this.channelCount];
                for (int i = 0; i < this.channelCount; ++i) {
                    String tip;
                    String name;
                    JCheckBox box;
                    JCheckBox jCheckBox = box = i < num ? boxes[i] : null;
                    if (box == null) {
                        box = new JCheckBox();
                        box.addItemListener(this.boxHandler);
                    }
                    box.setEnabled(this.isEnabled());
                    String string = name = this.channelNames != null && i < this.channelNames.length ? this.channelNames[i] : null;
                    if (name == null) {
                        name = "";
                    }
                    box.setText(name);
                    String string2 = tip = this.channelTips != null && this.channelTips.length > i ? this.channelTips[i] : null;
                    if (tip == null) {
                        tip = "Channel " + (i + 1);
                    }
                    box.setToolTipText(tip);
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.gridx = i;
                    gbc.gridy = 0;
                    gbc.insets = this.boxInsets;
                    this.add((Component)box, gbc);
                    arr[i] = box;
                }
                this.checkboxes = boxes = arr;
                this.boxesValid = true;
                num = this.channelCount;
                this.validate();
                this.repaint();
            }
            int mask = 1;
            for (int i = 0; i < num; ++i) {
                boolean sel;
                boolean bl = sel = (newMask & mask) == 0;
                if (boxes[i].isSelected() != sel) {
                    boxes[i].setSelected(sel);
                }
                mask <<= 1;
            }
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void apply() {
        int num;
        int newMask = this.channelMask;
        JCheckBox[] boxes = this.checkboxes;
        int n = num = boxes == null ? 0 : boxes.length;
        if (num > this.channelCount) {
            num = this.channelCount;
        }
        int mask = 1;
        for (int i = 0; i < num; ++i) {
            newMask |= mask;
            if (boxes[i].isSelected()) {
                newMask ^= mask;
            }
            mask <<= 1;
        }
        this.setChannelMask(newMask);
    }

    protected class BoxHandler
    implements ItemListener {
        protected BoxHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!ChannelMaskEditor.this.refreshing) {
                ChannelMaskEditor.this.apply();
            }
        }
    }
}

