/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.FaderCurve;
import com.waxmonster.fader.impl.AbstractFaderCurve;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.Customizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CommonFaderCurveCustomizer
extends JPanel
implements Customizer {
    private static final long serialVersionUID = -6681928356668199692L;
    private static final String PROPERTY_DECAY = "decay";
    private static final String PROPERTY_CUT_IN = "cutIn";
    private static final String PROPERTY_NAME = "name";
    private static final int SLIDER_MAX = 1000;
    private FaderCurve faderCurve;
    private boolean refreshing;
    private float minimumCutIn = 1.0E-4f;
    private JTextField textFieldName;
    private JSlider sliderCutin;
    private JSlider sliderDecay;

    public CommonFaderCurveCustomizer() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblName = new JLabel("Name:");
        GridBagConstraints gbc_lblName = new GridBagConstraints();
        gbc_lblName.insets = new Insets(4, 4, 5, 4);
        gbc_lblName.anchor = 17;
        gbc_lblName.gridx = 0;
        gbc_lblName.gridy = 0;
        this.add((Component)lblName, gbc_lblName);
        this.textFieldName = new JTextField();
        this.textFieldName.setOpaque(false);
        GridBagConstraints gbc_textFieldName = new GridBagConstraints();
        gbc_textFieldName.insets = new Insets(4, 4, 4, 4);
        gbc_textFieldName.fill = 2;
        gbc_textFieldName.gridx = 1;
        gbc_textFieldName.gridy = 0;
        this.add((Component)this.textFieldName, gbc_textFieldName);
        this.textFieldName.setColumns(10);
        JLabel lblCutin = new JLabel("Cut-In:");
        GridBagConstraints gbc_lblCutin = new GridBagConstraints();
        gbc_lblCutin.anchor = 17;
        gbc_lblCutin.insets = new Insets(4, 4, 4, 4);
        gbc_lblCutin.gridx = 0;
        gbc_lblCutin.gridy = 1;
        this.add((Component)lblCutin, gbc_lblCutin);
        this.sliderCutin = new JSlider();
        this.sliderCutin.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CommonFaderCurveCustomizer.this.refreshing) {
                    CommonFaderCurveCustomizer.this.applyCutIn();
                }
            }
        });
        this.sliderCutin.setOpaque(false);
        GridBagConstraints gbc_sliderCutin = new GridBagConstraints();
        gbc_sliderCutin.fill = 2;
        gbc_sliderCutin.insets = new Insets(4, 0, 4, 0);
        gbc_sliderCutin.gridx = 1;
        gbc_sliderCutin.gridy = 1;
        this.add((Component)this.sliderCutin, gbc_sliderCutin);
        JLabel lblDecay = new JLabel("Decay:");
        GridBagConstraints gbc_lblDecay = new GridBagConstraints();
        gbc_lblDecay.anchor = 17;
        gbc_lblDecay.insets = new Insets(0, 4, 4, 4);
        gbc_lblDecay.gridx = 0;
        gbc_lblDecay.gridy = 2;
        this.add((Component)lblDecay, gbc_lblDecay);
        this.sliderDecay = new JSlider();
        this.sliderDecay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!CommonFaderCurveCustomizer.this.refreshing) {
                    CommonFaderCurveCustomizer.this.applyDecay();
                }
            }
        });
        this.sliderDecay.setOpaque(false);
        GridBagConstraints gbc_sliderDecay = new GridBagConstraints();
        gbc_sliderDecay.insets = new Insets(4, 0, 4, 0);
        gbc_sliderDecay.fill = 2;
        gbc_sliderDecay.gridx = 1;
        gbc_sliderDecay.gridy = 2;
        this.add((Component)this.sliderDecay, gbc_sliderDecay);
        this.initCommonFaderCurveCustomizer();
    }

    public FaderCurve getFaderCurve() {
        return this.faderCurve;
    }

    public void setFaderCurve(FaderCurve faderCurve) {
        this.faderCurve = faderCurve;
        this.refresh();
    }

    @Override
    public void setObject(Object bean) {
        this.setFaderCurve((FaderCurve)bean);
    }

    protected void initCommonFaderCurveCustomizer() {
        this.textFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (!CommonFaderCurveCustomizer.this.refreshing) {
                    CommonFaderCurveCustomizer.this.applyName();
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (!CommonFaderCurveCustomizer.this.refreshing) {
                    CommonFaderCurveCustomizer.this.applyName();
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                if (!CommonFaderCurveCustomizer.this.refreshing) {
                    CommonFaderCurveCustomizer.this.applyName();
                }
            }
        });
        this.sliderCutin.setMinimum(0);
        this.sliderCutin.setMaximum(1000);
        this.sliderDecay.setMinimum(0);
        this.sliderDecay.setMaximum(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void refresh() {
        try {
            int decayValue;
            int cutInValue;
            this.refreshing = true;
            String name = null;
            float cutIn = this.minimumCutIn;
            float decay = 1.0f;
            FaderCurve curve = this.faderCurve;
            if (curve != null && curve instanceof AbstractFaderCurve) {
                AbstractFaderCurve afc = (AbstractFaderCurve)curve;
                name = afc.getName();
                cutIn = afc.getCutIn();
                decay = afc.getDecay();
            }
            if (name == null) {
                name = "";
            }
            if ((cutInValue = Math.round(1000.0f * cutIn)) < 0) {
                cutInValue = 0;
            }
            if (cutInValue > 1000) {
                cutInValue = 1000;
            }
            if ((decayValue = Math.round(1000.0f * decay)) < 0) {
                decayValue = 0;
            }
            if (decayValue > 1000) {
                decayValue = 1000;
            }
            this.textFieldName.setText(name);
            this.sliderCutin.setValue(cutInValue);
            this.sliderDecay.setValue(decayValue);
        }
        finally {
            this.refreshing = false;
        }
    }

    protected void applyName() {
        FaderCurve curve = this.faderCurve;
        if (curve != null && curve instanceof AbstractFaderCurve) {
            AbstractFaderCurve afc = (AbstractFaderCurve)curve;
            String oldName = afc.getName();
            String newName = this.textFieldName.getText();
            afc.setName(newName);
            this.firePropertyChange(PROPERTY_NAME, oldName, newName);
        }
    }

    protected void applyCutIn() {
        FaderCurve curve = this.faderCurve;
        if (curve != null && curve instanceof AbstractFaderCurve) {
            AbstractFaderCurve afc = (AbstractFaderCurve)curve;
            float oldCutIn = afc.getCutIn();
            float newCutIn = (float)this.sliderCutin.getValue() / 1000.0f;
            if (newCutIn < this.minimumCutIn) {
                newCutIn = this.minimumCutIn;
            }
            afc.setCutIn(newCutIn);
            this.firePropertyChange(PROPERTY_CUT_IN, oldCutIn, newCutIn);
        }
    }

    protected void applyDecay() {
        FaderCurve curve = this.faderCurve;
        if (curve != null && curve instanceof AbstractFaderCurve) {
            AbstractFaderCurve afc = (AbstractFaderCurve)curve;
            float oldDecay = afc.getDecay();
            float newDecay = (float)this.sliderDecay.getValue() / 1000.0f;
            afc.setDecay(newDecay);
            this.firePropertyChange(PROPERTY_DECAY, oldDecay, newDecay);
        }
    }

    protected JSlider getSliderCutin() {
        return this.sliderCutin;
    }

    protected JSlider getSliderDecay() {
        return this.sliderDecay;
    }

    protected JTextField getTextFieldName() {
        return this.textFieldName;
    }

    public float getMinimumCutIn() {
        return this.minimumCutIn;
    }

    public void setMinimumCutIn(float minimumCutIn) {
        this.minimumCutIn = minimumCutIn;
    }
}

