/*
 * Decompiled with CFR 0.152.
 */
package com.waxmonster.fader.impl;

import com.waxmonster.fader.impl.AbstractFaderCurve;

public class ExponentialFaderCurve
extends AbstractFaderCurve {
    private static final long serialVersionUID = -459795534322998200L;
    private float exponent;

    public ExponentialFaderCurve() {
        this(1.0f);
    }

    public ExponentialFaderCurve(float exponent) {
        this.exponent = exponent;
    }

    @Override
    protected float getVolumeImpl(float value) {
        return (float)Math.pow(value, this.exponent);
    }

    public float getExponent() {
        return this.exponent;
    }

    public void setExponent(float exponent) {
        this.exponent = exponent;
    }

    @Override
    public String toString() {
        return super.toString() + "[exponent=" + this.exponent + "]";
    }
}

